/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.helpers.Vec3dPool;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\f\u001a\u00060\u0004j\u0002`\u0005H\u0002\u001a\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u001a*\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f\u001a\u001a\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u001a\u001a\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017\u001a\u0012\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u0012\u0010\u001f\u001a\u00060\u001cj\u0002`\u001d*\u00060\u0004j\u0002`\u0005\u001a\u000e\u0010 \u001a\u00020\u001c*\u00060\u001cj\u0002`\u001d\u001a\u000e\u0010 \u001a\u00020\u001c*\u00060\u0004j\u0002`\u0005\u001a\u0016\u0010!\u001a\u00020\u001c*\u00060\u001cj\u0002`\u001d2\u0006\u0010\"\u001a\u00020\u0001\u001a\u0016\u0010!\u001a\u00020\u001c*\u00060\u0004j\u0002`\u00052\u0006\u0010\"\u001a\u00020\u0001\u001a&\u0010#\u001a\u00020\u0001*\u00060\u001cj\u0002`\u001d2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f\u001a\u0016\u0010#\u001a\u00020'*\u00060\u001cj\u0002`\u001d2\u0006\u0010(\u001a\u00020'\u001a\u0016\u0010#\u001a\u00020\u0001*\u00060\u001cj\u0002`\u001d2\u0006\u0010\"\u001a\u00020\u0001\u001a\u0016\u0010#\u001a\u00020\u0001*\u00060\u001cj\u0002`\u001d2\u0006\u0010\"\u001a\u00020\u0017\u001a&\u0010#\u001a\u00020\u0001*\u00060\u0004j\u0002`\u00052\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f\u001a\u0016\u0010#\u001a\u00020'*\u00060\u0004j\u0002`\u00052\u0006\u0010(\u001a\u00020'\u001a\u0016\u0010#\u001a\u00020\u0001*\u00060\u0004j\u0002`\u00052\u0006\u0010\"\u001a\u00020\u0001\u001a\u0016\u0010#\u001a\u00020\u0001*\u00060\u0004j\u0002`\u00052\u0006\u0010\"\u001a\u00020\u0017\u001a\u001a\u0010)\u001a\u00060\u001cj\u0002`\u001d*\u00060\u0004j\u0002`\u00052\u0006\u0010\"\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b*\n\u0010*\"\u00020\u001c2\u00020\u001c*\n\u0010+\"\u00020\u00042\u00020\u0004\u00a8\u0006,"}, d2={"BLOCK_CENTER", "Lnet/minecraft/util/math/Vec3d;", "I", "IDENTITY", "Ljavax/vecmath/Matrix3f;", "Lcom/teamwizardry/librarianlib/features/math/LinearTransformation;", "J", "K", "javax", "Ljavax/vecmath/Vector3f;", "getJavax", "(Lnet/minecraft/util/math/Vec3d;)Ljavax/vecmath/Vector3f;", "identity", "rotationMatrix", "xAngle", "", "yAngle", "zAngle", "angle", "axisX", "axisY", "axisZ", "axis", "Lnet/minecraft/util/math/Vec3i;", "from", "Lnet/minecraft/util/EnumFacing;", "to", "translation", "Ljavax/vecmath/Matrix4f;", "Lcom/teamwizardry/librarianlib/features/math/AffineTransformation;", "translate", "affine", "aroundCenter", "aroundPoint", "point", "rotate", "x", "y", "z", "Lnet/minecraft/util/math/AxisAlignedBB;", "boundingBox", "withTranslation", "AffineTransformation", "LinearTransformation", "librarianlib-1.12.2"})
@JvmName(name="Rotations3D")
public final class Rotations3D {
    private static final Vec3d I;
    private static final Vec3d J;
    private static final Vec3d K;
    private static final Vec3d BLOCK_CENTER;
    private static final Matrix3f IDENTITY;

    private static final Vector3f getJavax(@NotNull Vec3d $receiver) {
        return new Vector3f((float)$receiver.field_72450_a, (float)$receiver.field_72448_b, (float)$receiver.field_72449_c);
    }

    private static final Matrix3f identity() {
        Matrix3f matrix3f;
        Matrix3f $receiver = matrix3f = new Matrix3f();
        $receiver.setIdentity();
        return matrix3f;
    }

    @NotNull
    public static final Matrix3f rotationMatrix(double xAngle, double yAngle, double zAngle) {
        return CommonUtilMethods.times(CommonUtilMethods.times(Rotations3D.rotationMatrix(xAngle, I), Rotations3D.rotationMatrix(yAngle, J)), Rotations3D.rotationMatrix(zAngle, K));
    }

    @NotNull
    public static final Matrix3f rotationMatrix(double angle, double axisX, double axisY, double axisZ) {
        Matrix3f matrix3f;
        Matrix3f $receiver = matrix3f = new Matrix3f();
        $receiver.set(new AxisAngle4d(axisX, axisY, axisZ, angle));
        return matrix3f;
    }

    @NotNull
    public static final Matrix3f rotationMatrix(double angle, @NotNull Vec3i axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return Rotations3D.rotationMatrix(angle, (double)axis.func_177958_n() * 1.0, (double)axis.func_177956_o() * 1.0, (double)axis.func_177952_p() * 1.0);
    }

    @NotNull
    public static final Matrix3f rotationMatrix(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return Rotations3D.rotationMatrix(angle, axis.field_72450_a, axis.field_72448_b, axis.field_72449_c);
    }

    @NotNull
    public static final Matrix3f rotationMatrix(@NotNull Vec3d from, @NotNull Vec3d to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        if (Intrinsics.areEqual(from, CommonUtilMethods.unaryMinus(to))) {
            Matrix3f matrix3f;
            Matrix3f $receiver = matrix3f = Rotations3D.identity();
            $receiver.negate();
            return matrix3f;
        }
        return Rotations3D.rotationMatrix(CommonUtilMethods.angle(from, to), CommonUtilMethods.cross(from, to));
    }

    @NotNull
    public static final Matrix3f rotationMatrix(@NotNull Vec3i from, @NotNull Vec3i to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        if (Intrinsics.areEqual(from, CommonUtilMethods.unaryMinus(to))) {
            Matrix3f matrix3f;
            Matrix3f $receiver = matrix3f = Rotations3D.identity();
            $receiver.negate();
            return matrix3f;
        }
        return Rotations3D.rotationMatrix(CommonUtilMethods.angle(from, to), CommonUtilMethods.cross(from, to));
    }

    @NotNull
    public static final Matrix3f rotationMatrix(@NotNull EnumFacing from, @NotNull EnumFacing to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Vec3i vec3i = from.func_176730_m();
        Intrinsics.checkExpressionValueIsNotNull(vec3i, "from.directionVec");
        Vec3i vec3i2 = to.func_176730_m();
        Intrinsics.checkExpressionValueIsNotNull(vec3i2, "to.directionVec");
        return Rotations3D.rotationMatrix(vec3i, vec3i2);
    }

    @NotNull
    public static final Matrix4f translation(@NotNull Vec3d translate) {
        Intrinsics.checkParameterIsNotNull(translate, "translate");
        return new Matrix4f(IDENTITY, Rotations3D.getJavax(translate), 1.0f);
    }

    @NotNull
    public static final Matrix4f affine(@NotNull Matrix3f $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Vec3d vec3d = Vec3d.field_186680_a;
        Intrinsics.checkExpressionValueIsNotNull(vec3d, "Vec3d.ZERO");
        return Rotations3D.withTranslation($receiver, vec3d);
    }

    @NotNull
    public static final Matrix4f withTranslation(@NotNull Matrix3f $receiver, @NotNull Vec3d point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return new Matrix4f($receiver, Rotations3D.getJavax(point), 1.0f);
    }

    @NotNull
    public static final Matrix4f aroundCenter(@NotNull Matrix3f $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return Rotations3D.aroundCenter(Rotations3D.affine($receiver));
    }

    @NotNull
    public static final Matrix4f aroundPoint(@NotNull Matrix3f $receiver, @NotNull Vec3d point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return Rotations3D.aroundPoint(Rotations3D.affine($receiver), point);
    }

    @NotNull
    public static final Matrix4f aroundCenter(@NotNull Matrix4f $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return Rotations3D.aroundPoint($receiver, BLOCK_CENTER);
    }

    @NotNull
    public static final Matrix4f aroundPoint(@NotNull Matrix4f $receiver, @NotNull Vec3d point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return CommonUtilMethods.times(CommonUtilMethods.times(Rotations3D.translation(point), $receiver), Rotations3D.translation(CommonUtilMethods.unaryMinus(point)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Vec3d rotate(@NotNull Matrix3f $receiver, double x2, double y, double z) {
        void y$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        double newX = (double)$receiver.m00 * x2 + (double)$receiver.m01 * y + (double)$receiver.m02 * z;
        double newY = (double)$receiver.m10 * x2 + (double)$receiver.m11 * y + (double)$receiver.m12 * z;
        double newZ = (double)$receiver.m20 * x2 + (double)$receiver.m21 * y + (double)$receiver.m22 * z;
        double d = newX;
        double d2 = newY;
        double z$iv = newZ;
        return Vec3dPool.create((double)x$iv, (double)y$iv, z$iv);
    }

    @NotNull
    public static final Vec3d rotate(@NotNull Matrix3f $receiver, @NotNull Vec3d point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return Rotations3D.rotate($receiver, point.field_72450_a, point.field_72448_b, point.field_72449_c);
    }

    @NotNull
    public static final Vec3d rotate(@NotNull Matrix3f $receiver, @NotNull Vec3i point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return Rotations3D.rotate($receiver, (double)point.func_177958_n() * 1.0, (double)point.func_177956_o() * 1.0, (double)point.func_177952_p() * 1.0);
    }

    @NotNull
    public static final AxisAlignedBB rotate(@NotNull Matrix3f $receiver, @NotNull AxisAlignedBB boundingBox) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(boundingBox, "boundingBox");
        double bbMinX = boundingBox.field_72340_a;
        double bbMinY = boundingBox.field_72338_b;
        double bbMinZ = boundingBox.field_72339_c;
        double bbMaxX = boundingBox.field_72336_d;
        double bbMaxY = boundingBox.field_72337_e;
        double bbMaxZ = boundingBox.field_72334_f;
        Vec3d p1 = Rotations3D.rotate($receiver, bbMinX, bbMinY, bbMinZ);
        Vec3d p2 = Rotations3D.rotate($receiver, bbMinX, bbMinY, bbMaxZ);
        Vec3d p3 = Rotations3D.rotate($receiver, bbMinX, bbMaxY, bbMinZ);
        Vec3d p4 = Rotations3D.rotate($receiver, bbMinX, bbMaxY, bbMaxZ);
        Vec3d p5 = Rotations3D.rotate($receiver, bbMaxX, bbMinY, bbMinZ);
        Vec3d p6 = Rotations3D.rotate($receiver, bbMaxX, bbMinY, bbMaxZ);
        Vec3d p7 = Rotations3D.rotate($receiver, bbMaxX, bbMaxY, bbMinZ);
        Vec3d p8 = Rotations3D.rotate($receiver, bbMaxX, bbMaxY, bbMaxZ);
        double d = p1.field_72450_a;
        double d2 = p2.field_72450_a;
        double d3 = p3.field_72450_a;
        double d4 = p4.field_72450_a;
        double d5 = p5.field_72450_a;
        double d6 = p6.field_72450_a;
        double d7 = p7.field_72450_a;
        double d8 = p8.field_72450_a;
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        d3 = Math.min(d3, d4);
        d2 = Math.min(d2, d3);
        double minX = Math.min(d, d2);
        d2 = p1.field_72448_b;
        d3 = p2.field_72448_b;
        d4 = p3.field_72448_b;
        d5 = p4.field_72448_b;
        d6 = p5.field_72448_b;
        d7 = p6.field_72448_b;
        d8 = p7.field_72448_b;
        double d9 = p8.field_72448_b;
        d8 = Math.min(d8, d9);
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        d3 = Math.min(d3, d4);
        double minY = Math.min(d2, d3);
        d3 = p1.field_72449_c;
        d4 = p2.field_72449_c;
        d5 = p3.field_72449_c;
        d6 = p4.field_72449_c;
        d7 = p5.field_72449_c;
        d8 = p6.field_72449_c;
        d9 = p7.field_72449_c;
        double d10 = p8.field_72449_c;
        d9 = Math.min(d9, d10);
        d8 = Math.min(d8, d9);
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        double minZ = Math.min(d3, d4);
        d4 = p1.field_72450_a;
        d5 = p2.field_72450_a;
        d6 = p3.field_72450_a;
        d7 = p4.field_72450_a;
        d8 = p5.field_72450_a;
        d9 = p6.field_72450_a;
        d10 = p7.field_72450_a;
        double d11 = p8.field_72450_a;
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        d6 = Math.max(d6, d7);
        d5 = Math.max(d5, d6);
        double maxX = Math.max(d4, d5);
        d5 = p1.field_72448_b;
        d6 = p2.field_72448_b;
        d7 = p3.field_72448_b;
        d8 = p4.field_72448_b;
        d9 = p5.field_72448_b;
        d10 = p6.field_72448_b;
        d11 = p7.field_72448_b;
        double d12 = p8.field_72448_b;
        d11 = Math.max(d11, d12);
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        d6 = Math.max(d6, d7);
        double maxY = Math.max(d5, d6);
        d6 = p1.field_72449_c;
        d7 = p2.field_72449_c;
        d8 = p3.field_72449_c;
        d9 = p4.field_72449_c;
        d10 = p5.field_72449_c;
        d11 = p6.field_72449_c;
        d12 = p7.field_72449_c;
        double d13 = p8.field_72449_c;
        d12 = Math.max(d12, d13);
        d11 = Math.max(d11, d12);
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        double maxZ = Math.max(d6, d7);
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Vec3d rotate(@NotNull Matrix4f $receiver, double x2, double y, double z) {
        void y$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        double newX = (double)$receiver.m00 * x2 + (double)$receiver.m01 * y + (double)$receiver.m02 * z + (double)$receiver.m03;
        double newY = (double)$receiver.m10 * x2 + (double)$receiver.m11 * y + (double)$receiver.m12 * z + (double)$receiver.m13;
        double newZ = (double)$receiver.m20 * x2 + (double)$receiver.m21 * y + (double)$receiver.m22 * z + (double)$receiver.m23;
        double d = newX;
        double d2 = newY;
        double z$iv = newZ;
        return Vec3dPool.create((double)x$iv, (double)y$iv, z$iv);
    }

    @NotNull
    public static final Vec3d rotate(@NotNull Matrix4f $receiver, @NotNull Vec3d point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return Rotations3D.rotate($receiver, point.field_72450_a, point.field_72448_b, point.field_72449_c);
    }

    @NotNull
    public static final Vec3d rotate(@NotNull Matrix4f $receiver, @NotNull Vec3i point) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(point, "point");
        return Rotations3D.rotate($receiver, (double)point.func_177958_n() * 1.0, (double)point.func_177956_o() * 1.0, (double)point.func_177952_p() * 1.0);
    }

    @NotNull
    public static final AxisAlignedBB rotate(@NotNull Matrix4f $receiver, @NotNull AxisAlignedBB boundingBox) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(boundingBox, "boundingBox");
        double bbMinX = boundingBox.field_72340_a;
        double bbMinY = boundingBox.field_72338_b;
        double bbMinZ = boundingBox.field_72339_c;
        double bbMaxX = boundingBox.field_72336_d;
        double bbMaxY = boundingBox.field_72337_e;
        double bbMaxZ = boundingBox.field_72334_f;
        Vec3d p1 = Rotations3D.rotate($receiver, bbMinX, bbMinY, bbMinZ);
        Vec3d p2 = Rotations3D.rotate($receiver, bbMinX, bbMinY, bbMaxZ);
        Vec3d p3 = Rotations3D.rotate($receiver, bbMinX, bbMaxY, bbMinZ);
        Vec3d p4 = Rotations3D.rotate($receiver, bbMinX, bbMaxY, bbMaxZ);
        Vec3d p5 = Rotations3D.rotate($receiver, bbMaxX, bbMinY, bbMinZ);
        Vec3d p6 = Rotations3D.rotate($receiver, bbMaxX, bbMinY, bbMaxZ);
        Vec3d p7 = Rotations3D.rotate($receiver, bbMaxX, bbMaxY, bbMinZ);
        Vec3d p8 = Rotations3D.rotate($receiver, bbMaxX, bbMaxY, bbMaxZ);
        double d = p1.field_72450_a;
        double d2 = p2.field_72450_a;
        double d3 = p3.field_72450_a;
        double d4 = p4.field_72450_a;
        double d5 = p5.field_72450_a;
        double d6 = p6.field_72450_a;
        double d7 = p7.field_72450_a;
        double d8 = p8.field_72450_a;
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        d3 = Math.min(d3, d4);
        d2 = Math.min(d2, d3);
        double minX = Math.min(d, d2);
        d2 = p1.field_72448_b;
        d3 = p2.field_72448_b;
        d4 = p3.field_72448_b;
        d5 = p4.field_72448_b;
        d6 = p5.field_72448_b;
        d7 = p6.field_72448_b;
        d8 = p7.field_72448_b;
        double d9 = p8.field_72448_b;
        d8 = Math.min(d8, d9);
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        d3 = Math.min(d3, d4);
        double minY = Math.min(d2, d3);
        d3 = p1.field_72449_c;
        d4 = p2.field_72449_c;
        d5 = p3.field_72449_c;
        d6 = p4.field_72449_c;
        d7 = p5.field_72449_c;
        d8 = p6.field_72449_c;
        d9 = p7.field_72449_c;
        double d10 = p8.field_72449_c;
        d9 = Math.min(d9, d10);
        d8 = Math.min(d8, d9);
        d7 = Math.min(d7, d8);
        d6 = Math.min(d6, d7);
        d5 = Math.min(d5, d6);
        d4 = Math.min(d4, d5);
        double minZ = Math.min(d3, d4);
        d4 = p1.field_72450_a;
        d5 = p2.field_72450_a;
        d6 = p3.field_72450_a;
        d7 = p4.field_72450_a;
        d8 = p5.field_72450_a;
        d9 = p6.field_72450_a;
        d10 = p7.field_72450_a;
        double d11 = p8.field_72450_a;
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        d6 = Math.max(d6, d7);
        d5 = Math.max(d5, d6);
        double maxX = Math.max(d4, d5);
        d5 = p1.field_72448_b;
        d6 = p2.field_72448_b;
        d7 = p3.field_72448_b;
        d8 = p4.field_72448_b;
        d9 = p5.field_72448_b;
        d10 = p6.field_72448_b;
        d11 = p7.field_72448_b;
        double d12 = p8.field_72448_b;
        d11 = Math.max(d11, d12);
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        d6 = Math.max(d6, d7);
        double maxY = Math.max(d5, d6);
        d6 = p1.field_72449_c;
        d7 = p2.field_72449_c;
        d8 = p3.field_72449_c;
        d9 = p4.field_72449_c;
        d10 = p5.field_72449_c;
        d11 = p6.field_72449_c;
        d12 = p7.field_72449_c;
        double d13 = p8.field_72449_c;
        d12 = Math.max(d12, d13);
        d11 = Math.max(d11, d12);
        d10 = Math.max(d10, d11);
        d9 = Math.max(d9, d10);
        d8 = Math.max(d8, d9);
        d7 = Math.max(d7, d8);
        double maxZ = Math.max(d6, d7);
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    static {
        Matrix3f matrix3f;
        double y$iv;
        double x$iv;
        double d = 1.0;
        double d2 = 0.0;
        double z$iv = 0.0;
        I = Vec3dPool.create(x$iv, y$iv, z$iv);
        x$iv = 0.0;
        y$iv = 1.0;
        z$iv = 0.0;
        J = Vec3dPool.create(x$iv, y$iv, z$iv);
        x$iv = 0.0;
        y$iv = 0.0;
        z$iv = 1.0;
        K = Vec3dPool.create(x$iv, y$iv, z$iv);
        x$iv = 0.5;
        y$iv = 0.5;
        z$iv = 0.5;
        BLOCK_CENTER = Vec3dPool.create(x$iv, y$iv, z$iv);
        Matrix3f $receiver = matrix3f = new Matrix3f();
        $receiver.setIdentity();
        IDENTITY = matrix3f;
    }
}

