/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util.world;

import fi.dy.masa.justenoughdimensions.config.DimensionTypeEntry;
import fi.dy.masa.justenoughdimensions.util.world.DataDump;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import java.util.List;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DimensionDump
extends DataDump {
    private DimensionDump(int columns) {
        super(columns);
        this.setSort(false);
    }

    public static List<String> getFormattedRegisteredDimensionsDump() {
        DimensionDump dimensionDump = new DimensionDump(6);
        Integer[] ids = DimensionManager.getStaticDimensionIDs();
        for (int i = 0; i < ids.length; ++i) {
            String worldProviderClass;
            DimensionType type = DimensionManager.getProviderType((int)ids[i]);
            if (type == null) continue;
            String dimId = ids[i].toString();
            String typeId = String.valueOf(type.func_186068_a());
            String name = type.func_186065_b();
            String shouldLoadSpawn = String.valueOf(type.shouldLoadSpawn());
            String currentlyLoaded = String.valueOf(DimensionManager.getWorld((int)ids[i]) != null);
            try {
                worldProviderClass = DimensionTypeEntry.getProviderClassFrom(type).getSimpleName();
            }
            catch (Exception e) {
                worldProviderClass = "ERROR";
            }
            dimensionDump.addData(dimId, typeId, name, shouldLoadSpawn, worldProviderClass, currentlyLoaded);
        }
        dimensionDump.addTitle("ID", "Type ID", "Name", "Load Spawn?", "WorldProvider class", "Loaded?");
        dimensionDump.setColumnAlignment(0, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(1, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(3, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(5, DataDump.Alignment.RIGHT);
        dimensionDump.setUseColumnSeparator(true);
        return dimensionDump.getLines();
    }

    public static List<String> getFormattedLoadedDimensionsDump() {
        DimensionDump dimensionDump = new DimensionDump(7);
        Integer[] ids = DimensionManager.getIDs();
        for (int i = 0; i < ids.length; ++i) {
            String worldProviderClass;
            WorldServer world = DimensionManager.getWorld((int)ids[i]);
            DimensionType type = DimensionManager.getProviderType((int)ids[i]);
            if (world == null || type == null) continue;
            String dimId = ids[i].toString();
            String typeId = String.valueOf(type.func_186068_a());
            String name = type.func_186065_b();
            String shouldLoadSpawn = String.valueOf(type.shouldLoadSpawn());
            String loadedChunks = String.valueOf(WorldUtils.getLoadedChunkCount(world));
            String loadedEntities = String.valueOf(world.field_72996_f.size());
            try {
                worldProviderClass = DimensionTypeEntry.getProviderClassFrom(type).getSimpleName();
            }
            catch (Exception e) {
                worldProviderClass = "ERROR";
            }
            dimensionDump.addData(dimId, typeId, name, shouldLoadSpawn, worldProviderClass, loadedChunks, loadedEntities);
        }
        dimensionDump.addTitle("ID", "Type ID", "Name", "Load Spawn?", "WorldProvider class", "Loaded chunks", "Loaded entities");
        dimensionDump.setColumnAlignment(0, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(1, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(3, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(5, DataDump.Alignment.RIGHT);
        dimensionDump.setColumnAlignment(6, DataDump.Alignment.RIGHT);
        dimensionDump.setUseColumnSeparator(true);
        return dimensionDump.getLines();
    }
}

