/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PlayerInventoryHandler {
    public static final PlayerInventoryHandler INSTANCE = new PlayerInventoryHandler();
    private final List<InventoryHandler> handlers = new ArrayList<InventoryHandler>();

    private PlayerInventoryHandler() {
        this.handlers.add(new InventoryHandler("player_inv", InventoryViewPlayerInventory::new));
        this.handlers.add(new InventoryHandler("ender_chest", InventoryViewEnderChest::new));
    }

    public PlayerInventoryHandler addHandler(InventoryHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public boolean savePlayerInventories(EntityPlayer player, NBTTagCompound nbt) {
        boolean success = true;
        for (InventoryHandler handler : this.handlers) {
            success &= handler.writeInventory(player, nbt);
        }
        return success;
    }

    public boolean restorePlayerInventories(EntityPlayer player, @Nullable NBTTagCompound nbt) {
        boolean success = true;
        for (InventoryHandler handler : this.handlers) {
            success &= handler.readInventory(player, nbt);
        }
        return success;
    }

    public static class InventoryViewEnderChest
    implements IInventoryView {
        private final EntityPlayer player;

        public InventoryViewEnderChest(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public int getSlotCount() {
            return this.player.func_71005_bN().func_70302_i_();
        }

        @Override
        public ItemStack getStack(int slot) {
            return this.player.func_71005_bN().func_70301_a(slot);
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            this.player.func_71005_bN().func_70299_a(slot, stack);
        }
    }

    public static class InventoryViewPlayerInventory
    implements IInventoryView {
        private final EntityPlayer player;

        public InventoryViewPlayerInventory(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public int getSlotCount() {
            return this.player.field_71071_by.func_70302_i_();
        }

        @Override
        public ItemStack getStack(int slot) {
            return this.player.field_71071_by.func_70301_a(slot);
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            this.player.field_71071_by.func_70299_a(slot, stack);
        }
    }

    public static interface IInventoryView {
        public int getSlotCount();

        public ItemStack getStack(int var1);

        public void setStack(int var1, ItemStack var2);
    }

    public static class InventoryHandler {
        protected final String tagName;
        protected final Function<EntityPlayer, IInventoryView> inventoryRetriever;

        public InventoryHandler(String tagName, Function<EntityPlayer, IInventoryView> inventoryRetriever) {
            this.tagName = tagName;
            this.inventoryRetriever = inventoryRetriever;
        }

        public boolean readInventory(EntityPlayer player, @Nullable NBTTagCompound nbt) {
            IInventoryView inv = this.inventoryRetriever.apply(player);
            if (inv != null) {
                return this.readInventory(inv, nbt);
            }
            return false;
        }

        public boolean writeInventory(EntityPlayer player, NBTTagCompound nbt) {
            IInventoryView inv = this.inventoryRetriever.apply(player);
            if (inv != null) {
                return this.writeInventory(inv, nbt);
            }
            return false;
        }

        protected boolean readInventory(IInventoryView inv, @Nullable NBTTagCompound nbt) {
            int invSize = inv.getSlotCount();
            for (int slot = 0; slot < invSize; ++slot) {
                inv.setStack(slot, ItemStack.field_190927_a);
            }
            if (nbt != null && nbt.func_150297_b(this.tagName, 9)) {
                NBTTagList list = nbt.func_150295_c(this.tagName, 10);
                int listSize = list.func_74745_c();
                for (int i = 0; i < listSize; ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    int slot = tag.func_74762_e("Slot");
                    ItemStack stack = new ItemStack(tag);
                    if (slot < 0 || slot >= invSize || stack.func_190926_b()) continue;
                    inv.setStack(slot, stack);
                }
                return true;
            }
            return false;
        }

        protected boolean writeInventory(IInventoryView inv, NBTTagCompound nbt) {
            NBTTagList list = new NBTTagList();
            int invSize = inv.getSlotCount();
            for (int slot = 0; slot < invSize; ++slot) {
                ItemStack stack = inv.getStack(slot);
                if (stack.func_190926_b()) continue;
                NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                tag.func_74768_a("Slot", slot);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(this.tagName, (NBTBase)list);
            return false;
        }
    }
}

