/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.crafting.FacadeRecipe;
import gregtech.common.items.MetaItems;
import gregtech.loaders.recipe.VanillaOverrideRecipes;
import gregtech.loaders.recipe.VanillaStandardRecipes;
import gregtech.loaders.recipe.handlers.ToolRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;

public class CraftingRecipeLoader {
    public static void init() {
        CraftingRecipeLoader.loadCraftingRecipes();
        GTLog.logger.info("Modifying vanilla recipes according to config. DON'T BE SCARED OF FML's WARNING ABOUT DANGEROUS ALTERNATIVE PREFIX.");
        VanillaOverrideRecipes.init();
        VanillaStandardRecipes.init();
    }

    private static void loadCraftingRecipes() {
        CraftingRecipeLoader.registerFacadeRecipe(Materials.Iron, 4);
        ToolRecipeHandler.registerPowerUnitRecipes();
        ToolRecipeHandler.registerCustomToolRecipes();
        ModHandler.addShapedRecipe("small_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeSmallFluid, Materials.Wood), "sWr", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        ModHandler.addShapedRecipe("normal_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeNormalFluid, Materials.Wood), "WWW", "s r", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        ModHandler.addShapedRecipe("large_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeLargeFluid, Materials.Wood), "WWW", "s r", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        ModHandler.addShapedRecipe("small_treated_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeSmallFluid, Materials.TreatedWood), "sWr", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.TreatedWood));
        ModHandler.addShapedRecipe("normal_treated_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeNormalFluid, Materials.TreatedWood), "WWW", "s r", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.TreatedWood));
        ModHandler.addShapedRecipe("large_treated_wooden_pipe", OreDictUnifier.get(OrePrefix.pipeLargeFluid, Materials.TreatedWood), "WWW", "s r", "WWW", Character.valueOf('W'), new UnificationEntry(OrePrefix.plank, Materials.TreatedWood));
        ModHandler.addShapelessRecipe("integrated_circuit", IntCircuitIngredient.getIntegratedCircuit(0), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV));
        ModHandler.addShapedRecipe("item_filter", MetaItems.ITEM_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
        ModHandler.addShapedRecipe("fluid_filter_lapis", MetaItems.FLUID_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Lapis));
        ModHandler.addShapedRecipe("fluid_filter_lazurite", MetaItems.FLUID_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Lazurite));
        ModHandler.addShapedRecipe("fluid_filter_sodalite", MetaItems.FLUID_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Sodalite));
        ModHandler.addShapedRecipe("ore_dictionary_filter_olivine", MetaItems.ORE_DICTIONARY_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Olivine));
        ModHandler.addShapedRecipe("ore_dictionary_filter_emerald", MetaItems.ORE_DICTIONARY_FILTER.getStackForm(), "XXX", "XYX", "XXX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('Y'), new UnificationEntry(OrePrefix.plate, Materials.Emerald));
        ModHandler.addShapedRecipe("smart_item_filter_olivine", MetaItems.SMART_FILTER.getStackForm(), "XEX", "XCX", "XEX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV), Character.valueOf('E'), new UnificationEntry(OrePrefix.plate, Materials.Olivine));
        ModHandler.addShapedRecipe("smart_item_filter_emerald", MetaItems.SMART_FILTER.getStackForm(), "XEX", "XCX", "XEX", Character.valueOf('X'), new UnificationEntry(OrePrefix.foil, Materials.Zinc), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV), Character.valueOf('E'), new UnificationEntry(OrePrefix.plate, Materials.Emerald));
        ModHandler.addShapedRecipe("plank_to_wooden_shape", MetaItems.WOODEN_FORM_EMPTY.getStackForm(), "   ", " X ", "s  ", Character.valueOf('X'), new UnificationEntry(OrePrefix.plank, Materials.Wood));
        ModHandler.addShapedRecipe("wooden_shape_brick", MetaItems.WOODEN_FORM_BRICK.getStackForm(), "k ", " X", Character.valueOf('X'), MetaItems.WOODEN_FORM_EMPTY.getStackForm());
        if (ConfigHolder.recipes.harderBrickRecipes) {
            ModHandler.addShapelessRecipe("compressed_clay", MetaItems.COMPRESSED_CLAY.getStackForm(), MetaItems.WOODEN_FORM_BRICK.getStackForm(), new ItemStack(Items.field_151119_aD));
            ModHandler.addSmeltingRecipe(MetaItems.COMPRESSED_CLAY.getStackForm(), new ItemStack(Items.field_151118_aC), 0.3f);
        }
        ModHandler.addShapedRecipe("compressed_coke_clay", MetaItems.COMPRESSED_COKE_CLAY.getStackForm(3), "XXX", "SYS", "SSS", Character.valueOf('Y'), MetaItems.WOODEN_FORM_BRICK.getStackForm(), Character.valueOf('X'), new ItemStack(Items.field_151119_aD), Character.valueOf('S'), "sand");
        ModHandler.addShapelessRecipe("fireclay_dust", OreDictUnifier.get(OrePrefix.dust, Materials.Fireclay, 2), new UnificationEntry(OrePrefix.dust, Materials.Brick), new UnificationEntry(OrePrefix.dust, Materials.Clay));
        ModHandler.addSmeltingRecipe(MetaItems.COMPRESSED_COKE_CLAY.getStackForm(), MetaItems.COKE_OVEN_BRICK.getStackForm(), 0.3f);
        ModHandler.addSmeltingRecipe(MetaItems.COMPRESSED_FIRECLAY.getStackForm(), MetaItems.FIRECLAY_BRICK.getStackForm(), 0.3f);
        ModHandler.addSmeltingRecipe(new UnificationEntry(OrePrefix.nugget, Materials.Iron), OreDictUnifier.get(OrePrefix.nugget, Materials.WroughtIron));
        ModHandler.addShapedRecipe("clipboard", MetaItems.CLIPBOARD.getStackForm(), " Sd", "BWR", "PPP", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('R'), new UnificationEntry(OrePrefix.springSmall, Materials.Iron), Character.valueOf('B'), new UnificationEntry(OrePrefix.bolt, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('W'), new UnificationEntry(OrePrefix.plate, Materials.Wood));
        ModHandler.addShapelessRecipe("rubber_wood_planks", MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.RUBBER_PLANK, 4), new ItemStack((Block)MetaBlocks.RUBBER_LOG));
        ModHandler.addShapedRecipe("treated_wood_planks", MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK, 8), "PPP", "PBP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('B'), FluidUtil.getFilledBucket((FluidStack)Materials.Creosote.getFluid(1000)));
        ModHandler.addShapedRecipe("treated_wood_stick_saw", OreDictUnifier.get(OrePrefix.stick, Materials.TreatedWood, ConfigHolder.recipes.nerfWoodCrafting ? 1 : 2), "s", "L", Character.valueOf('L'), MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK));
        if (!ConfigHolder.recipes.nerfWoodCrafting) {
            ModHandler.addShapedRecipe("treated_wood_stick", OreDictUnifier.get(OrePrefix.stick, Materials.TreatedWood, 4), "L", "L", Character.valueOf('L'), MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK));
        }
        ModHandler.addShapedRecipe("rubber_ring", OreDictUnifier.get(OrePrefix.ring, Materials.Rubber), "k", "X", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, Materials.Rubber));
        ModHandler.addShapedRecipe("silicone_rubber_ring", OreDictUnifier.get(OrePrefix.ring, Materials.SiliconeRubber), "k", "P", Character.valueOf('P'), OreDictUnifier.get(OrePrefix.plate, Materials.SiliconeRubber));
        ModHandler.addShapedRecipe("styrene_rubber_ring", OreDictUnifier.get(OrePrefix.ring, Materials.StyreneButadieneRubber), "k", "P", Character.valueOf('P'), OreDictUnifier.get(OrePrefix.plate, Materials.StyreneButadieneRubber));
        ModHandler.addShapelessRecipe("iron_magnetic_stick", OreDictUnifier.get(OrePrefix.stick, Materials.IronMagnetic), new UnificationEntry(OrePrefix.stick, Materials.Iron), new UnificationEntry(OrePrefix.dust, Materials.Redstone), new UnificationEntry(OrePrefix.dust, Materials.Redstone), new UnificationEntry(OrePrefix.dust, Materials.Redstone), new UnificationEntry(OrePrefix.dust, Materials.Redstone));
        ModHandler.addShapedRecipe("component_grinder_diamond", MetaItems.COMPONENT_GRINDER_DIAMOND.getStackForm(), "XSX", "SDS", "XSX", Character.valueOf('X'), new UnificationEntry(OrePrefix.dust, Materials.Diamond), Character.valueOf('S'), new UnificationEntry(OrePrefix.plateDouble, Materials.Steel), Character.valueOf('D'), new UnificationEntry(OrePrefix.gem, Materials.Diamond));
        ModHandler.addShapedRecipe("component_grinder_tungsten", MetaItems.COMPONENT_GRINDER_TUNGSTEN.getStackForm(), "WSW", "SDS", "WSW", Character.valueOf('W'), new UnificationEntry(OrePrefix.plate, Materials.Tungsten), Character.valueOf('S'), new UnificationEntry(OrePrefix.plateDouble, Materials.VanadiumSteel), Character.valueOf('D'), new UnificationEntry(OrePrefix.gem, Materials.Diamond));
        ModHandler.addShapedRecipe("nano_saber", MetaItems.NANO_SABER.getStackForm(), "PIC", "PIC", "XEX", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Platinum), Character.valueOf('I'), new UnificationEntry(OrePrefix.plate, Materials.Ruridit), Character.valueOf('C'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('X'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.EV), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm());
        ModHandler.addShapedRecipe("solar_panel_basic", MetaItems.COVER_SOLAR_PANEL.getStackForm(), "WGW", "CPC", Character.valueOf('W'), MetaItems.SILICON_WAFER.getStackForm(), Character.valueOf('G'), "paneGlass", Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV), Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm());
        ModHandler.addShapedRecipe("solar_panel_ulv", MetaItems.COVER_SOLAR_PANEL_ULV.getStackForm(), "WGW", "CAC", "P P", Character.valueOf('W'), MetaItems.GLOWSTONE_WAFER.getStackForm(), Character.valueOf('G'), "paneGlass", Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.HV), Character.valueOf('P'), OreDictUnifier.get(OrePrefix.plate, Materials.GalliumArsenide), Character.valueOf('A'), OreDictUnifier.get(OrePrefix.wireGtQuadruple, Materials.Graphene));
        ModHandler.addShapedRecipe("solar_panel_lv", MetaItems.COVER_SOLAR_PANEL_LV.getStackForm(), "WGW", "CAC", "P P", Character.valueOf('W'), MetaItems.NAQUADAH_WAFER.getStackForm(), Character.valueOf('G'), MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.TEMPERED_GLASS), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LuV), Character.valueOf('P'), OreDictUnifier.get(OrePrefix.plate, Materials.IndiumGalliumPhosphide), Character.valueOf('A'), OreDictUnifier.get(OrePrefix.wireGtHex, Materials.Graphene));
        ModHandler.addShapedRecipe("universal_fluid_cell", MetaItems.FLUID_CELL_UNIVERSAL.getStackForm(), "C ", "  ", Character.valueOf('C'), MetaItems.FLUID_CELL);
        ModHandler.addShapedRecipe("universal_fluid_cell_revert", MetaItems.FLUID_CELL.getStackForm(), "C ", "  ", Character.valueOf('C'), MetaItems.FLUID_CELL_UNIVERSAL);
        ModHandler.addShapedRecipe("blacklight", MetaItems.BLACKLIGHT.getStackForm(), "SPS", "GRG", "CPK", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.TungstenCarbide), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.TungstenCarbide), Character.valueOf('G'), MetaBlocks.TRANSPARENT_CASING.getItemVariant(BlockGlassCasing.CasingType.LAMINATED_GLASS), Character.valueOf('R'), new UnificationEntry(OrePrefix.spring, Materials.Europium), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.IV), Character.valueOf('K'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Platinum));
        ModHandler.addShapedRecipe(true, "filter_casing", MetaBlocks.CLEANROOM_CASING.getItemVariant(BlockCleanroomCasing.CasingType.FILTER_CASING, 2), "BBB", "III", "MFR", Character.valueOf('B'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('I'), MetaItems.ITEM_FILTER.getStackForm(), Character.valueOf('M'), MetaItems.ELECTRIC_MOTOR_MV.getStackForm(), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Steel), Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Steel));
        ModHandler.addShapedRecipe(true, "filter_casing_sterile", MetaBlocks.CLEANROOM_CASING.getItemVariant(BlockCleanroomCasing.CasingType.FILTER_CASING_STERILE, 2), "BEB", "ISI", "MFR", Character.valueOf('B'), new UnificationEntry(OrePrefix.pipeLargeFluid, Materials.Polybenzimidazole), Character.valueOf('E'), MetaItems.EMITTER_ZPM.getStackForm(), Character.valueOf('I'), MetaItems.ITEM_FILTER.getStackForm(), Character.valueOf('S'), MetaItems.BLACKLIGHT.getStackForm(), Character.valueOf('M'), MetaItems.ELECTRIC_MOTOR_ZPM.getStackForm(), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, Materials.Tritanium), Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.NaquadahAlloy));
        ModHandler.addShapedRecipe("shape_empty", MetaItems.SHAPE_EMPTY.getStackForm(), "hf", "PP", "PP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.Steel));
        ModHandler.addShapedRecipe("shape_extruder_bottle", MetaItems.SHAPE_EXTRUDER_BOTTLE.getStackForm(), "  x", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_RING.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_gear", MetaItems.SHAPE_EXTRUDER_GEAR.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_RING.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_block", MetaItems.SHAPE_EXTRUDER_BLOCK.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_INGOT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_pipe_huge", MetaItems.SHAPE_EXTRUDER_PIPE_HUGE.getStackForm(), "   ", " S ", "  x", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_pipe_large", MetaItems.SHAPE_EXTRUDER_PIPE_LARGE.getStackForm(), "   ", " Sx", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_pipe_normal", MetaItems.SHAPE_EXTRUDER_PIPE_NORMAL.getStackForm(), "  x", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_pipe_small", MetaItems.SHAPE_EXTRUDER_PIPE_SMALL.getStackForm(), " x ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_pipe_tiny", MetaItems.SHAPE_EXTRUDER_PIPE_TINY.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_wire", MetaItems.SHAPE_EXTRUDER_WIRE.getStackForm(), " x ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_ROD.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_ingot", MetaItems.SHAPE_EXTRUDER_INGOT.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_cell", MetaItems.SHAPE_EXTRUDER_CELL.getStackForm(), "   ", " Sx", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_RING.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_ring", MetaItems.SHAPE_EXTRUDER_RING.getStackForm(), "   ", " S ", " x ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_bolt", MetaItems.SHAPE_EXTRUDER_BOLT.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_ROD.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_rod", MetaItems.SHAPE_EXTRUDER_ROD.getStackForm(), "   ", " Sx", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_rod_long", MetaItems.SHAPE_EXTRUDER_ROD_LONG.getStackForm(), "  x", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_ROD.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_plate", MetaItems.SHAPE_EXTRUDER_PLATE.getStackForm(), "x  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_FOIL.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_gear_small", MetaItems.SHAPE_EXTRUDER_GEAR_SMALL.getStackForm(), " x ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EXTRUDER_RING.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_foil", MetaItems.SHAPE_EXTRUDER_FOIL.getStackForm(), "   ", " S ", "  x", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_extruder_rotor", MetaItems.SHAPE_EXTRUDER_ROTOR.getStackForm(), "   ", " S ", "x  ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_rotor", MetaItems.SHAPE_MOLD_ROTOR.getStackForm(), "  h", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_gear_small", MetaItems.SHAPE_MOLD_GEAR_SMALL.getStackForm(), "   ", "   ", "h S", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_name", MetaItems.SHAPE_MOLD_NAME.getStackForm(), "  S", "   ", "h  ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_anvil", MetaItems.SHAPE_MOLD_ANVIL.getStackForm(), "  S", "   ", " h ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_cylinder", MetaItems.SHAPE_MOLD_CYLINDER.getStackForm(), "  S", "   ", "  h", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_nugget", MetaItems.SHAPE_MOLD_NUGGET.getStackForm(), "S h", "   ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_block", MetaItems.SHAPE_MOLD_BLOCK.getStackForm(), "   ", "hS ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_ball", MetaItems.SHAPE_MOLD_BALL.getStackForm(), "   ", " S ", "h  ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_ingot", MetaItems.SHAPE_MOLD_INGOT.getStackForm(), "   ", " S ", " h ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_bottle", MetaItems.SHAPE_MOLD_BOTTLE.getStackForm(), "   ", " S ", "  h", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_credit", MetaItems.SHAPE_MOLD_CREDIT.getStackForm(), "h  ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_gear", MetaItems.SHAPE_MOLD_GEAR.getStackForm(), "   ", " Sh", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapedRecipe("shape_mold_plate", MetaItems.SHAPE_MOLD_PLATE.getStackForm(), " h ", " S ", "   ", Character.valueOf('S'), MetaItems.SHAPE_EMPTY.getStackForm());
        ModHandler.addShapelessRecipe("coin_chocolate", MetaItems.COIN_CHOCOLATE.getStackForm(), new UnificationEntry(OrePrefix.dust, Materials.Cocoa), new UnificationEntry(OrePrefix.foil, Materials.Gold), new ItemStack(Items.field_151117_aB), new UnificationEntry(OrePrefix.dust, Materials.Sugar));
        ModHandler.addShapelessRecipe("credit_copper", MetaItems.CREDIT_COPPER.getStackForm(8), MetaItems.CREDIT_CUPRONICKEL.getStackForm());
        ModHandler.addShapelessRecipe("credit_cupronickel_alt", MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm(), MetaItems.CREDIT_COPPER.getStackForm());
        ModHandler.addShapelessRecipe("credit_cupronickel", MetaItems.CREDIT_CUPRONICKEL.getStackForm(8), MetaItems.CREDIT_SILVER.getStackForm());
        ModHandler.addShapelessRecipe("credit_silver_alt", MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm(), MetaItems.CREDIT_CUPRONICKEL.getStackForm());
        ModHandler.addShapelessRecipe("credit_silver", MetaItems.CREDIT_SILVER.getStackForm(8), MetaItems.CREDIT_GOLD.getStackForm());
        ModHandler.addShapelessRecipe("credit_gold_alt", MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm(), MetaItems.CREDIT_SILVER.getStackForm());
        ModHandler.addShapelessRecipe("credit_gold", MetaItems.CREDIT_GOLD.getStackForm(8), MetaItems.CREDIT_PLATINUM.getStackForm());
        ModHandler.addShapelessRecipe("credit_platinum_alt", MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm(), MetaItems.CREDIT_GOLD.getStackForm());
        ModHandler.addShapelessRecipe("credit_platinum", MetaItems.CREDIT_PLATINUM.getStackForm(8), MetaItems.CREDIT_OSMIUM.getStackForm());
        ModHandler.addShapelessRecipe("credit_osmium_alt", MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm(), MetaItems.CREDIT_PLATINUM.getStackForm());
        ModHandler.addShapelessRecipe("credit_osmium", MetaItems.CREDIT_OSMIUM.getStackForm(8), MetaItems.CREDIT_NAQUADAH.getStackForm());
        ModHandler.addShapelessRecipe("credit_naquadah_alt", MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm(), MetaItems.CREDIT_OSMIUM.getStackForm());
        ModHandler.addShapelessRecipe("credit_naquadah", MetaItems.CREDIT_NAQUADAH.getStackForm(8), MetaItems.CREDIT_NEUTRONIUM.getStackForm());
        ModHandler.addShapelessRecipe("credit_darmstadtium", MetaItems.CREDIT_NEUTRONIUM.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm(), MetaItems.CREDIT_NAQUADAH.getStackForm());
        ModHandler.addShapedRecipe("nightvision_goggles", MetaItems.NIGHTVISION_GOGGLES.getStackForm(), "CSC", "RBR", "LdL", Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.ULV), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Rubber), Character.valueOf('B'), MetaItems.BATTERY_LV_SODIUM, Character.valueOf('L'), new UnificationEntry(OrePrefix.lens, Materials.Glass));
        ModHandler.addShapedRecipe("fluid_jetpack", MetaItems.SEMIFLUID_JETPACK.getStackForm(), "xCw", "SUS", "RIR", Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.LV), Character.valueOf('S'), MetaItems.FLUID_CELL_LARGE_STEEL.getStackForm(), Character.valueOf('U'), MetaItems.ELECTRIC_PUMP_LV.getStackForm(), Character.valueOf('R'), new UnificationEntry(OrePrefix.rotor, Materials.Lead), Character.valueOf('I'), new UnificationEntry(OrePrefix.pipeSmallFluid, Materials.Potin));
        ModHandler.addShapedRecipe("electric_jetpack", MetaItems.ELECTRIC_JETPACK.getStackForm(), "xCd", "TBT", "I I", Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.MV), Character.valueOf('T'), MetaItems.POWER_THRUSTER.getStackForm(), Character.valueOf('B'), MetaItems.BATTERY_MV_LITHIUM.getStackForm(), Character.valueOf('I'), new UnificationEntry(OrePrefix.wireGtDouble, Materials.AnnealedCopper));
        ModHandler.addShapedRecipe("electric_jetpack_advanced", MetaItems.ELECTRIC_JETPACK_ADVANCED.getStackForm(), "xJd", "TBT", "WCW", Character.valueOf('J'), MetaItems.ELECTRIC_JETPACK.getStackForm(), Character.valueOf('T'), MetaItems.POWER_THRUSTER_ADVANCED.getStackForm(), Character.valueOf('B'), MetaItems.BATTERY_HV_LITHIUM.getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Gold), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.HV));
        ModHandler.addShapedRecipe("nano_helmet", MetaItems.NANO_HELMET.getStackForm(), "PPP", "PNP", "xEd", Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('N'), MetaItems.NIGHTVISION_GOGGLES.getStackForm(), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm());
        ModHandler.addShapedRecipe("nano_chestplate", MetaItems.NANO_CHESTPLATE.getStackForm(), "PEP", "PPP", "PPP", Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm());
        ModHandler.addShapedRecipe("nano_leggings", MetaItems.NANO_LEGGINGS.getStackForm(), "PPP", "PEP", "PxP", Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm());
        ModHandler.addShapedRecipe("nano_boots", MetaItems.NANO_BOOTS.getStackForm(), "PxP", "PEP", Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm());
        ModHandler.addShapedRecipe("nano_chestplate_advanced", MetaItems.NANO_CHESTPLATE_ADVANCED.getStackForm(), "xJd", "PNP", "WCW", Character.valueOf('J'), MetaItems.ELECTRIC_JETPACK_ADVANCED.getStackForm(), Character.valueOf('P'), MetaItems.LOW_POWER_INTEGRATED_CIRCUIT.getStackForm(), Character.valueOf('N'), MetaItems.NANO_CHESTPLATE.getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Platinum), Character.valueOf('C'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.IV));
        ModHandler.addShapedRecipe("gravitation_engine", MetaItems.GRAVITATION_ENGINE.getStackForm(), "ESE", "POP", "ESE", Character.valueOf('E'), MetaItems.EMITTER_LuV.getStackForm(), Character.valueOf('S'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Osmium), Character.valueOf('P'), new UnificationEntry(OrePrefix.plateDouble, Materials.Iridium), Character.valueOf('O'), MetaItems.ENERGY_LAPOTRONIC_ORB.getStackForm());
    }

    private static void registerFacadeRecipe(Material material, int facadeAmount) {
        OreIngredient ingredient = new OreIngredient(new UnificationEntry(OrePrefix.plate, material).toString());
        ForgeRegistries.RECIPES.register(new FacadeRecipe(null, (Ingredient)ingredient, facadeAmount).setRegistryName("facade_" + material));
    }
}

