/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.BlankUIHolder;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.integration.jei.GTJeiPlugin;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtech.integration.jei.utils.render.FluidStackTextRenderer;
import gregtech.integration.jei.utils.render.ItemStackTextRenderer;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class RecipeMapCategory
implements IRecipeCategory<GTRecipeWrapper> {
    private final RecipeMap<?> recipeMap;
    private final ModularUI modularUI;
    private final ItemStackHandler importItems;
    private final ItemStackHandler exportItems;
    private final FluidTankList importFluids;
    private final FluidTankList exportFluids;
    private final IDrawable backgroundDrawable;
    private Object iconIngredient;
    private IDrawable icon;
    private static final int FONT_HEIGHT = 9;
    private static final HashMap<RecipeMap<?>, RecipeMapCategory> categoryMap = new HashMap();

    public RecipeMapCategory(RecipeMap<?> recipeMap, IGuiHelper guiHelper) {
        this.recipeMap = recipeMap;
        FluidTank[] importFluidTanks = new FluidTank[recipeMap.getMaxFluidInputs()];
        for (int i = 0; i < importFluidTanks.length; ++i) {
            importFluidTanks[i] = new FluidTank(16000);
        }
        FluidTank[] exportFluidTanks = new FluidTank[recipeMap.getMaxFluidOutputs()];
        for (int i = 0; i < exportFluidTanks.length; ++i) {
            exportFluidTanks[i] = new FluidTank(16000);
        }
        this.importItems = new ItemStackHandler(recipeMap.getMaxInputs());
        this.exportItems = new ItemStackHandler(recipeMap.getMaxOutputs());
        this.importFluids = new FluidTankList(false, (IFluidTank[])importFluidTanks);
        this.exportFluids = new FluidTankList(false, (IFluidTank[])exportFluidTanks);
        this.modularUI = recipeMap.createJeiUITemplate((IItemHandlerModifiable)this.importItems, (IItemHandlerModifiable)this.exportItems, this.importFluids, this.exportFluids, 0).build(new BlankUIHolder(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.modularUI.initWidgets();
        this.backgroundDrawable = guiHelper.createBlankDrawable(this.modularUI.getWidth(), this.modularUI.getHeight() * 2 / 3 + RecipeMapCategory.getPropertyShiftAmount(recipeMap));
        categoryMap.put(recipeMap, this);
    }

    @Nonnull
    public String getUid() {
        return "gregtech:" + this.recipeMap.unlocalizedName;
    }

    @Nonnull
    public String getTitle() {
        return this.recipeMap.getLocalizedName();
    }

    @Nullable
    public IDrawable getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.iconIngredient != null) {
            this.icon = GTJeiPlugin.guiHelper.createDrawableIngredient(this.iconIngredient);
            return this.icon;
        }
        return null;
    }

    public void setIcon(Object icon) {
        if (this.iconIngredient == null) {
            this.iconIngredient = icon;
        }
    }

    @Nonnull
    public String getModName() {
        return "gregtech";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.backgroundDrawable;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull GTRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        for (Widget uiWidget : this.modularUI.guiWidgets.values()) {
            int fluidAmount;
            List inputsList;
            if (uiWidget instanceof SlotWidget) {
                SlotWidget slotWidget = (SlotWidget)uiWidget;
                if (!(slotWidget.getHandle() instanceof SlotItemHandler)) continue;
                SlotItemHandler handle = (SlotItemHandler)slotWidget.getHandle();
                if (handle.getItemHandler() == this.importItems) {
                    itemStackGroup.init(handle.getSlotIndex(), true, (IIngredientRenderer)new ItemStackTextRenderer(recipeWrapper.isNotConsumedItem(handle.getSlotIndex())), slotWidget.getPosition().x + 1, slotWidget.getPosition().y + 1, slotWidget.getSize().width - 2, slotWidget.getSize().height - 2, 0, 0);
                    continue;
                }
                if (handle.getItemHandler() != this.exportItems) continue;
                itemStackGroup.init(this.importItems.getSlots() + handle.getSlotIndex(), false, (IIngredientRenderer)new ItemStackTextRenderer(recipeWrapper.getOutputChance(handle.getSlotIndex() - recipeWrapper.getRecipe().getOutputs().size())), slotWidget.getPosition().x + 1, slotWidget.getPosition().y + 1, slotWidget.getSize().width - 2, slotWidget.getSize().height - 2, 0, 0);
                continue;
            }
            if (!(uiWidget instanceof TankWidget)) continue;
            TankWidget tankWidget = (TankWidget)uiWidget;
            if (this.importFluids.getFluidTanks().contains(tankWidget.fluidTank)) {
                int importIndex = this.importFluids.getFluidTanks().indexOf(tankWidget.fluidTank);
                inputsList = ingredients.getInputs(VanillaTypes.FLUID);
                fluidAmount = 0;
                if (inputsList.size() > importIndex && !((List)inputsList.get(importIndex)).isEmpty()) {
                    fluidAmount = ((FluidStack)((List)inputsList.get((int)importIndex)).get((int)0)).amount;
                }
                fluidStackGroup.init(importIndex, true, (IIngredientRenderer)new FluidStackTextRenderer(fluidAmount, false, tankWidget.getSize().width - 2 * tankWidget.fluidRenderOffset, tankWidget.getSize().height - 2 * tankWidget.fluidRenderOffset, null).setNotConsumed(recipeWrapper.isNotConsumedFluid(importIndex)), tankWidget.getPosition().x + tankWidget.fluidRenderOffset, tankWidget.getPosition().y + tankWidget.fluidRenderOffset, tankWidget.getSize().width - 2 * tankWidget.fluidRenderOffset, tankWidget.getSize().height - 2 * tankWidget.fluidRenderOffset, 0, 0);
                continue;
            }
            if (!this.exportFluids.getFluidTanks().contains(tankWidget.fluidTank)) continue;
            int exportIndex = this.exportFluids.getFluidTanks().indexOf(tankWidget.fluidTank);
            inputsList = ingredients.getOutputs(VanillaTypes.FLUID);
            fluidAmount = 0;
            if (inputsList.size() > exportIndex && !((List)inputsList.get(exportIndex)).isEmpty()) {
                fluidAmount = ((FluidStack)((List)inputsList.get((int)exportIndex)).get((int)0)).amount;
            }
            fluidStackGroup.init(this.importFluids.getFluidTanks().size() + exportIndex, false, (IIngredientRenderer)new FluidStackTextRenderer(fluidAmount, false, tankWidget.getSize().width - 2 * tankWidget.fluidRenderOffset, tankWidget.getSize().height - 2 * tankWidget.fluidRenderOffset, null), tankWidget.getPosition().x + tankWidget.fluidRenderOffset, tankWidget.getPosition().y + tankWidget.fluidRenderOffset, tankWidget.getSize().width - 2 * tankWidget.fluidRenderOffset, tankWidget.getSize().height - 2 * tankWidget.fluidRenderOffset, 0, 0);
        }
        itemStackGroup.addTooltipCallback(recipeWrapper::addItemTooltip);
        fluidStackGroup.addTooltipCallback(recipeWrapper::addFluidTooltip);
        itemStackGroup.set(ingredients);
        fluidStackGroup.set(ingredients);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        for (Widget widget : this.modularUI.guiWidgets.values()) {
            if (widget instanceof ProgressWidget) {
                widget.detectAndSendChanges();
            }
            widget.drawInBackground(0, 0, minecraft.func_184121_ak(), new IRenderContext(){});
            widget.drawInForeground(0, 0);
        }
    }

    public static HashMap<RecipeMap<?>, RecipeMapCategory> getCategoryMap() {
        return categoryMap;
    }

    private static boolean shouldShiftWidgets(@Nonnull RecipeMap<?> recipeMap) {
        return recipeMap.getMaxInputs() + recipeMap.getMaxOutputs() >= 6 || recipeMap.getMaxFluidInputs() + recipeMap.getMaxFluidOutputs() >= 6;
    }

    private static int getPropertyShiftAmount(@Nonnull RecipeMap<?> recipeMap) {
        int maxPropertyCount = 0;
        if (RecipeMapCategory.shouldShiftWidgets(recipeMap)) {
            for (Recipe recipe : recipeMap.getRecipeList()) {
                if (recipe.getPropertyCount() <= maxPropertyCount) continue;
                maxPropertyCount = recipe.getPropertyCount();
            }
        }
        return maxPropertyCount * 9;
    }
}

