/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.teleport;

import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.os.SystemCall;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.TeleportHandler;
import gregtech.common.entities.PortalEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;

public class TeleportApp
extends AbstractApplication {
    private int coordinateX = 0;
    private int coordinateY = 1;
    private int coordinateZ = 0;
    private int dimension = 0;

    public TeleportApp() {
        super("teleport");
    }

    @Override
    public AbstractApplication initApp() {
        if (this.nbt != null && this.nbt.func_74764_b("LastTeleport")) {
            BlockPos pos = BlockPos.func_177969_a((long)this.nbt.func_74763_f("LastTeleport"));
            this.coordinateX = pos.func_177958_n();
            this.coordinateY = pos.func_177956_o();
            this.coordinateZ = pos.func_177952_p();
            this.dimension = this.nbt.func_74765_d("LastDim");
        }
        this.addWidget(new ImageWidget(5, 5, 323, 212, new ColorRectTexture(TerminalTheme.COLOR_B_2.getColor())));
        int textFieldColor = TerminalTheme.COLOR_B_2.getColor();
        textFieldColor &= 0xFFFFFF;
        this.addWidget(new ImageWidget(9, 104, 77, 10, new ColorRectTexture(textFieldColor |= 0xC8000000)));
        this.addWidget(new ImageWidget(9, 64, 77, 10, new ColorRectTexture(textFieldColor)));
        this.addWidget(new ImageWidget(9, 44, 77, 10, new ColorRectTexture(textFieldColor)));
        this.addWidget(new ImageWidget(9, 24, 77, 10, new ColorRectTexture(textFieldColor)));
        this.addWidget(new LabelWidget(10, 15, "X: ", 0xFFFFFF));
        this.addWidget(new LabelWidget(10, 35, "Y: ", 0xFFFFFF));
        this.addWidget(new LabelWidget(10, 55, "Z: ", 0xFFFFFF));
        this.addWidget(new SimpleTextWidget(10, 95, "terminal.teleporter.dimension", 0xFFFFFF, () -> "").setCenter(false));
        this.addWidget(new TextFieldWidget2(10, 105, 75, 16, () -> String.valueOf(this.dimension), value -> {
            if (!value.isEmpty()) {
                this.dimension = Integer.parseInt(value);
            }
        }).setMaxLength(9).setNumbersOnly(Short.MIN_VALUE, Short.MAX_VALUE));
        this.addWidget(new TextFieldWidget2(10, 65, 75, 16, () -> String.valueOf(this.coordinateZ), value -> {
            if (!value.isEmpty()) {
                this.coordinateZ = Integer.parseInt(value);
            }
        }).setMaxLength(9).setNumbersOnly(-30000000, 30000000));
        this.addWidget(new TextFieldWidget2(10, 45, 75, 16, () -> String.valueOf(this.coordinateY), value -> {
            if (!value.isEmpty()) {
                this.coordinateY = Integer.parseInt(value);
            }
        }).setMaxLength(9).setNumbersOnly(1, 255));
        this.addWidget(new TextFieldWidget2(10, 25, 75, 16, () -> String.valueOf(this.coordinateX), value -> {
            if (!value.isEmpty()) {
                this.coordinateX = Integer.parseInt(value);
            }
        }).setMaxLength(9).setNumbersOnly(-30000000, 30000000));
        this.addWidget(new ClickButtonWidget(15, 140, 65, 20, "terminal.teleporter.spawn_portal", data -> this.spawnPortals()));
        return this;
    }

    @Override
    public NBTTagCompound closeApp() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("LastTeleport", new BlockPos(this.coordinateX, this.coordinateY, this.coordinateZ).func_177986_g());
        nbt.func_74777_a("LastDim", (short)this.dimension);
        return nbt;
    }

    public void spawnPortals() {
        Vec3d position = new Vec3d((double)this.gui.entityPlayer.func_180425_c().func_177958_n() + this.gui.entityPlayer.func_70040_Z().field_72450_a * 5.0, (double)this.gui.entityPlayer.func_180425_c().func_177956_o(), (double)this.gui.entityPlayer.func_180425_c().func_177952_p() + this.gui.entityPlayer.func_70040_Z().field_72449_c * 5.0);
        PortalEntity portal1 = new PortalEntity(this.gui.entityPlayer.func_130014_f_(), position.field_72450_a, position.field_72448_b, position.field_72449_c);
        portal1.func_70101_b(this.gui.entityPlayer.field_70177_z, 0.0f);
        PortalEntity portal2 = new PortalEntity(this.gui.entityPlayer.func_130014_f_(), this.coordinateX, this.coordinateY, this.coordinateZ);
        portal2.func_70101_b(this.gui.entityPlayer.field_70177_z, 0.0f);
        portal1.setTargetCoordinates(this.dimension, this.coordinateX, this.coordinateY, this.coordinateZ);
        portal2.setTargetCoordinates(this.gui.entityPlayer.field_71093_bK, position.field_72450_a, position.field_72448_b, position.field_72449_c);
        this.gui.entityPlayer.func_130014_f_().func_72838_d((Entity)portal1);
        Chunk destination = TeleportHandler.getWorldByDimensionID(this.dimension).func_72863_F().func_186025_d(this.coordinateX >> 4, this.coordinateZ >> 4);
        TeleportHandler.getWorldByDimensionID(this.dimension).func_72838_d((Entity)portal2);
        TeleportHandler.getWorldByDimensionID(this.dimension).func_72863_F().func_189549_a(destination);
        SystemCall.SHUT_DOWN.call(this.getOs(), this.isClient, new String[0]);
    }
}

