/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.settings.widgets;

import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.FileTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.resources.URLTexture;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.gui.widgets.ColorWidget;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.gui.widgets.SelectorWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;

public class ThemeSettings
extends AbstractWidgetGroup {
    private final WidgetGroup textureGroup;
    final TerminalOSWidget os;

    public ThemeSettings(TerminalOSWidget os) {
        super(Position.ORIGIN, new Size(323, 212));
        this.os = os;
        float x = 24.846153f;
        int y = 40;
        this.addWidget(new LabelWidget(161, 10, "terminal.settings.theme.color", -1).setXCentered(true));
        this.addColorButton(TerminalTheme.COLOR_1, "COLOR_1", (int)x, y);
        this.addColorButton(TerminalTheme.COLOR_2, "COLOR_2", (int)(x * 2.0f), y);
        this.addColorButton(TerminalTheme.COLOR_3, "COLOR_3", (int)(x * 3.0f), y);
        this.addColorButton(TerminalTheme.COLOR_4, "COLOR_4", (int)(x * 4.0f), y);
        this.addColorButton(TerminalTheme.COLOR_5, "COLOR_5", (int)(x * 5.0f), y);
        this.addColorButton(TerminalTheme.COLOR_6, "COLOR_6", (int)(x * 6.0f), y);
        this.addColorButton(TerminalTheme.COLOR_7, "COLOR_7", (int)(x * 7.0f), y);
        this.addColorButton(TerminalTheme.COLOR_F_1, "COLOR_F_1", (int)(x * 8.0f), y);
        this.addColorButton(TerminalTheme.COLOR_F_2, "COLOR_F_2", (int)(x * 9.0f), y);
        this.addColorButton(TerminalTheme.COLOR_B_1, "COLOR_B_1", (int)(x * 10.0f), y);
        this.addColorButton(TerminalTheme.COLOR_B_2, "COLOR_B_2", (int)(x * 11.0f), y);
        this.addColorButton(TerminalTheme.COLOR_B_3, "COLOR_B_3", (int)(x * 12.0f), y);
        this.addWidget(new LabelWidget(161, 75, "terminal.settings.theme.wallpaper", -1).setXCentered(true));
        this.addWidget(new ImageWidget((int)x, 95, 150, 105, TerminalTheme.WALL_PAPER).setBorder(2, -1));
        this.addWidget(new SelectorWidget((int)(x + 170.0f), 95, 116, 20, Arrays.asList("terminal.settings.theme.wallpaper.resource", "terminal.settings.theme.wallpaper.url", "terminal.settings.theme.wallpaper.color", "terminal.settings.theme.wallpaper.file"), -1, this::getLocalizedWallpaperTypeName, true).setIsUp(true).setOnChanged(this::onModifyTextureChanged).setColors(TerminalTheme.COLOR_B_2.getColor(), TerminalTheme.COLOR_F_1.getColor(), TerminalTheme.COLOR_B_2.getColor()).setBackground(TerminalTheme.COLOR_6));
        this.textureGroup = new WidgetGroup((int)(x + 170.0f), 122, (int)(x * 11.0f - 170.0f), 65);
        this.addWidget(this.textureGroup);
    }

    private String getLocalizedWallpaperTypeName() {
        switch (TerminalTheme.WALL_PAPER.getTypeName()) {
            case "resource": {
                return "terminal.settings.theme.wallpaper.resource";
            }
            case "url": {
                return "terminal.settings.theme.wallpaper.url";
            }
            case "color": {
                return "terminal.settings.theme.wallpaper.color";
            }
            case "file": {
                return "terminal.settings.theme.wallpaper.file";
            }
        }
        return null;
    }

    private void addColorButton(ColorRectTexture texture, String name, int x, int y) {
        CircleButtonWidget buttonWidget = new CircleButtonWidget(x, y, 8, 1, 0).setFill(texture.getColor()).setStrokeAnima(-1).setHoverText(name);
        buttonWidget.setClickListener(cd -> TerminalDialogWidget.showColorDialog(this.os, name, color -> {
            if (color != null) {
                buttonWidget.setFill((int)color);
                texture.setColor((int)color);
                if (!TerminalTheme.saveConfig()) {
                    TerminalDialogWidget.showInfoDialog(this.os, "terminal.component.error", "terminal.component.save_file.error").setClientSide().open();
                }
            }
        }, texture.color).setClientSide().open());
        this.addWidget(buttonWidget);
    }

    private void onModifyTextureChanged(String type) {
        this.textureGroup.clearAllWidgets();
        switch (type) {
            case "terminal.settings.theme.wallpaper.resource": {
                if (!(TerminalTheme.WALL_PAPER.getTexture() instanceof TextureArea)) {
                    TerminalTheme.WALL_PAPER.setTexture(new TextureArea(new ResourceLocation("gregtech:textures/gui/terminal/terminal_background.png"), 0.0, 0.0, 1.0, 1.0));
                    TerminalTheme.saveConfig();
                }
                this.addStringSetting(((TextureArea)TerminalTheme.WALL_PAPER.getTexture()).imageLocation.toString(), s -> {
                    TerminalTheme.WALL_PAPER.setTexture(new TextureArea(new ResourceLocation(s), 0.0, 0.0, 1.0, 1.0));
                    TerminalTheme.saveConfig();
                });
                break;
            }
            case "terminal.settings.theme.wallpaper.url": {
                if (!(TerminalTheme.WALL_PAPER.getTexture() instanceof URLTexture)) {
                    TerminalTheme.WALL_PAPER.setTexture(new URLTexture(null));
                    TerminalTheme.saveConfig();
                }
                this.addStringSetting(((URLTexture)TerminalTheme.WALL_PAPER.getTexture()).url, s -> {
                    TerminalTheme.WALL_PAPER.setTexture(new URLTexture((String)s));
                    TerminalTheme.saveConfig();
                });
                break;
            }
            case "terminal.settings.theme.wallpaper.color": {
                ColorRectTexture texture;
                if (!(TerminalTheme.WALL_PAPER.getTexture() instanceof ColorRectTexture)) {
                    texture = new ColorRectTexture(-1);
                    TerminalTheme.WALL_PAPER.setTexture(texture);
                    TerminalTheme.saveConfig();
                } else {
                    texture = (ColorRectTexture)TerminalTheme.WALL_PAPER.getTexture();
                }
                this.textureGroup.addWidget(new ColorWidget(0, 0, 80, 10).setColorSupplier(texture::getColor, true).setOnColorChanged(texture::setColor));
                break;
            }
            case "terminal.settings.theme.wallpaper.file": {
                if (!(TerminalTheme.WALL_PAPER.getTexture() instanceof FileTexture)) {
                    TerminalTheme.WALL_PAPER.setTexture(new FileTexture(null));
                    TerminalTheme.saveConfig();
                }
                this.textureGroup.addWidget(new RectButtonWidget(0, 0, 116, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(cd -> TerminalDialogWidget.showFileDialog(this.os, "terminal.settings.theme.image", TerminalRegistry.TERMINAL_PATH, true, file -> {
                    if (file != null && file.isFile()) {
                        TerminalTheme.WALL_PAPER.setTexture(new FileTexture((File)file));
                        TerminalTheme.saveConfig();
                    }
                }).setClientSide().open()).setIcon(new TextTexture("terminal.settings.theme.select", -1)));
            }
        }
    }

    private void addStringSetting(String init, Consumer<String> callback) {
        TextFieldWidget textFieldWidget = new TextFieldWidget(0, 0, 76, 20, TerminalTheme.COLOR_B_2, null, null).setMaxStringLength(Integer.MAX_VALUE).setValidator(s -> true).setCurrentString(init == null ? "" : init);
        this.textureGroup.addWidget(textFieldWidget);
        this.textureGroup.addWidget(new RectButtonWidget(76, 0, 40, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(cd -> callback.accept(textFieldWidget.getCurrentString())).setIcon(new TextTexture("terminal.guide_editor.update", -1)));
    }
}

