/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.recipechart;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.ingredient.IRecipeTransferHandlerWidget;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.TabGroup;
import gregtech.api.gui.widgets.tab.IGuiTextureTabInfo;
import gregtech.api.gui.widgets.tab.ITabInfo;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.CustomTabListRenderer;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.recipechart.widget.RGContainer;
import gregtech.common.terminal.app.recipechart.widget.RGNode;
import gregtech.common.terminal.component.ClickComponent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RecipeChartApp
extends AbstractApplication
implements IRecipeTransferHandlerWidget {
    private TabGroup<RGContainer> tabGroup;

    public RecipeChartApp() {
        super("recipe_chart");
    }

    @Override
    public int getThemeColor() {
        return -16744447;
    }

    @Override
    public AbstractApplication initApp() {
        if (this.isClient) {
            this.tabGroup = new TabGroup(0, 10, new CustomTabListRenderer(TerminalTheme.COLOR_F_2, TerminalTheme.COLOR_B_3, 333 / this.getMaxPages(), 10));
            this.tabGroup.setOnTabChanged(this::onPagesChanged);
            this.addWidget(this.tabGroup);
            this.loadLocalConfig(nbt -> {
                if (nbt == null || nbt.func_82582_d()) {
                    this.addTab("default");
                } else {
                    for (NBTBase l : nbt.func_150295_c("list", 10)) {
                        NBTTagCompound container = (NBTTagCompound)l;
                        this.addTab(container.func_74779_i("name")).loadFromNBT((NBTTagCompound)container.func_74781_a("data"));
                    }
                    this.tabGroup.setSelectedTab(nbt.func_74762_e("focus"));
                }
            });
        }
        return this;
    }

    private void onPagesChanged(int oldPage, int newPage) {
        ITabInfo tabInfo = this.tabGroup.getTabInfo(newPage);
        if (tabInfo instanceof IGuiTextureTabInfo && ((IGuiTextureTabInfo)tabInfo).texture instanceof TextTexture) {
            ((TextTexture)((IGuiTextureTabInfo)tabInfo).texture).setType(TextTexture.TextType.ROLL);
        }
        if ((tabInfo = this.tabGroup.getTabInfo(oldPage)) instanceof IGuiTextureTabInfo && ((IGuiTextureTabInfo)tabInfo).texture instanceof TextTexture) {
            ((TextTexture)((IGuiTextureTabInfo)tabInfo).texture).setType(TextTexture.TextType.HIDE);
        }
    }

    private RGContainer addTab(String name) {
        name = name.isEmpty() ? "default" : name;
        RGContainer container = new RGContainer(0, 0, 333, 222, this.getOs());
        container.setBackground(TerminalTheme.COLOR_B_3);
        this.tabGroup.addTab(new IGuiTextureTabInfo(new TextTexture(name, -1).setWidth(333 / this.getMaxPages() - 5).setType(this.tabGroup.getAllTag().isEmpty() ? TextTexture.TextType.ROLL : TextTexture.TextType.HIDE), name), container);
        return container;
    }

    public int getMaxPages() {
        return this.getAppTier() + 5;
    }

    @Override
    public List<IMenuComponent> getMenuComponents() {
        ClickComponent newPage = new ClickComponent().setIcon(GuiTextures.ICON_NEW_PAGE).setHoverText("terminal.component.new_page").setClickConsumer(cd -> {
            if (this.tabGroup == null) {
                return;
            }
            if (this.tabGroup.getAllTag().size() < this.getMaxPages()) {
                TerminalDialogWidget.showTextFieldDialog(this.getOs(), "terminal.component.page_name", s -> true, s -> {
                    if (s != null) {
                        this.addTab((String)s);
                    }
                }).setClientSide().open();
            } else {
                TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.component.warning", "terminal.recipe_chart.limit").setClientSide().open();
            }
        });
        ClickComponent deletePage = new ClickComponent().setIcon(GuiTextures.ICON_REMOVE).setHoverText("terminal.recipe_chart.delete").setClickConsumer(cd -> {
            if (this.tabGroup == null) {
                return;
            }
            if (this.tabGroup.getAllTag().size() > 1) {
                TerminalDialogWidget.showConfirmDialog(this.getOs(), "terminal.recipe_chart.delete", "terminal.component.confirm", r -> {
                    if (r.booleanValue()) {
                        this.tabGroup.removeTab(this.tabGroup.getAllTag().indexOf(this.tabGroup.getCurrentTag()));
                    }
                }).setClientSide().open();
            } else {
                TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.component.warning", "terminal.recipe_chart.limit").setClientSide().open();
            }
        });
        ClickComponent addSlot = new ClickComponent().setIcon(GuiTextures.ICON_ADD).setHoverText("terminal.recipe_chart.add_slot").setClickConsumer(cd -> {
            if (this.tabGroup == null) {
                return;
            }
            if (this.tabGroup.getCurrentTag() != null) {
                this.tabGroup.getCurrentTag().addNode(50, 100);
            }
        });
        ClickComponent importPage = new ClickComponent().setIcon(GuiTextures.ICON_LOAD).setHoverText("terminal.component.load_file").setClickConsumer(cd -> {
            if (this.tabGroup == null) {
                return;
            }
            if (this.tabGroup.getAllTag().size() < this.getMaxPages()) {
                File file = new File(TerminalRegistry.TERMINAL_PATH, "recipe_chart");
                TerminalDialogWidget.showFileDialog(this.getOs(), "terminal.component.load_file", file, true, result -> {
                    if (result != null && result.isFile()) {
                        try {
                            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)result);
                            this.addTab(result.getName()).loadFromNBT(nbt);
                        }
                        catch (IOException e) {
                            TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.component.error", "terminal.component.load_file.error").setClientSide().open();
                        }
                    }
                }).setClientSide().open();
            } else {
                TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.component.warning", "terminal.recipe_chart.limit").setClientSide().open();
            }
        });
        ClickComponent exportPage = new ClickComponent().setIcon(GuiTextures.ICON_SAVE).setHoverText("terminal.component.save_file").setClickConsumer(cd -> {
            if (this.tabGroup == null) {
                return;
            }
            if (this.tabGroup.getCurrentTag() != null) {
                File file = new File(TerminalRegistry.TERMINAL_PATH, "recipe_chart");
                TerminalDialogWidget.showFileDialog(this.getOs(), "terminal.component.save_file", file, false, result -> {
                    if (result != null) {
                        try {
                            CompressedStreamTools.func_74793_a((NBTTagCompound)this.tabGroup.getCurrentTag().saveAsNBT(), (File)result);
                        }
                        catch (IOException e) {
                            TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.component.error", "terminal.component.save_file.error").setClientSide().open();
                        }
                    }
                }).setClientSide().open();
            }
        });
        return Arrays.asList(newPage, deletePage, addSlot, importPage, exportPage);
    }

    @Override
    public NBTTagCompound closeApp() {
        this.saveLocalConfig(nbt -> {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.tabGroup.getAllTag().size(); ++i) {
                IGuiTextureTabInfo tabInfo = (IGuiTextureTabInfo)this.tabGroup.getTabInfo(i);
                NBTTagCompound container = new NBTTagCompound();
                container.func_74778_a("name", tabInfo.nameLocale);
                container.func_74782_a("data", (NBTBase)this.tabGroup.getTabWidget(i).saveAsNBT());
                list.func_74742_a((NBTBase)container);
            }
            nbt.func_74782_a("list", (NBTBase)list);
            nbt.func_74768_a("focus", this.tabGroup.getAllTag().indexOf(this.tabGroup.getCurrentTag()));
        });
        return super.closeApp();
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }

    @Override
    public String transferRecipe(ModularUIContainer container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        for (Widget widget : this.getContainedWidgets(false)) {
            if (!(widget instanceof RGNode) || !((RGNode)widget).transferRecipe(container, recipeLayout, player, maxTransfer, doTransfer)) continue;
            return null;
        }
        return "please select a node.";
    }

    @Override
    public int getMaxTier() {
        return 3;
    }

    @Override
    public void onOSSizeUpdate(int width, int height) {
        this.setSize(new Size(width, height));
        if (this.tabGroup != null) {
            Size size = new Size(width, height - 10);
            for (Widget widget : this.tabGroup.widgets) {
                if (!(widget instanceof RGContainer)) continue;
                widget.setSize(size);
            }
            this.tabGroup.setSize(size);
        }
    }
}

