/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget.configurator;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.TextEditorWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ConfiguratorWidget;
import java.util.Collections;
import java.util.List;

public class TextListConfigurator
extends ConfiguratorWidget<List<String>> {
    private TextEditorWidget editor;

    public TextListConfigurator(DraggableScrollableWidgetGroup group, int height, JsonObject config, String name) {
        super(group, config, name);
        this.init(height);
    }

    public TextListConfigurator(DraggableScrollableWidgetGroup group, int height, JsonObject config, String name, String defaultValue) {
        super(group, config, name, Collections.singletonList(defaultValue));
        this.init(height);
    }

    protected void init(int height) {
        JsonElement element = this.config.get(this.name);
        String initValue = "";
        if (!element.isJsonNull()) {
            List init = (List)new Gson().fromJson(element, List.class);
            initValue = String.join((CharSequence)"\n", init);
        }
        this.editor = new TextEditorWidget(0, 15, 116, height, this::updateTextList, true).setContent(initValue).setBackground(new ColorRectTexture(-1543503873));
        this.addWidget(this.editor);
    }

    private void updateTextList(String saved) {
        this.updateValue(Collections.singletonList(saved));
    }

    @Override
    protected void onDefault() {
        this.editor.setContent((String)((List)this.defaultValue).get(0));
    }
}

