/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe;

import gregtech.api.pipenet.block.material.IMaterialPipeType;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.unification.ore.OrePrefix;
import javax.annotation.Nonnull;

public enum ItemPipeType implements IMaterialPipeType<ItemPipeProperties>
{
    SMALL("small", 0.375f, OrePrefix.pipeSmallItem, 0.5f, 1.5f),
    NORMAL("normal", 0.5f, OrePrefix.pipeNormalItem, 1.0f, 1.0f),
    LARGE("large", 0.75f, OrePrefix.pipeLargeItem, 2.0f, 0.75f),
    HUGE("huge", 0.875f, OrePrefix.pipeHugeItem, 4.0f, 0.5f),
    RESTRICTIVE_SMALL("small_restrictive", 0.375f, OrePrefix.pipeSmallRestrictive, 0.5f, 150.0f),
    RESTRICTIVE_NORMAL("normal_restrictive", 0.5f, OrePrefix.pipeNormalRestrictive, 1.0f, 100.0f),
    RESTRICTIVE_LARGE("large_restrictive", 0.75f, OrePrefix.pipeLargeRestrictive, 2.0f, 75.0f),
    RESTRICTIVE_HUGE("huge_restrictive", 0.875f, OrePrefix.pipeHugeRestrictive, 4.0f, 50.0f);

    public final String name;
    private final float thickness;
    private final float rateMultiplier;
    private final float resistanceMultiplier;
    private final OrePrefix orePrefix;

    private ItemPipeType(String name, float thickness, OrePrefix orePrefix, float rateMultiplier, float resistanceMultiplier) {
        this.name = name;
        this.thickness = thickness;
        this.orePrefix = orePrefix;
        this.rateMultiplier = rateMultiplier;
        this.resistanceMultiplier = resistanceMultiplier;
    }

    public boolean isRestrictive() {
        return this.ordinal() > 3;
    }

    public String getSizeForTexture() {
        if (!this.isRestrictive()) {
            return this.name;
        }
        return this.name.substring(0, this.name.length() - 12);
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public ItemPipeProperties modifyProperties(ItemPipeProperties baseProperties) {
        return new ItemPipeProperties((int)((double)((float)baseProperties.getPriority() * this.resistanceMultiplier) + 0.5), baseProperties.getTransferRate() * this.rateMultiplier);
    }

    public float getRateMultiplier() {
        return this.rateMultiplier;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Override
    public OrePrefix getOrePrefix() {
        return this.orePrefix;
    }
}

