/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.GTValues;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.net.FluidPipeNet;
import gregtech.common.pipelike.fluidpipe.net.WorldFluidPipeNet;
import java.lang.ref.WeakReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityFluidPipe
extends TileEntityMaterialPipeBase<FluidPipeType, FluidPipeProperties> {
    public static final int FREQUENCY = 5;
    private WeakReference<FluidPipeNet> currentPipeNet = new WeakReference<Object>(null);

    @Override
    public Class<FluidPipeType> getPipeTypeClass() {
        return FluidPipeType.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    public int getCapacityPerTank() {
        return ((FluidPipeProperties)this.getNodeData()).getThroughput() * 20;
    }

    public FluidPipeNet getFluidPipeNet() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return null;
        }
        FluidPipeNet currentPipeNet = (FluidPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        WorldFluidPipeNet worldFluidPipeNet = (WorldFluidPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.getPipeWorld()));
        currentPipeNet = (FluidPipeNet)worldFluidPipeNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<FluidPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    public static void setNeighboursToFire(World world, BlockPos selfPos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos blockPos;
            IBlockState blockState;
            if (!GTValues.RNG.nextBoolean() || !(blockState = world.func_180495_p(blockPos = selfPos.func_177972_a(side))).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos) && !blockState.func_177230_c().isFlammable((IBlockAccess)world, blockPos, side.func_176734_d())) continue;
            world.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public static void spawnParticles(World worldIn, BlockPos pos, EnumFacing direction, EnumParticleTypes particleType, int particleCount) {
        if (worldIn instanceof WorldServer) {
            ((WorldServer)worldIn).func_175739_a(particleType, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, particleCount, (double)direction.func_82601_c() * 0.2 + GTValues.RNG.nextDouble() * 0.1, (double)direction.func_96559_d() * 0.2 + GTValues.RNG.nextDouble() * 0.1, (double)direction.func_82599_e() * 0.2 + GTValues.RNG.nextDouble() * 0.1, 0.1, new int[0]);
        }
    }
}

