/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.net;

import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import net.minecraft.nbt.NBTTagCompound;

public class FluidPipeNet
extends PipeNet<FluidPipeProperties> {
    public FluidPipeNet(WorldPipeNet<FluidPipeProperties, FluidPipeNet> world) {
        super(world);
    }

    @Override
    protected void writeNodeData(FluidPipeProperties nodeData, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("max_temperature", nodeData.getMaxFluidTemperature());
        tagCompound.func_74768_a("throughput", nodeData.getThroughput());
        tagCompound.func_74757_a("gas_proof", nodeData.isGasProof());
        tagCompound.func_74757_a("acid_proof", nodeData.isAcidProof());
        tagCompound.func_74757_a("cryo_proof", nodeData.isCryoProof());
        tagCompound.func_74757_a("plasma_proof", nodeData.isPlasmaProof());
        tagCompound.func_74768_a("channels", nodeData.getTanks());
    }

    @Override
    protected FluidPipeProperties readNodeData(NBTTagCompound tagCompound) {
        int maxTemperature = tagCompound.func_74762_e("max_temperature");
        int throughput = tagCompound.func_74762_e("throughput");
        boolean gasProof = tagCompound.func_74767_n("gas_proof");
        boolean acidProof = tagCompound.func_74767_n("acid_proof");
        boolean cryoProof = tagCompound.func_74767_n("cryo_proof");
        boolean plasmaProof = tagCompound.func_74767_n("plasma_proof");
        int channels = tagCompound.func_74762_e("channels");
        return new FluidPipeProperties(maxTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof, channels);
    }
}

