/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.pipenet.PipeNetWalker;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.common.pipelike.cable.net.RoutePath;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class EnergyNetWalker
extends PipeNetWalker {
    private final List<RoutePath> routes;
    private TileEntityCable[] pipes = new TileEntityCable[0];
    private int loss;

    public static List<RoutePath> createNetData(World world, BlockPos sourcePipe) {
        EnergyNetWalker walker = new EnergyNetWalker(world, sourcePipe, 1, new ArrayList<RoutePath>());
        walker.traversePipeNet();
        return walker.isFailed() ? null : walker.routes;
    }

    protected EnergyNetWalker(World world, BlockPos sourcePipe, int walkedBlocks, List<RoutePath> routes) {
        super(world, sourcePipe, walkedBlocks);
        this.routes = routes;
    }

    @Override
    protected PipeNetWalker createSubWalker(World world, EnumFacing facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        EnergyNetWalker walker = new EnergyNetWalker(world, nextPos, walkedBlocks, this.routes);
        walker.loss = this.loss;
        walker.pipes = this.pipes;
        return walker;
    }

    @Override
    protected void checkPipe(IPipeTile<?, ?> pipeTile, BlockPos pos) {
        this.pipes = (TileEntityCable[])ArrayUtils.add((Object[])this.pipes, (Object)((TileEntityCable)pipeTile));
        this.loss += ((WireProperties)((TileEntityCable)pipeTile).getNodeData()).getLossPerBlock();
    }

    @Override
    protected void checkNeighbour(IPipeTile<?, ?> pipeTile, BlockPos pipePos, EnumFacing faceToNeighbour, @Nullable TileEntity neighbourTile) {
        IEnergyContainer container;
        if (neighbourTile != null && (container = (IEnergyContainer)neighbourTile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, faceToNeighbour.func_176734_d())) != null) {
            this.routes.add(new RoutePath(new BlockPos((Vec3i)pipePos), faceToNeighbour, this.pipes, this.getWalkedBlocks(), this.loss));
        }
    }

    @Override
    protected boolean isValidPipe(IPipeTile<?, ?> currentPipe, IPipeTile<?, ?> neighbourPipe, BlockPos pipePos, EnumFacing faceToNeighbour) {
        return neighbourPipe instanceof TileEntityCable;
    }
}

