/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable;

import com.google.common.base.Preconditions;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.cover.ICoverable;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.ItemBlockCable;
import gregtech.common.pipelike.cable.net.WorldENet;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import gregtech.common.pipelike.cable.tile.TileEntityCableTickable;
import gregtech.core.advancement.AdvancementTriggers;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockCable
extends BlockMaterialPipe<Insulation, WireProperties, WorldENet>
implements ITileEntityProvider {
    private final Map<Material, WireProperties> enabledMaterials = new TreeMap<Material, WireProperties>();

    public BlockCable(Insulation cableType) {
        super(cableType);
        this.setHarvestLevel("wirecutter", 1);
    }

    public void addCableMaterial(Material material, WireProperties wireProperties) {
        Preconditions.checkNotNull((Object)material, (Object)"material was null");
        Preconditions.checkNotNull((Object)wireProperties, (String)"material %s wireProperties was null", (Object)material);
        Preconditions.checkArgument((GregTechAPI.MATERIAL_REGISTRY.getNameForObject(material) != null ? 1 : 0) != 0, (String)"material %s is not registered", (Object)material);
        if (!((Insulation)this.pipeType).orePrefix.isIgnored(material)) {
            this.enabledMaterials.put(material, wireProperties);
        }
    }

    public Collection<Material> getEnabledMaterials() {
        return Collections.unmodifiableSet(this.enabledMaterials.keySet());
    }

    @Override
    public Class<Insulation> getPipeTypeClass() {
        return Insulation.class;
    }

    @Override
    protected WireProperties createProperties(Insulation insulation, Material material) {
        return insulation.modifyProperties(this.enabledMaterials.getOrDefault(material, this.getFallbackType()));
    }

    @Override
    protected WireProperties getFallbackType() {
        return this.enabledMaterials.values().iterator().next();
    }

    @Override
    public WorldENet getWorldPipeNet(World world) {
        return WorldENet.getWorldENet(world);
    }

    @Override
    public void func_149666_a(@Nonnull CreativeTabs itemIn, @Nonnull NonNullList<ItemStack> items) {
        for (Material material : this.enabledMaterials.keySet()) {
            items.add((Object)this.getItem(material));
        }
    }

    @Override
    protected boolean isPipeTool(@Nonnull ItemStack stack) {
        return ToolHelper.isTool(stack, "wirecutter");
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            int temp = cable.getTemperature();
            if (temp >= 5000) {
                return 15;
            }
            if (temp > 500) {
                return (temp - 500) * 15 / 4500;
            }
        }
        return 0;
    }

    @Override
    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (worldIn.field_72995_K) {
            TileEntityCable cable = (TileEntityCable)this.getPipeTileEntity((IBlockAccess)worldIn, pos);
            cable.killParticle();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean canPipesConnect(IPipeTile<Insulation, WireProperties> selfTile, EnumFacing side, IPipeTile<Insulation, WireProperties> sideTile) {
        return selfTile instanceof TileEntityCable && sideTile instanceof TileEntityCable;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeTile<Insulation, WireProperties> selfTile, EnumFacing side, TileEntity tile) {
        return tile != null && tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, side.func_176734_d()) != null;
    }

    @Override
    public boolean isHoldingPipe(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemBlockCable;
    }

    @Override
    public boolean hasPipeCollisionChangingItem(IBlockAccess world, BlockPos pos, ItemStack stack) {
        return ToolHelper.isTool(stack, "wirecutter") || GTUtility.isCoverBehaviorItem(stack, () -> this.hasCover(this.getPipeTileEntity(world, pos)), coverDef -> ICoverable.canPlaceCover(coverDef, this.getPipeTileEntity(world, pos).getCoverableImplementation()));
    }

    @Override
    public void func_180634_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        Insulation insulation = (Insulation)this.getPipeTileEntity((IBlockAccess)worldIn, pos).getPipeType();
        if (insulation.insulationLevel == -1 && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            TileEntityCable cable = (TileEntityCable)this.getPipeTileEntity((IBlockAccess)worldIn, pos);
            if (cable != null && cable.getFrameMaterial() == null && ((WireProperties)cable.getNodeData()).getLossPerBlock() > 0) {
                long voltage = cable.getCurrentMaxVoltage();
                double amperage = cable.getAverageAmperage();
                if (voltage > 0L && amperage > 0.0) {
                    float damageAmount = (float)((double)(GTUtility.getTierByVoltage(voltage) + 1) * amperage * 4.0);
                    entityLiving.func_70097_a(DamageSources.getElectricDamage(), damageAmount);
                    if (entityLiving instanceof EntityPlayerMP) {
                        AdvancementTriggers.ELECTROCUTION_DEATH.trigger((EntityPlayerMP)entityLiving);
                    }
                }
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return CableRenderer.INSTANCE.getBlockRenderType();
    }

    @Override
    public TileEntityPipeBase<Insulation, WireProperties> createNewTileEntity(boolean supportsTicking) {
        return supportsTicking ? new TileEntityCableTickable() : new TileEntityCable();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return CableRenderer.INSTANCE.getParticleTexture((TileEntityCable)world.func_175625_s(blockPos));
    }
}

