/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import gregtech.api.recipes.KeySharedStack;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.ShapedOreEnergyTransferRecipe;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSources;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;

public class CachedRecipeData {
    private final ItemSources itemSources;
    private IRecipe recipe;
    private final Map<ItemStackKey, Integer> requiredItems = new HashMap<ItemStackKey, Integer>();
    private final Map<Integer, Map<ItemStackKey, Boolean>> replaceAttemptMap = new Int2ObjectArrayMap();
    private final InventoryCrafting inventory;

    public CachedRecipeData(ItemSources sourceList, IRecipe recipe, InventoryCrafting inventoryCrafting) {
        this.itemSources = sourceList;
        this.recipe = recipe;
        this.inventory = inventoryCrafting;
    }

    public short attemptMatchRecipe() {
        short itemsFound = 0;
        this.requiredItems.clear();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (!this.getIngredientEquivalent(i)) continue;
            itemsFound = (short)(itemsFound + (1 << i));
        }
        if (itemsFound != CraftingRecipeLogic.ALL_INGREDIENTS_PRESENT) {
            this.requiredItems.clear();
        }
        return itemsFound;
    }

    protected boolean consumeRecipeItems() {
        boolean gathered = true;
        HashMap<ItemStackKey, Integer> gatheredItems = new HashMap<ItemStackKey, Integer>();
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        for (Map.Entry<ItemStackKey, Integer> entry : this.requiredItems.entrySet()) {
            int requestedAmount;
            ItemStackKey itemStackKey = entry.getKey();
            int extractedAmount = this.itemSources.extractItem(itemStackKey, requestedAmount = entry.getValue().intValue(), false);
            if (extractedAmount != requestedAmount) {
                gatheredItems.put(itemStackKey, extractedAmount);
                gathered = false;
                break;
            }
            gatheredItems.put(itemStackKey, requestedAmount);
        }
        if (!gathered) {
            for (Map.Entry<ItemStackKey, Integer> entry : gatheredItems.entrySet()) {
                this.itemSources.insertItem(entry.getKey(), entry.getValue(), false, IItemList.InsertMode.HIGHEST_PRIORITY);
            }
        }
        return gathered;
    }

    public boolean getIngredientEquivalent(int slot) {
        ItemStack currentStack = this.inventory.func_70301_a(slot);
        if (currentStack.func_190926_b()) {
            return true;
        }
        if (this.simulateExtractItem(KeySharedStack.getRegisteredStack(currentStack))) {
            return true;
        }
        ItemStack previousStack = this.recipe.func_77572_b(this.inventory);
        Map map = this.replaceAttemptMap.computeIfAbsent(slot, m -> new Object2BooleanOpenHashMap());
        for (ItemStackKey itemStackKey : this.itemSources.getStoredItems()) {
            boolean matchedPreviously = false;
            if (map.containsKey(itemStackKey)) {
                if (!((Boolean)map.get(itemStackKey)).booleanValue()) continue;
                matchedPreviously = true;
            }
            ItemStack itemStack = itemStackKey.getItemStack();
            if (!matchedPreviously) {
                boolean matched = false;
                for (Ingredient in : this.recipe.func_192400_c()) {
                    if (!in.apply(itemStack)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    map.put(itemStackKey, false);
                    continue;
                }
            }
            this.inventory.func_70299_a(slot, itemStack);
            if (this.recipe.func_77569_a(this.inventory, this.itemSources.getWorld()) && (ItemStack.func_77989_b((ItemStack)this.recipe.func_77572_b(this.inventory), (ItemStack)previousStack) || this.recipe instanceof ShapedOreEnergyTransferRecipe)) {
                map.put(itemStackKey, true);
                if (this.simulateExtractItem(itemStackKey)) {
                    return true;
                }
            }
            map.put(itemStackKey, false);
            this.inventory.func_70299_a(slot, currentStack);
        }
        return false;
    }

    private boolean simulateExtractItem(ItemStackKey itemStack) {
        int amountToExtract = this.requiredItems.getOrDefault(itemStack, 0) + 1;
        int extracted = this.itemSources.extractItem(itemStack, amountToExtract, true);
        if (extracted == amountToExtract) {
            this.requiredItems.put(itemStack, amountToExtract);
            return true;
        }
        return false;
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        if (this.recipe == null) {
            return false;
        }
        return this.recipe.func_77569_a(inventoryCrafting, world);
    }

    public void setRecipe(IRecipe newRecipe) {
        this.recipe = newRecipe;
        this.replaceAttemptMap.clear();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }
}

