/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MetaTileEntityPyrolyseOven
extends RecipeMapMultiblockController {
    private int coilTier;

    public MetaTileEntityPyrolyseOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.PYROLYSE_RECIPES);
        this.recipeMapWorkable = new PyrolyseOvenWorkableHandler(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPyrolyseOven(this.metaTileEntityId);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("CCC", "C#C", "CCC").aisle("CCC", "C#C", "CCC").aisle("XXX", "XSX", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityPyrolyseOven.states(this.getCasingState()).setMinGlobalLimited(6).or(this.autoAbilities())).where('C', MetaTileEntityPyrolyseOven.heatingCoils()).where('#', MetaTileEntityPyrolyseOven.air()).build();
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.VOLTAGE_CASINGS[0];
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.MACHINE_CASING.getState(BlockMachineCasing.MachineCasingType.ULV);
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PYROLYSE_OVEN_OVERLAY;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.coilTier = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getTier() : 0;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.pyrolyse_oven.speed", new Object[]{this.coilTier == 0 ? 75 : 50 * (this.coilTier + 1)}));
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.pyrolyse_oven.tooltip.1", (Object[])new Object[0]));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.coilTier = -1;
    }

    protected int getCoilTier() {
        return this.coilTier;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public boolean canBeDistinct() {
        return true;
    }

    private class PyrolyseOvenWorkableHandler
    extends MultiblockRecipeLogic {
        public PyrolyseOvenWorkableHandler(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        protected void performNonOverclockBonuses(int[] resultOverclock) {
            int coilTier = ((MetaTileEntityPyrolyseOven)this.metaTileEntity).getCoilTier();
            if (coilTier == -1) {
                return;
            }
            resultOverclock[1] = coilTier == 0 ? (int)((double)resultOverclock[1] * 1.25) : (int)((float)resultOverclock[1] * (2.0f / (float)(coilTier + 1)));
            resultOverclock[1] = Math.max(1, resultOverclock[1]);
        }
    }
}

