/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.IHeatingCoil;
import gregtech.api.capability.impl.HeatingCoilRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipeproperties.TemperatureProperty;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MetaTileEntityElectricBlastFurnace
extends RecipeMapMultiblockController
implements IHeatingCoil {
    private int blastFurnaceTemperature;

    public MetaTileEntityElectricBlastFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.BLAST_RECIPES);
        this.recipeMapWorkable = new HeatingCoilRecipeLogic(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityElectricBlastFurnace(this.metaTileEntityId);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.blast_furnace.max_temperature", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.blastFurnaceTemperature) + "K", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        }
        super.addDisplayText(textList);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.blastFurnaceTemperature = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getCoilTemperature() : BlockWireCoil.CoilType.CUPRONICKEL.getCoilTemperature();
        this.blastFurnaceTemperature += 100 * Math.max(0, GTUtility.getTierByVoltage(this.getEnergyContainer().getInputVoltage()) - 2);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.blastFurnaceTemperature = 0;
    }

    @Override
    public boolean checkRecipe(@Nonnull Recipe recipe, boolean consumeIfSuccess) {
        return this.blastFurnaceTemperature >= recipe.getProperty(TemperatureProperty.getInstance(), 0);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "XXX").aisle("XXX", "C#C", "C#C", "XMX").aisle("XSX", "CCC", "CCC", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityElectricBlastFurnace.states(this.getCasingState()).setMinGlobalLimited(9).or(this.autoAbilities(true, true, true, true, true, true, false))).where('M', MetaTileEntityElectricBlastFurnace.abilities(MultiblockAbility.MUFFLER_HATCH)).where('C', MetaTileEntityElectricBlastFurnace.heatingCoils()).where('#', MetaTileEntityElectricBlastFurnace.air()).build();
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HEAT_PROOF_CASING;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.electric_blast_furnace.tooltip.3", (Object[])new Object[0]));
    }

    @Override
    public int getCurrentTemperature() {
        return this.blastFurnaceTemperature;
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.BLAST_FURNACE_OVERLAY;
    }

    @Override
    public boolean canBeDistinct() {
        return true;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle("EEM", "CCC", "CCC", "XXX").aisle("FXD", "C#C", "C#C", "XHX").aisle("ISO", "CCC", "CCC", "XXX").where('X', MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF)).where('S', MetaTileEntities.ELECTRIC_BLAST_FURNACE, EnumFacing.SOUTH).where('#', Blocks.field_150350_a.func_176223_P()).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[1], EnumFacing.NORTH).where('I', MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('F', MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.WEST).where('D', MetaTileEntities.FLUID_EXPORT_HATCH[1], EnumFacing.EAST).where('H', MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.UP).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF), EnumFacing.NORTH);
        GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('C', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    @Override
    @Nonnull
    public List<ITextComponent> getDataInfo() {
        List<ITextComponent> list = super.getDataInfo();
        list.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.blast_furnace.max_temperature", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(this.blastFurnaceTemperature) + "K", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
        return list;
    }
}

