/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.GTValues;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseChargingPlayer;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityMagicEnergyAbsorber
extends TieredMetaTileEntity {
    private final TIntList connectedCrystalsIds = new TIntArrayList();
    private boolean hasDragonEggAmplifier = false;
    private boolean isActive = false;

    public MetaTileEntityMagicEnergyAbsorber(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 4);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMagicEnergyAbsorber(this.metaTileEntityId);
    }

    @SideOnly(value=Side.CLIENT)
    private ICubeRenderer getRenderer() {
        return this.isActive ? Textures.MAGIC_ENERGY_ABSORBER_ACTIVE : Textures.MAGIC_ENERGY_ABSORBER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getRenderer().getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getRenderer().render(renderState, translation, colouredPipeline);
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (!(this.getWorld().field_73011_w instanceof WorldProviderEnd)) {
            return;
        }
        if (this.getOffsetTimer() % 20L == 0L || this.isFirstTick()) {
            this.updateDragonEggStatus();
        }
        if (this.getOffsetTimer() % 200L == 0L || this.isFirstTick()) {
            this.updateConnectedCrystals();
        }
        int totalEnergyGeneration = 0;
        for (int connectedCrystalId : this.connectedCrystalsIds.toArray()) {
            if (!(this.getWorld().func_73045_a(connectedCrystalId) instanceof EntityEnderCrystal)) continue;
            totalEnergyGeneration += this.hasDragonEggAmplifier ? 128 : 32;
        }
        if (totalEnergyGeneration > 0) {
            this.energyContainer.changeEnergy(totalEnergyGeneration);
        }
        this.setActive(totalEnergyGeneration > 0);
    }

    private void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            if (!this.getWorld().field_72995_K) {
                this.writeCustomData(100, w -> w.writeBoolean(isActive));
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isActive = buf.readBoolean();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getWorld().field_72995_K) {
            this.resetConnectedEnderCrystals();
        }
    }

    @Override
    protected boolean isEnergyEmitter() {
        return true;
    }

    private void updateConnectedCrystals() {
        this.connectedCrystalsIds.clear();
        double maxDistance = 4096.0;
        List enderCrystals = Arrays.stream(BiomeEndDecorator.func_185426_a((World)this.getWorld())).flatMap(endSpike -> this.getWorld().func_72872_a(EntityEnderCrystal.class, endSpike.func_186153_f()).stream()).filter(crystal -> crystal.func_174818_b(this.getPos()) < 4096.0).collect(Collectors.toList());
        for (EntityEnderCrystal entityEnderCrystal : enderCrystals) {
            BlockPos beamTarget = entityEnderCrystal.func_184518_j();
            if (beamTarget == null) {
                entityEnderCrystal.func_184516_a(this.getPos());
                this.connectedCrystalsIds.add(entityEnderCrystal.func_145782_y());
                continue;
            }
            if (!beamTarget.equals((Object)this.getPos())) continue;
            this.connectedCrystalsIds.add(entityEnderCrystal.func_145782_y());
        }
        for (EntityDragon entityDragon : this.getWorld().func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a)) {
            if (entityDragon.field_70992_bH == null || !this.connectedCrystalsIds.contains(entityDragon.field_70992_bH.func_145782_y())) continue;
            entityDragon.field_70992_bH = null;
            if (entityDragon.func_184670_cT().func_188756_a().func_188652_i() != PhaseList.field_188741_a) continue;
            entityDragon.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)null), 10.0f);
            entityDragon.func_184670_cT().func_188758_a(PhaseList.field_188749_i);
            ((PhaseChargingPlayer)entityDragon.func_184670_cT().func_188756_a()).func_188668_a(new Vec3d((Vec3i)this.getPos()));
        }
    }

    private void resetConnectedEnderCrystals() {
        for (int connectedEnderCrystal : this.connectedCrystalsIds.toArray()) {
            EntityEnderCrystal entityEnderCrystal = (EntityEnderCrystal)this.getWorld().func_73045_a(connectedEnderCrystal);
            if (entityEnderCrystal == null || !this.getPos().equals((Object)entityEnderCrystal.func_184518_j())) continue;
            entityEnderCrystal.func_184516_a(null);
        }
        this.connectedCrystalsIds.clear();
    }

    private void updateDragonEggStatus() {
        IBlockState blockState = this.getWorld().func_180495_p(this.getPos().func_177984_a());
        this.hasDragonEggAmplifier = blockState.func_177230_c() instanceof BlockDragonEgg;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive() && !this.hasDragonEggAmplifier) {
            BlockPos pos = this.getPos();
            for (int i = 0; i < 4; ++i) {
                this.getWorld().func_175688_a(EnumParticleTypes.PORTAL, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + GTValues.RNG.nextFloat()), (double)((float)pos.func_177952_p() + 0.5f), (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.5f), (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.5f), (double)((GTValues.RNG.nextFloat() - 0.5f) * 0.5f), new int[0]);
            }
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

