/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.converter;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.converter.MetaTileEntityConverter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ConverterTrait
extends MTETrait {
    private final int amps;
    private final long voltage;
    private boolean feToEu;
    private final IEnergyStorage energyFE = new FEContainer();
    private final IEnergyContainer energyEU = new EUContainer();
    protected long storedEU;
    private final long baseCapacity;
    private long usedAmps;
    private BlockPos frontPos;

    public ConverterTrait(MetaTileEntityConverter mte, int amps, boolean feToEu) {
        super(mte);
        this.amps = amps;
        this.feToEu = feToEu;
        this.voltage = GTValues.V[mte.getTier()];
        this.baseCapacity = this.voltage * 16L * (long)amps;
    }

    protected IEnergyContainer getEnergyEUContainer() {
        return this.energyEU;
    }

    protected IEnergyStorage getEnergyFEContainer() {
        return this.energyFE;
    }

    public boolean isFeToEu() {
        return this.feToEu;
    }

    protected void setFeToEu(boolean feToEu) {
        this.feToEu = feToEu;
    }

    public int getBaseAmps() {
        return this.amps;
    }

    public long getVoltage() {
        return this.voltage;
    }

    @Override
    public String getName() {
        return "EnergyConvertTrait";
    }

    @Override
    public int getNetworkID() {
        return 1;
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        return null;
    }

    private long extractInternal(long amount) {
        if (amount <= 0L) {
            return 0L;
        }
        long change = Math.min(this.storedEU, amount);
        this.storedEU -= change;
        return change;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("StoredEU", this.storedEU);
        nbt.func_74757_a("feToEu", this.feToEu);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.storedEU = nbt.func_74763_f("StoredEU");
        this.feToEu = nbt.func_74767_n("feToEu");
    }

    @Override
    public void update() {
        super.update();
        this.usedAmps = 0L;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.pushEnergy();
        }
    }

    protected void pushEnergy() {
        long energyInserted;
        if (this.feToEu) {
            IEnergyContainer container = this.getCapabilityAtFront(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER);
            if (container == null) {
                return;
            }
            long ampsToInsert = Math.min((long)this.amps, this.storedEU / this.voltage);
            if (ampsToInsert == 0L) {
                return;
            }
            energyInserted = container.acceptEnergyFromNetwork(this.metaTileEntity.getFrontFacing().func_176734_d(), this.voltage, ampsToInsert) * this.voltage;
        } else {
            IEnergyStorage storage = (IEnergyStorage)this.getCapabilityAtFront(CapabilityEnergy.ENERGY);
            if (storage == null) {
                return;
            }
            energyInserted = FeCompat.insertEu(storage, this.storedEU);
        }
        this.extractInternal(energyInserted);
    }

    protected <T> T getCapabilityAtFront(Capability<T> capability) {
        TileEntity tile = this.metaTileEntity.getWorld().func_175625_s(this.frontPos == null ? (this.frontPos = this.metaTileEntity.getPos().func_177972_a(this.metaTileEntity.getFrontFacing())) : this.frontPos);
        if (tile == null) {
            return null;
        }
        EnumFacing opposite = this.metaTileEntity.getFrontFacing().func_176734_d();
        return (T)tile.getCapability(capability, opposite);
    }

    @Override
    public void onFrontFacingSet(EnumFacing newFrontFacing) {
        this.frontPos = null;
    }

    public class FEContainer
    implements IEnergyStorage {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!ConverterTrait.this.feToEu || maxReceive <= 0) {
                return 0;
            }
            int received = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceive);
            received -= received % FeCompat.ratio(true);
            if (!simulate) {
                ConverterTrait.this.storedEU += FeCompat.toEu(received, FeCompat.ratio(true));
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return FeCompat.toFeBounded(ConverterTrait.this.storedEU, FeCompat.ratio(ConverterTrait.this.feToEu), Integer.MAX_VALUE);
        }

        public int getMaxEnergyStored() {
            return FeCompat.toFeBounded(ConverterTrait.this.baseCapacity, FeCompat.ratio(ConverterTrait.this.feToEu), Integer.MAX_VALUE);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return ConverterTrait.this.feToEu;
        }
    }

    public class EUContainer
    implements IEnergyContainer {
        @Override
        public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
            if (amperage <= 0L || voltage <= 0L || ConverterTrait.this.feToEu || side == ConverterTrait.this.metaTileEntity.getFrontFacing()) {
                return 0L;
            }
            if (ConverterTrait.this.usedAmps >= (long)ConverterTrait.this.amps) {
                return 0L;
            }
            if (voltage > this.getInputVoltage()) {
                ConverterTrait.this.metaTileEntity.doExplosion(GTUtility.getExplosionPower(voltage));
                return Math.min(amperage, (long)ConverterTrait.this.amps - ConverterTrait.this.usedAmps);
            }
            long space = ConverterTrait.this.baseCapacity - ConverterTrait.this.storedEU;
            if (space < voltage) {
                return 0L;
            }
            long maxAmps = Math.min(Math.min(amperage, (long)ConverterTrait.this.amps - ConverterTrait.this.usedAmps), space / voltage);
            ConverterTrait.this.storedEU += voltage * maxAmps;
            ConverterTrait.this.usedAmps = ConverterTrait.this.usedAmps + maxAmps;
            return maxAmps;
        }

        @Override
        public boolean inputsEnergy(EnumFacing side) {
            return !ConverterTrait.this.feToEu && side != ConverterTrait.this.metaTileEntity.getFrontFacing();
        }

        @Override
        public long changeEnergy(long amount) {
            if (amount == 0L) {
                return 0L;
            }
            return amount > 0L ? this.addEnergy(amount) : this.removeEnergy(-amount);
        }

        @Override
        public long addEnergy(long energyToAdd) {
            if (energyToAdd <= 0L) {
                return 0L;
            }
            long original = energyToAdd;
            long change = Math.min(ConverterTrait.this.baseCapacity - ConverterTrait.this.storedEU, energyToAdd);
            ConverterTrait.this.storedEU += change;
            return original - (energyToAdd -= change);
        }

        @Override
        public long removeEnergy(long energyToRemove) {
            return ConverterTrait.this.extractInternal(energyToRemove);
        }

        @Override
        public long getEnergyStored() {
            return ConverterTrait.this.storedEU;
        }

        @Override
        public long getEnergyCapacity() {
            return ConverterTrait.this.baseCapacity;
        }

        @Override
        public long getInputAmperage() {
            return ConverterTrait.this.feToEu ? 0L : (long)ConverterTrait.this.amps;
        }

        @Override
        public long getInputVoltage() {
            return ConverterTrait.this.voltage;
        }

        @Override
        public long getOutputAmperage() {
            return ConverterTrait.this.feToEu ? (long)ConverterTrait.this.amps : 0L;
        }

        @Override
        public long getOutputVoltage() {
            return ConverterTrait.this.voltage;
        }
    }
}

