/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors.monitorplugin;

import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.client.utils.RenderUtil;
import gregtech.common.gui.widget.WidgetARGB;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextPluginBehavior
extends MonitorPluginBaseBehavior {
    public String[] texts;
    public int[] colors;

    public void setText(int line, String text, int color) {
        if (line < 0 || line > this.texts.length || this.texts[line].equals(text) && this.colors[line] == color) {
            return;
        }
        this.texts[line] = text;
        this.colors[line] = color;
        this.writePluginData(0, packetBuffer -> {
            packetBuffer.writeInt(this.texts.length);
            for (int i = 0; i < this.texts.length; ++i) {
                packetBuffer.func_180714_a(this.texts[i]);
                packetBuffer.writeInt(this.colors[i]);
            }
        });
        this.markAsDirty();
    }

    @Override
    public void readPluginData(int id, PacketBuffer buf) {
        if (id == 0) {
            this.texts = new String[buf.readInt()];
            this.colors = new int[this.texts.length];
            for (int i = 0; i < this.texts.length; ++i) {
                this.texts[i] = buf.func_150789_c(100);
                this.colors[i] = buf.readInt();
            }
        }
    }

    @Override
    public MonitorPluginBaseBehavior createPlugin() {
        TextPluginBehavior plugin = new TextPluginBehavior();
        plugin.texts = new String[16];
        plugin.colors = new int[16];
        return plugin;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        for (int i = 0; i < this.texts.length; ++i) {
            data.func_74778_a("t" + i, this.texts[i]);
        }
        data.func_74783_a("color", this.colors);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        for (int i = 0; i < this.texts.length; ++i) {
            this.texts[i] = data.func_74764_b("t" + i) ? data.func_74779_i("t" + i) : "";
        }
        if (data.func_74764_b("color")) {
            this.colors = data.func_74759_k("color");
        } else {
            Arrays.fill(this.colors, -1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPlugin(float partialTicks, RayTraceResult rayTraceResult) {
        for (int i = 0; i < this.texts.length; ++i) {
            RenderUtil.renderText(-0.5f, -0.4625f + (float)i / 16.0f, 0.002f, 0.0078125f, this.colors[i], this.texts[i], false);
        }
    }

    @Override
    public boolean hasUI() {
        return true;
    }

    @Override
    public WidgetPluginConfig customUI(WidgetPluginConfig widgets, IUIHolder holder, EntityPlayer entityPlayer) {
        widgets.setSize(260, 210);
        for (int i = 0; i < this.texts.length; ++i) {
            int finalI = i;
            widgets.addWidget(new TextFieldWidget(25, 25 + i * 10, 100, 10, true, () -> this.texts[finalI], text -> this.setText(finalI, (String)text, this.colors[finalI])).setValidator(data -> true));
            widgets.addWidget(new WidgetARGB(135, 25 + i * 10, 10, this.colors[i], color -> this.setText(finalI, this.texts[finalI], (int)color)));
        }
        return widgets;
    }
}

