/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.armor.ISpecialArmorLogic;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GradientUtil;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.armor.IJetpack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class PowerlessJetpack
implements ISpecialArmorLogic,
IArmorLogic,
IJetpack {
    public final int tankCapacity = 16000;
    private Recipe previousRecipe = null;
    private Recipe currentRecipe = null;
    private int burnTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private ArmorUtils.ModularHUD HUD;

    public PowerlessJetpack() {
        if (ArmorUtils.SIDE.isClient()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, @Nonnull ItemStack stack) {
        IFluidHandlerItem internalTank = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (internalTank == null) {
            return;
        }
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(stack);
        byte toggleTimer = 0;
        boolean hover = false;
        if (data.func_74764_b("burnTimer")) {
            this.burnTimer = data.func_74765_d("burnTimer");
        }
        if (data.func_74764_b("toggleTimer")) {
            toggleTimer = data.func_74771_c("toggleTimer");
        }
        if (data.func_74764_b("hover")) {
            hover = data.func_74767_n("hover");
        }
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hover = !hover;
            toggleTimer = 5;
            data.func_74757_a("hover", hover);
            if (!world.field_72995_K) {
                if (hover) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.enable", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.disable", new Object[0]), true);
                }
            }
        }
        if (this.currentRecipe == null) {
            this.findNewRecipe(stack);
        }
        this.performFlying(player, hover, stack);
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.func_74757_a("hover", hover);
        data.func_74777_a("burnTimer", (short)this.burnTimer);
        data.func_74774_a("toggleTimer", toggleTimer);
        player.field_71069_bz.func_75142_b();
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return EntityEquipmentSlot.CHEST;
    }

    @Override
    public void addToolComponents(@Nonnull ArmorMetaItem.ArmorMetaValueItem mvi) {
        mvi.addComponents(new Behaviour(16000));
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/liquid_fuel_jetpack.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void drawHUD(@Nonnull ItemStack item) {
        IFluidTankProperties[] prop;
        IFluidHandlerItem tank = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (tank != null && (prop = tank.getTankProperties())[0] != null && prop[0].getContents() != null) {
            if (prop[0].getContents().amount == 0) {
                return;
            }
            String formated = String.format("%.1f", Float.valueOf((float)prop[0].getContents().amount * 100.0f / (float)prop[0].getCapacity()));
            this.HUD.newString(I18n.func_135052_a((String)"metaarmor.hud.fuel_lvl", (Object[])new Object[]{formated + "%"}));
            NBTTagCompound data = item.func_77978_p();
            if (data != null && data.func_74764_b("hover")) {
                String status = data.func_74767_n("hover") ? I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
                String result = I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
                this.HUD.newString(result);
            }
        }
        this.HUD.draw();
        this.HUD.reset();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isNeedDrawHUD() {
        return true;
    }

    @Override
    public int getEnergyPerUse() {
        return 1;
    }

    @Override
    public boolean canUseEnergy(ItemStack stack, int amount) {
        FluidStack fuel = this.getFuel();
        if (fuel == null) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = this.getIFluidHandlerItem(stack);
        if (fluidHandlerItem == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandlerItem.drain(fuel, false);
        if (fluidStack == null) {
            return false;
        }
        return fluidStack.amount >= fuel.amount;
    }

    @Override
    public void drainEnergy(ItemStack stack, int amount) {
        if (this.burnTimer == 0) {
            FluidStack fuel = this.getFuel();
            if (fuel == null) {
                return;
            }
            this.getIFluidHandlerItem(stack).drain(fuel, true);
            this.burnTimer = this.currentRecipe.getDuration();
        }
        --this.burnTimer;
    }

    @Override
    public boolean hasEnergy(ItemStack stack) {
        return this.burnTimer > 0 || this.currentRecipe != null;
    }

    private IFluidHandlerItem getIFluidHandlerItem(@Nonnull ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public void findNewRecipe(@Nonnull ItemStack stack) {
        IFluidHandlerItem internalTank = this.getIFluidHandlerItem(stack);
        if (internalTank != null) {
            Recipe recipe;
            FluidStack fluidStack = internalTank.drain(1, false);
            if (this.previousRecipe != null && fluidStack != null && fluidStack.isFluidEqual(this.previousRecipe.getFluidInputs().get(0).getInputFluidStack()) && fluidStack.amount > 0) {
                this.currentRecipe = this.previousRecipe;
                return;
            }
            if (fluidStack != null && (recipe = RecipeMaps.COMBUSTION_GENERATOR_FUELS.find(Collections.emptyList(), Collections.singletonList(fluidStack), Objects::nonNull)) != null) {
                this.currentRecipe = this.previousRecipe = recipe;
                return;
            }
        }
        this.currentRecipe = null;
    }

    public FluidStack getFuel() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getFluidInputs().get(0).getInputFluidStack();
        }
        return null;
    }

    public ActionResult<ItemStack> onRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack armor;
        if (player.func_184586_b(hand).func_77973_b() instanceof ArmorMetaItem && (armor = player.func_184586_b(hand)).func_77973_b() instanceof ArmorMetaItem && ((ItemStack)player.field_71071_by.field_70460_b.get(this.getEquipmentSlot(player.func_184586_b(hand)).func_188454_b())).func_190926_b() && !player.func_70093_af()) {
            player.field_71071_by.field_70460_b.set(this.getEquipmentSlot(player.func_184586_b(hand)).func_188454_b(), (Object)armor.func_77946_l());
            player.func_184611_a(hand, ItemStack.field_190927_a);
            player.func_184185_a(new SoundEvent(new ResourceLocation("item.armor.equip_generic")), 1.0f, 1.0f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)armor);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, @Nonnull DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        int damageLimit = (int)Math.min(2.147483647E9, (double)this.burnTimer * 1.0 / 32.0 * 25.0);
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, damageLimit);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    public class Behaviour
    implements IItemDurabilityManager,
    IItemCapabilityProvider,
    IItemBehaviour,
    ISubItemHandler {
        public final int maxCapacity;
        private final Pair<Color, Color> durabilityBarColors;

        public Behaviour(int internalCapacity) {
            this.maxCapacity = internalCapacity;
            this.durabilityBarColors = GradientUtil.getGradient(12037896, 10);
        }

        @Override
        public double getDurabilityForDisplay(@Nonnull ItemStack itemStack) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem == null) {
                return 0.0;
            }
            IFluidTankProperties fluidTankProperties = fluidHandlerItem.getTankProperties()[0];
            FluidStack fluidStack = fluidTankProperties.getContents();
            return fluidStack == null ? 0.0 : (double)fluidStack.amount / (double)fluidTankProperties.getCapacity();
        }

        @Override
        @Nullable
        public Pair<Color, Color> getDurabilityColorsForDisplay(ItemStack itemStack) {
            return this.durabilityBarColors;
        }

        @Override
        public ICapabilityProvider createProvider(ItemStack itemStack) {
            return new FluidHandlerItemStack(itemStack, this.maxCapacity){

                public boolean canFillFluidType(FluidStack fluidStack) {
                    return RecipeMaps.COMBUSTION_GENERATOR_FUELS.find(Collections.emptyList(), Collections.singletonList(fluidStack), Objects::nonNull) != null;
                }

                public IFluidTankProperties[] getTankProperties() {
                    return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.capacity, true, false)};
                }
            };
        }

        @Override
        public void addInformation(ItemStack itemStack, List<String> lines) {
            IItemBehaviour.super.addInformation(itemStack, lines);
            NBTTagCompound data = GTUtility.getOrCreateNbtCompound(itemStack);
            String status = I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
            if (data.func_74764_b("hover") && data.func_74767_n("hover")) {
                status = I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]);
            }
            lines.add(I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status}));
        }

        @Override
        public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
            return PowerlessJetpack.this.onRightClick(world, player, hand);
        }

        @Override
        public String getItemSubType(ItemStack itemStack) {
            return "";
        }

        @Override
        public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
            ItemStack copy = itemStack.func_77946_l();
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem != null) {
                fluidHandlerItem.fill(Materials.Diesel.getFluid(16000), true);
                subItems.add((Object)copy);
            } else {
                subItems.add((Object)itemStack);
            }
        }
    }
}

