/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.craftingstation;

import com.google.common.base.Preconditions;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.ingredient.IRecipeTransferHandlerWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.recipes.KeySharedStack;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.OverlayedItemHandler;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.lwjgl.input.Mouse;

public class CraftingSlotWidget
extends SlotWidget
implements IRecipeTransferHandlerWidget {
    private final CraftingRecipeLogic recipeResolver;
    private boolean canTakeStack = false;

    public CraftingSlotWidget(CraftingRecipeLogic recipeResolver, int slotIndex, int xPosition, int yPosition) {
        super(CraftingSlotWidget.createInventory(recipeResolver), slotIndex, xPosition, yPosition, false, false);
        this.recipeResolver = recipeResolver;
    }

    private static IInventory createInventory(CraftingRecipeLogic resolver) {
        return resolver == null ? new InventoryCraftResult() : resolver.getCraftingResultInventory();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        block11: {
            block14: {
                EntityPlayer player;
                boolean isRightClick;
                boolean isLeftClick;
                block12: {
                    int crafts;
                    ItemStackKey toMerge;
                    OverlayedItemHandler playerInventory;
                    block13: {
                        super.handleClientAction(id, buffer);
                        if (id == 1) {
                            HashMap<Integer, ItemStack> ingredients = new HashMap<Integer, ItemStack>();
                            int ingredientAmount = buffer.func_150792_a();
                            try {
                                for (int i = 0; i < ingredientAmount; ++i) {
                                    ingredients.put(buffer.func_150792_a(), buffer.func_150791_c());
                                }
                            }
                            catch (IOException exception) {
                                throw new RuntimeException(exception);
                            }
                            this.recipeResolver.fillCraftingGrid(ingredients);
                        }
                        if (id != 2 || !this.recipeResolver.isRecipeValid()) break block11;
                        Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
                        boolean isShiftDown = clickData.isShiftClick;
                        isLeftClick = clickData.button == 0;
                        isRightClick = clickData.button == 1;
                        player = this.gui.entityPlayer;
                        if (!isShiftDown) break block12;
                        playerInventory = new OverlayedItemHandler((IItemHandler)new PlayerMainInvWrapper(this.gui.entityPlayer.field_71071_by));
                        toMerge = KeySharedStack.getRegisteredStack(this.slotReference.func_75211_c());
                        crafts = this.slotReference.func_75211_c().func_190916_E();
                        if (!isLeftClick) break block13;
                        int totalCrafts = 0;
                        int maxCrafts = this.slotReference.func_75211_c().func_77976_d() / this.slotReference.func_75211_c().func_190916_E();
                        for (int i = 0; i < maxCrafts; ++i) {
                            if (!this.canMergeToInv(playerInventory, toMerge, crafts) || !this.recipeResolver.performRecipe(this.gui.entityPlayer)) continue;
                            this.recipeResolver.refreshOutputSlot();
                            this.recipeResolver.handleItemCraft(this.slotReference.func_75211_c(), this.gui.entityPlayer);
                            totalCrafts += crafts;
                        }
                        ItemStack toAdd = this.slotReference.func_75211_c().func_77946_l();
                        toAdd.func_190920_e(totalCrafts);
                        player.field_71071_by.func_70441_a(toAdd);
                        break block14;
                    }
                    if (!isRightClick) break block14;
                    int totalCrafts = 0;
                    while (this.canMergeToInv(playerInventory, toMerge, crafts) && this.recipeResolver.performRecipe(this.gui.entityPlayer)) {
                        this.recipeResolver.refreshOutputSlot();
                        this.recipeResolver.handleItemCraft(this.slotReference.func_75211_c(), this.gui.entityPlayer);
                        totalCrafts += crafts;
                    }
                    ItemStack toAdd = this.slotReference.func_75211_c().func_77946_l();
                    toAdd.func_190920_e(totalCrafts);
                    player.field_71071_by.func_70441_a(toAdd);
                    break block14;
                }
                if (isLeftClick) {
                    if (this.canMerge(player.field_71071_by.func_70445_o(), this.slotReference.func_75211_c()) && this.recipeResolver.performRecipe(this.gui.entityPlayer)) {
                        this.recipeResolver.refreshOutputSlot();
                        this.recipeResolver.handleItemCraft(this.slotReference.func_75211_c(), this.gui.entityPlayer);
                        ItemStack result = this.slotReference.func_75211_c();
                        this.mergeToHand(result);
                    }
                } else if (isRightClick) {
                    while (this.canMerge(player.field_71071_by.func_70445_o(), this.slotReference.func_75211_c()) && this.recipeResolver.performRecipe(this.gui.entityPlayer)) {
                        this.recipeResolver.refreshOutputSlot();
                        this.recipeResolver.handleItemCraft(this.slotReference.func_75211_c(), this.gui.entityPlayer);
                        ItemStack result = this.slotReference.func_75211_c();
                        this.mergeToHand(result);
                    }
                }
            }
            this.uiAccess.sendHeldItemUpdate();
            this.gui.entityPlayer.field_71070_bA.func_75142_b();
            this.uiAccess.sendSlotUpdate(this);
        }
    }

    private boolean canMerge(ItemStack stack, ItemStack stack1) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stack1) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack1)) {
            return stack.func_190916_E() + stack1.func_190916_E() <= stack.func_77976_d();
        }
        return false;
    }

    private boolean canMergeToInv(OverlayedItemHandler inventory, ItemStackKey stack, int crafts) {
        return inventory.insertStackedItemStackKey(stack, crafts) == 0;
    }

    private void mergeToHand(ItemStack toMerge) {
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack itemInHand = this.gui.entityPlayer.field_71071_by.func_70445_o();
        if (itemInHand.func_190926_b()) {
            itemInHand = toMerge;
            player.field_71071_by.func_70437_b(itemInHand);
        } else if (ItemStack.func_179545_c((ItemStack)itemInHand, (ItemStack)toMerge) && ItemStack.func_77970_a((ItemStack)itemInHand, (ItemStack)toMerge) && itemInHand.func_190916_E() + toMerge.func_190916_E() <= itemInHand.func_77976_d()) {
            itemInHand.func_190917_f(toMerge.func_190916_E());
            player.field_71071_by.func_70437_b(itemInHand);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.recipeResolver == null) {
            return;
        }
        boolean isRecipeValid = this.recipeResolver.isRecipeValid();
        if (isRecipeValid != this.canTakeStack) {
            this.canTakeStack = isRecipeValid;
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.canTakeStack));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.canTakeStack = buffer.readBoolean();
        }
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), this.isShiftDown(), this.isCtrlDown());
            this.writeClientAction(2, clickData::writeToBuf);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public String transferRecipe(ModularUIContainer container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        HashMap ingredients = new HashMap(recipeLayout.getItemStacks().getGuiIngredients());
        ingredients.values().removeIf(it -> it.getAllIngredients().isEmpty() || !it.isInput());
        this.writeClientAction(1, buf -> {
            buf.func_150787_b(ingredients.size());
            for (Map.Entry entry : ingredients.entrySet()) {
                buf.func_150787_b(((Integer)entry.getKey()).intValue());
                ItemStack itemStack = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                Preconditions.checkNotNull((Object)itemStack);
                buf.func_150788_a(itemStack);
            }
        });
        return null;
    }
}

