/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverBehaviorUIFactory;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SyncableColorRectWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.FluidTankSwitchShim;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.VirtualTankRegistry;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.filter.FluidFilterContainer;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoverEnderFluidLink
extends CoverBehavior
implements CoverWithUI,
ITickable,
IControllable {
    public static final int TRANSFER_RATE = 8000;
    protected CoverPump.PumpMode pumpMode = CoverPump.PumpMode.IMPORT;
    private int color = -1;
    private UUID playerUUID = null;
    private boolean isPrivate = false;
    private boolean workingEnabled = true;
    private boolean ioEnabled = false;
    private String tempColorStr;
    private boolean isColorTemp;
    private final FluidTankSwitchShim linkedTank = new FluidTankSwitchShim(VirtualTankRegistry.getTankCreate(this.makeTankName(), null));
    protected final FluidFilterContainer fluidFilter = new FluidFilterContainer(this);

    public CoverEnderFluidLink(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    private String makeTankName() {
        return "EFLink#" + Integer.toHexString(this.color).toUpperCase();
    }

    private UUID getTankUUID() {
        return this.isPrivate ? this.playerUUID : null;
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilter;
    }

    public boolean isIOEnabled() {
        return this.ioEnabled;
    }

    @Override
    public boolean canAttach() {
        return this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide) != null;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.ENDER_FLUID_LINK.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void onAttached(ItemStack itemStack, EntityPlayer player) {
        super.onAttached(itemStack, player);
        if (player != null) {
            this.playerUUID = player.func_110124_au();
        }
    }

    @Override
    public void onRemoved() {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, (IItemHandlerModifiable)this.fluidFilter.getFilterInventory());
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.coverHolder.getWorld(), (BlockPos)this.coverHolder.getPos(), (ItemStack)itemStack);
        }
    }

    public void func_73660_a() {
        if (this.workingEnabled && this.ioEnabled) {
            this.transferFluids();
        }
    }

    protected void transferFluids() {
        IFluidHandler fluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide);
        if (fluidHandler == null) {
            return;
        }
        if (this.pumpMode == CoverPump.PumpMode.IMPORT) {
            GTTransferUtils.transferFluids(fluidHandler, this.linkedTank, 8000, this.fluidFilter::testFluidStack);
        } else if (this.pumpMode == CoverPump.PumpMode.EXPORT) {
            GTTransferUtils.transferFluids(this.linkedTank, fluidHandler, 8000, this.fluidFilter::testFluidStack);
        }
    }

    public void setPumpMode(CoverPump.PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.coverHolder.markDirty();
    }

    public CoverPump.PumpMode getPumpMode() {
        return this.pumpMode;
    }

    @Override
    public void openUI(EntityPlayerMP player) {
        CoverBehaviorUIFactory.INSTANCE.openUI(this, player);
        this.isColorTemp = false;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.addWidget(new LabelWidget(10, 5, "cover.ender_fluid_link.title", new Object[0]));
        widgetGroup.addWidget(new ToggleButtonWidget(12, 18, 18, 18, GuiTextures.BUTTON_PUBLIC_PRIVATE, this::isPrivate, this::setPrivate).setTooltipText("cover.ender_fluid_link.private.tooltip", new Object[0]));
        widgetGroup.addWidget(new SyncableColorRectWidget(35, 18, 18, 18, () -> this.color).setBorderWidth(1).drawCheckerboard(4, 4));
        widgetGroup.addWidget(new TextFieldWidget(58, 13, 58, 18, true, this::getColorStr, this::updateColor, 8).setValidator(str -> str.matches("[0-9a-fA-F]*")));
        widgetGroup.addWidget(new TankWidget(this.linkedTank, 123, 18, 18, 18).setContainerClicking(true, true).setBackgroundTexture(GuiTextures.FLUID_SLOT).setAlwaysShowFull(true));
        widgetGroup.addWidget(new ImageWidget(147, 19, 16, 16).setImage(GuiTextures.INFO_ICON).setPredicate(() -> this.isColorTemp).setTooltip("cover.ender_fluid_link.incomplete_hex").setIgnoreColor(true));
        widgetGroup.addWidget(new CycleButtonWidget(10, 42, 75, 18, CoverPump.PumpMode.class, this::getPumpMode, this::setPumpMode));
        widgetGroup.addWidget(new CycleButtonWidget(92, 42, 75, 18, this::isIoEnabled, this::setIoEnabled, "cover.ender_fluid_link.iomode.disabled", "cover.ender_fluid_link.iomode.enabled"));
        this.fluidFilter.initUI(65, widgetGroup::addWidget);
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 221).widget(widgetGroup).bindPlayerInventory(player.field_71071_by, 139).build(this, player);
    }

    public void updateColor(String str) {
        if (str.length() == 8) {
            this.isColorTemp = false;
            long tmp = Long.parseLong(str, 16);
            if (tmp > Integer.MAX_VALUE) {
                tmp -= 0x100000000L;
            }
            this.color = (int)tmp;
            this.updateTankLink();
        } else {
            this.tempColorStr = str;
            this.isColorTemp = true;
        }
    }

    public String getColorStr() {
        return this.isColorTemp ? this.tempColorStr : Integer.toHexString(this.color).toUpperCase();
    }

    public void updateTankLink() {
        this.linkedTank.changeTank(VirtualTankRegistry.getTankCreate(this.makeTankName(), this.getTankUUID()));
        this.coverHolder.markDirty();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("Frequency", this.color);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.workingEnabled);
        tagCompound.func_74757_a("IOAllowed", this.ioEnabled);
        tagCompound.func_74757_a("Private", this.isPrivate);
        tagCompound.func_74778_a("PlacedUUID", this.playerUUID.toString());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilter.serializeNBT());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.color = tagCompound.func_74762_e("Frequency");
        this.pumpMode = CoverPump.PumpMode.values()[tagCompound.func_74762_e("PumpMode")];
        this.workingEnabled = tagCompound.func_74767_n("WorkingAllowed");
        this.ioEnabled = tagCompound.func_74767_n("IOAllowed");
        this.isPrivate = tagCompound.func_74767_n("Private");
        this.playerUUID = UUID.fromString(tagCompound.func_74779_i("PlacedUUID"));
        this.fluidFilter.deserializeNBT(tagCompound.func_74775_l("Filter"));
        this.updateTankLink();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.color);
        packetBuffer.func_180714_a(this.playerUUID == null ? "null" : this.playerUUID.toString());
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        this.color = packetBuffer.readInt();
        String uuidStr = packetBuffer.func_150789_c(36);
        this.playerUUID = uuidStr.equals("null") ? null : UUID.fromString(uuidStr);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.workingEnabled = isActivationAllowed;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.linkedTank);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    private boolean isIoEnabled() {
        return this.ioEnabled;
    }

    private void setIoEnabled(boolean ioEnabled) {
        this.ioEnabled = ioEnabled;
    }

    private boolean isPrivate() {
        return this.isPrivate;
    }

    private void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        this.updateTankLink();
    }
}

