/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import codechicken.lib.vec.Cuboid6;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBufferHelper {
    public static void renderCubeFrame(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void renderCubeFace(BufferBuilder buffer, Cuboid6 cuboid, float r, float g, float b, float a, boolean shade) {
        RenderBufferHelper.renderCubeFace(buffer, cuboid.min.x, cuboid.min.y, cuboid.min.z, cuboid.max.x, cuboid.max.y, cuboid.max.z, r, g, b, a, shade);
    }

    public static void renderCubeFace(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        RenderBufferHelper.renderCubeFace(buffer, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha, false);
    }

    public static void renderCubeFace(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float a, boolean shade) {
        float r = red;
        float g = green;
        float b = blue;
        if (shade) {
            r = (float)((double)r * 0.6);
            g = (float)((double)g * 0.6);
            b = (float)((double)b * 0.6);
        }
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        if (shade) {
            r = red * 0.5f;
            g = green * 0.5f;
            b = blue * 0.5f;
        }
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        if (shade) {
            r = red;
            g = green;
            b = blue;
        }
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        if (shade) {
            r = red * 0.8f;
            g = green * 0.8f;
            b = blue * 0.8f;
        }
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void renderRing(BufferBuilder buffer, double x, double y, double z, double r, double tubeRadius, int sides, int segments, float red, float green, float blue, float alpha, EnumFacing.Axis axis) {
        double sideDelta = Math.PI * 2 / (double)sides;
        double ringDelta = Math.PI * 2 / (double)segments;
        double theta = 0.0;
        double cosTheta = 1.0;
        double sinTheta = 0.0;
        for (int i = 0; i < segments; ++i) {
            double theta1 = theta + ringDelta;
            double cosTheta1 = MathHelper.func_76134_b((float)((float)theta1));
            double sinTheta1 = MathHelper.func_76126_a((float)((float)theta1));
            double phi = 0.0;
            block6: for (int j = 0; j <= sides; ++j) {
                double cosPhi = MathHelper.func_76134_b((float)((float)(phi += sideDelta)));
                double sinPhi = MathHelper.func_76126_a((float)((float)phi));
                double dist = r + tubeRadius * cosPhi;
                switch (axis) {
                    case Y: {
                        buffer.func_181662_b(x + sinTheta * dist, y + tubeRadius * sinPhi, z + cosTheta * dist).func_181666_a(red, green, blue, alpha).func_181675_d();
                        buffer.func_181662_b(x + sinTheta1 * dist, y + tubeRadius * sinPhi, z + cosTheta1 * dist).func_181666_a(red, green, blue, alpha).func_181675_d();
                        continue block6;
                    }
                    case X: {
                        buffer.func_181662_b(x + tubeRadius * sinPhi, y + sinTheta * dist, z + cosTheta * dist).func_181666_a(red, green, blue, alpha).func_181675_d();
                        buffer.func_181662_b(x + tubeRadius * sinPhi, y + sinTheta1 * dist, z + cosTheta1 * dist).func_181666_a(red, green, blue, alpha).func_181675_d();
                        continue block6;
                    }
                    case Z: {
                        buffer.func_181662_b(x + cosTheta * dist, y + sinTheta * dist, z + tubeRadius * sinPhi).func_181666_a(red, green, blue, alpha).func_181675_d();
                        buffer.func_181662_b(x + cosTheta1 * dist, y + sinTheta1 * dist, z + tubeRadius * sinPhi).func_181666_a(red, green, blue, alpha).func_181675_d();
                    }
                }
            }
            theta = theta1;
            cosTheta = cosTheta1;
            sinTheta = sinTheta1;
        }
    }
}

