/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvCCRSConsumer
implements IVertexConsumer {
    private final CCRenderState ccrs;
    private Matrix4 translation = new Matrix4();

    public AdvCCRSConsumer(CCRenderState ccrs) {
        this.ccrs = ccrs;
    }

    @Nonnull
    public VertexFormat getVertexFormat() {
        return this.ccrs.getVertexFormat();
    }

    public void setTexture(@Nonnull TextureAtlasSprite texture) {
        this.ccrs.sprite = texture;
    }

    public void put(int e, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement fmte = format.func_177348_c(e);
        switch (fmte.func_177375_c()) {
            case POSITION: {
                this.ccrs.vert.vec.set(data).apply((Transformation)this.translation);
                break;
            }
            case UV: {
                if (fmte.func_177369_e() == 0) {
                    this.ccrs.vert.uv.set((double)data[0], (double)data[1]);
                    break;
                }
                this.ccrs.brightness = (int)(data[1] * 65535.0f / 2.0f) << 16 | (int)(data[0] * 65535.0f / 2.0f);
                break;
            }
            case COLOR: {
                this.ccrs.colour = Colour.packRGBA((float[])data);
                break;
            }
            case NORMAL: {
                this.ccrs.normal.set(data);
                break;
            }
            case PADDING: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Generic vertex format element");
            }
        }
        if (e == format.func_177345_h() - 1) {
            this.ccrs.writeVert();
        }
    }

    public void setTranslation(Matrix4 translation) {
        this.translation = translation;
    }

    public void setQuadTint(int tint) {
    }

    public void setQuadOrientation(@Nonnull EnumFacing orientation) {
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
    }
}

