/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.fx;

import codechicken.lib.vec.Vector3;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LaserBeamRenderer {
    public static void renderRawBeam(int texture, int headTexture, Vector3 direction, Vector3 cameraDirection, double beamHeight, double headWidth, float alpha, double offset) {
        if (direction.x == direction.z && direction.x == 0.0) {
            direction = direction.copy().add(0.001, 0.0, 0.001);
        }
        if (texture != -1) {
            GlStateManager.func_179144_i((int)texture);
        }
        double distance = direction.mag();
        double start = Math.min(headWidth, distance * headWidth);
        distance -= start;
        float degree = (float)Math.toDegrees(new Vector3(direction.x, 0.0, -direction.z).angle(new Vector3(1.0, 0.0, 0.0)));
        if (direction.z > 0.0) {
            degree = -degree;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)degree, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(90.0f - (float)Math.toDegrees(direction.copy().angle(new Vector3(0.0, 1.0, 0.0)))), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (cameraDirection != null) {
            Vector3 v1 = cameraDirection.copy().project(direction).subtract(cameraDirection);
            Vector3 v2 = new Vector3(0.0, 1.0, 0.0).crossProduct(direction);
            float rowX = (float)Math.toDegrees(v1.copy().angle(v2));
            if (v1.add((Vector3)v2).y < 0.0) {
                rowX = -rowX;
            }
            GlStateManager.func_179114_b((float)rowX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(distance, -beamHeight, 0.0).func_187315_a(offset + distance, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            bufferbuilder.func_181662_b(start, -beamHeight, 0.0).func_187315_a(offset, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            bufferbuilder.func_181662_b(start, beamHeight, 0.0).func_187315_a(offset, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            bufferbuilder.func_181662_b(distance, beamHeight, 0.0).func_187315_a(offset + distance, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            tessellator.func_78381_a();
            if (headTexture != -1) {
                GlStateManager.func_179144_i((int)headTexture);
                GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b(start, -beamHeight, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(0.0, -beamHeight, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(0.0, beamHeight, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(start, beamHeight, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b(distance + start, -beamHeight, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(distance, -beamHeight, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(distance, beamHeight, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(distance + start, beamHeight, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                tessellator.func_78381_a();
            }
        } else {
            int i;
            for (i = 0; i < 2; ++i) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b(distance, -beamHeight, 0.0).func_187315_a(offset + distance, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(start, -beamHeight, 0.0).func_187315_a(offset, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(start, beamHeight, 0.0).func_187315_a(offset, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                bufferbuilder.func_181662_b(distance, beamHeight, 0.0).func_187315_a(offset + distance, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                tessellator.func_78381_a();
            }
            if (headTexture != -1) {
                GlStateManager.func_179144_i((int)headTexture);
                for (i = 0; i < 2; ++i) {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    bufferbuilder.func_181662_b(start, -beamHeight, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, -beamHeight, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(0.0, beamHeight, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(start, beamHeight, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    tessellator.func_78381_a();
                }
                for (i = 0; i < 2; ++i) {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    bufferbuilder.func_181662_b(distance + start, -beamHeight, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(distance, -beamHeight, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(distance, beamHeight, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    bufferbuilder.func_181662_b(distance + start, beamHeight, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179121_F();
    }
}

