/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.particle.GTParticle;
import gregtech.client.particle.IGTParticleHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GTTexturedParticle
extends GTParticle {
    private static final Map<ResourceLocation, IGTParticleHandler> textureMap = new HashMap<ResourceLocation, IGTParticleHandler>();
    private ResourceLocation customTexture;

    public GTTexturedParticle(World worldIn, double posXIn, double posYIn, double posZIn, ResourceLocation texture, int textureCount) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.setTexture(texture);
        this.setTexturesCount(textureCount);
    }

    public GTTexturedParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, ResourceLocation texture, int textureCount) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.setTexture(texture);
        this.setTexturesCount(textureCount);
    }

    public void setTexture(ResourceLocation texture) {
        this.customTexture = texture;
        if (!textureMap.containsKey(texture)) {
            textureMap.put(texture, new TexturedParticleHandler(texture));
        }
    }

    @Override
    public final IGTParticleHandler getGLHandler() {
        return textureMap.get(this.customTexture);
    }

    private static class TexturedParticleHandler
    implements IGTParticleHandler {
        private final ResourceLocation texture;

        public TexturedParticleHandler(ResourceLocation texture) {
            this.texture = texture;
        }

        @Override
        public void preDraw(BufferBuilder buffer) {
            ResourceHelper.bindTexture(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        @Override
        public void postDraw(BufferBuilder buffer) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

