/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.api.util.GTLog;
import gregtech.client.particle.GTParticle;
import gregtech.client.particle.IGTParticleHandler;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GTParticleManager {
    public static final GTParticleManager INSTANCE = new GTParticleManager();
    private static World currentWorld = null;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueueBack = new HashMap<IGTParticleHandler, ArrayDeque<GTParticle>>();
    private final Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueueFront = new HashMap<IGTParticleHandler, ArrayDeque<GTParticle>>();
    private final Queue<Tuple<IGTParticleHandler, GTParticle>> newParticleQueue = new ArrayDeque<Tuple<IGTParticleHandler, GTParticle>>();

    public void addEffect(GTParticle ... particles) {
        for (GTParticle particle : particles) {
            if (particle.getGLHandler() == null) continue;
            this.newParticleQueue.add((Tuple<IGTParticleHandler, GTParticle>)new Tuple((Object)particle.getGLHandler(), (Object)particle));
        }
    }

    public void updateEffects() {
        this.updateEffectLayer();
        if (!this.newParticleQueue.isEmpty()) {
            Tuple<IGTParticleHandler, GTParticle> handlerParticle = this.newParticleQueue.poll();
            while (handlerParticle != null) {
                ArrayDeque<GTParticle> arrayDeque;
                Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueue;
                IGTParticleHandler handler = (IGTParticleHandler)handlerParticle.func_76341_a();
                GTParticle particle = (GTParticle)((Object)handlerParticle.func_76340_b());
                Map<IGTParticleHandler, ArrayDeque<GTParticle>> map = renderQueue = particle.func_70537_b() > 0 ? this.renderQueueFront : this.renderQueueBack;
                if (!renderQueue.containsKey(handler)) {
                    renderQueue.put(handler, new ArrayDeque());
                }
                if ((arrayDeque = renderQueue.get(handler)).size() > 6000) {
                    arrayDeque.removeFirst().func_187112_i();
                }
                arrayDeque.add(particle);
                handlerParticle = this.newParticleQueue.poll();
            }
        }
    }

    private void updateEffectLayer() {
        if (!this.renderQueueBack.isEmpty()) {
            this.updateQueue(this.renderQueueBack);
        }
        if (!this.renderQueueFront.isEmpty()) {
            this.updateQueue(this.renderQueueFront);
        }
    }

    private void updateQueue(Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueue) {
        Iterator<Map.Entry<IGTParticleHandler, ArrayDeque<GTParticle>>> entryIterator = renderQueue.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IGTParticleHandler, ArrayDeque<GTParticle>> entry = entryIterator.next();
            Iterator<GTParticle> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            entryIterator.remove();
        }
    }

    public void clearAllEffects(boolean cleanNewQueue) {
        if (cleanNewQueue) {
            for (Tuple tuple : this.newParticleQueue) {
                ((GTParticle)((Object)tuple.func_76340_b())).func_187112_i();
            }
            this.newParticleQueue.clear();
        }
        for (ArrayDeque arrayDeque : this.renderQueueBack.values()) {
            arrayDeque.forEach(Particle::func_187112_i);
        }
        for (ArrayDeque arrayDeque : this.renderQueueFront.values()) {
            arrayDeque.forEach(Particle::func_187112_i);
        }
        this.renderQueueBack.clear();
        this.renderQueueFront.clear();
    }

    private void tickParticle(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            GTLog.logger.error("particle update error: {}", (Object)particle.toString(), (Object)throwable);
            particle.func_187112_i();
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        if (this.renderQueueBack.isEmpty() && this.renderQueueFront.isEmpty()) {
            return;
        }
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179140_f();
        this.renderGlParticlesInLayer(this.renderQueueBack, tessellator, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        GlStateManager.func_179132_a((boolean)false);
        this.renderGlParticlesInLayer(this.renderQueueFront, tessellator, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    private void renderGlParticlesInLayer(Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueue, Tessellator tessellator, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        for (IGTParticleHandler handler : renderQueue.keySet()) {
            ArrayDeque<GTParticle> particles = renderQueue.get(handler);
            if (particles.isEmpty()) continue;
            BufferBuilder buffer = tessellator.func_178180_c();
            handler.preDraw(buffer);
            for (GTParticle particle : particles) {
                if (!particle.shouldRendered(entityIn, partialTicks)) continue;
                try {
                    particle.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
                }
                catch (Throwable throwable) {
                    GTLog.logger.error("particle render error: {}", (Object)particle.toString(), (Object)throwable);
                    particle.func_187112_i();
                }
            }
            handler.postDraw(buffer);
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || mc.func_147113_T()) {
            return;
        }
        if (currentWorld != GTParticleManager.mc.field_71441_e) {
            INSTANCE.clearAllEffects(currentWorld != null);
            currentWorld = GTParticleManager.mc.field_71441_e;
        }
        if (currentWorld != null) {
            INSTANCE.updateEffects();
        }
    }

    public static void renderWorld(RenderWorldLastEvent event) {
        Entity entity = mc.func_175606_aa();
        INSTANCE.renderParticles((Entity)(entity == null ? GTParticleManager.mc.field_71439_g : entity), event.getPartialTicks());
    }

    public static void debugOverlay(RenderGameOverlayEvent.Text event) {
        if (event.getLeft().size() >= 5) {
            String particleTxt = (String)event.getLeft().get(4);
            particleTxt = particleTxt + "." + TextFormatting.GOLD + " PARTICLE-BACK: " + INSTANCE.getStatistics(GTParticleManager.INSTANCE.renderQueueBack) + "PARTICLE-FRONt: " + INSTANCE.getStatistics(GTParticleManager.INSTANCE.renderQueueFront);
            event.getLeft().set(4, particleTxt);
        }
    }

    public String getStatistics(Map<IGTParticleHandler, ArrayDeque<GTParticle>> renderQueue) {
        int g = 0;
        for (ArrayDeque<GTParticle> queue : renderQueue.values()) {
            g += queue.size();
        }
        return " GLFX: " + g;
    }
}

