/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class XSTR
extends Random {
    private static final long serialVersionUID = 6208727693524452904L;
    private long seed;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    boolean haveNextNextGaussian = false;
    double nextNextGaussian = 0.0;

    public XSTR() {
        this(XSTR.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current = seedUniquifier.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public XSTR(long seed) {
        this.seed = seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized long getSeed() {
        return this.seed;
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.seed = seed;
    }

    public XSTR clone() {
        return new XSTR(this.getSeed());
    }

    @Override
    public int next(int nbits) {
        long x = this.seed;
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        this.seed = x;
        return (int)(x &= (1L << nbits) - 1L);
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    public int nextInt(int bound) {
        long last = this.seed ^ this.seed << 21;
        last ^= last >>> 35;
        last ^= last << 4;
        this.seed = last;
        int out = (int)last % bound;
        return out < 0 ? -out : out;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) * 5.9604645E-8f;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public void nextBytes(byte[] bytes_arr) {
        int iba = 0;
        int lenba = bytes_arr.length;
        while (iba < lenba) {
            int rndba = this.nextInt();
            int nba = Math.min(lenba - iba, 4);
            while (nba-- > 0) {
                bytes_arr[iba++] = (byte)rndba;
                rndba >>= 8;
            }
        }
    }
}

