/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class TextFormattingUtil {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    public static String formatLongToCompactString(long value, int precision) {
        if (value == Long.MIN_VALUE) {
            return TextFormattingUtil.formatLongToCompactString(-9223372036854775807L, precision);
        }
        if (value < 0L) {
            return "-" + TextFormattingUtil.formatLongToCompactString(-value, precision);
        }
        if ((double)value < Math.pow(10.0, precision)) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String formatLongToCompactString(long value) {
        return TextFormattingUtil.formatLongToCompactString(value, 3);
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

