/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import com.google.common.base.Preconditions;
import gregtech.api.fluids.fluidType.FluidType;
import gregtech.api.fluids.fluidType.FluidTypes;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidProperty
implements IMaterialProperty<FluidProperty> {
    public static final int BASE_TEMP = 293;
    private Fluid fluid;
    private final FluidType fluidType;
    private boolean hasBlock;
    private boolean isGas;
    private int fluidTemperature = 293;

    public FluidProperty(@Nonnull FluidType fluidType, boolean hasBlock) {
        this.fluidType = fluidType;
        this.isGas = fluidType == FluidTypes.GAS;
        this.hasBlock = hasBlock;
    }

    public FluidProperty() {
        this(FluidTypes.LIQUID, false);
    }

    public boolean isGas() {
        return this.isGas;
    }

    public void setFluid(@Nonnull Fluid materialFluid) {
        Preconditions.checkNotNull((Object)materialFluid);
        this.fluid = materialFluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean hasBlock() {
        return this.hasBlock;
    }

    public void setHasBlock(boolean hasBlock) {
        this.hasBlock = hasBlock;
    }

    public void setIsGas(boolean isGas) {
        this.isGas = isGas;
    }

    @Nonnull
    public FluidStack getFluid(int amount) {
        return new FluidStack(this.fluid, amount);
    }

    public void setFluidTemperature(int fluidTemperature) {
        this.setFluidTemperature(fluidTemperature, true);
    }

    public void setFluidTemperature(int fluidTemperature, boolean isKelvin) {
        if (isKelvin) {
            Preconditions.checkArgument((fluidTemperature >= 0 ? 1 : 0) != 0, (Object)"Invalid temperature");
        } else {
            fluidTemperature += 273;
        }
        this.fluidTemperature = fluidTemperature;
        if (this.fluid != null) {
            this.fluid.setTemperature(fluidTemperature);
        }
    }

    public int getFluidTemperature() {
        return this.fluidTemperature;
    }

    @Nonnull
    public FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        if (properties.hasProperty(PropertyKey.PLASMA)) {
            this.hasBlock = false;
        }
    }
}

