/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.info;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTLog;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class MaterialFlag {
    private static final Set<MaterialFlag> FLAG_REGISTRY = new HashSet<MaterialFlag>();
    private final String name;
    private final Set<MaterialFlag> requiredFlags;
    private final Set<PropertyKey<?>> requiredProperties;

    private MaterialFlag(String name, Set<MaterialFlag> requiredFlags, Set<PropertyKey<?>> requiredProperties) {
        this.name = name;
        this.requiredFlags = requiredFlags;
        this.requiredProperties = requiredProperties;
        FLAG_REGISTRY.add(this);
    }

    public boolean equals(Object o) {
        if (o instanceof MaterialFlag) {
            return ((MaterialFlag)o).name.equals(this.name);
        }
        return false;
    }

    protected Set<MaterialFlag> verifyFlag(Material material) {
        this.requiredProperties.forEach(key -> {
            if (!material.hasProperty(key)) {
                GTLog.logger.warn("Material {} does not have required property {} for flag {}!", (Object)material.getUnlocalizedName(), (Object)key.toString(), (Object)this.name);
            }
        });
        HashSet<MaterialFlag> thisAndDependencies = new HashSet<MaterialFlag>(this.requiredFlags);
        thisAndDependencies.addAll(this.requiredFlags.stream().map(f -> f.verifyFlag(material)).flatMap(Collection::stream).collect(Collectors.toSet()));
        return thisAndDependencies;
    }

    public String toString() {
        return this.name;
    }

    public static MaterialFlag getByName(String name) {
        return FLAG_REGISTRY.stream().filter(f -> f.toString().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static class Builder {
        final String name;
        final Set<MaterialFlag> requiredFlags = new HashSet<MaterialFlag>();
        final Set<PropertyKey<?>> requiredProperties = new HashSet();

        public Builder(String name) {
            this.name = name;
        }

        public Builder requireFlags(MaterialFlag ... flags) {
            this.requiredFlags.addAll(Arrays.asList(flags));
            return this;
        }

        public Builder requireProps(PropertyKey<?> ... propertyKeys) {
            this.requiredProperties.addAll(Arrays.asList(propertyKeys));
            return this;
        }

        public MaterialFlag build() {
            return new MaterialFlag(this.name, this.requiredFlags, this.requiredProperties);
        }
    }
}

