/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.util;

import gregtech.api.terminal.util.TreeNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileTree
extends TreeNode<File, File> {
    public FileTree(File dir) {
        this(0, dir);
    }

    private FileTree(int dimension, File key) {
        super(dimension, key);
    }

    @Override
    public boolean isLeaf() {
        return ((File)this.getKey()).isFile();
    }

    @Override
    public File getContent() {
        return this.isLeaf() ? (File)this.getKey() : null;
    }

    @Override
    public List<TreeNode<File, File>> getChildren() {
        if (this.children == null && !this.isLeaf()) {
            this.children = new ArrayList();
            Arrays.stream(((File)this.key).listFiles()).sorted((a, b) -> {
                if (a.isFile() && b.isFile()) {
                    return a.compareTo((File)b);
                }
                if (a.isDirectory() && b.isDirectory()) {
                    return a.compareTo((File)b);
                }
                if (a.isDirectory()) {
                    return -1;
                }
                return 1;
            }).forEach(file -> this.children.add(new FileTree(this.dimension + 1, (File)file)));
        }
        return super.getChildren();
    }

    @Override
    public String toString() {
        return ((File)this.getKey()).getName();
    }
}

