/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os;

import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TerminalDesktopWidget
extends WidgetGroup {
    private final TerminalOSWidget os;
    private final WidgetGroup appDiv;
    private final List<Widget> topWidgets;
    private int rowCount = 7;

    public TerminalDesktopWidget(Position position, Size size, TerminalOSWidget os) {
        super(position, size);
        this.os = os;
        this.appDiv = new WidgetGroup();
        this.addWidget(this.appDiv);
        this.topWidgets = new LinkedList<Widget>();
    }

    public void installApplication(AbstractApplication application) {
        int r = 12;
        int index = this.appDiv.widgets.size();
        int x = this.getSize().width / 2 + 3 * r * (index % this.rowCount - this.rowCount / 2);
        int y = index / this.rowCount * (3 * r) + 40;
        CircleButtonWidget button = new CircleButtonWidget(x, y).setColors(TerminalTheme.COLOR_B_2.getColor(), application.getThemeColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(application.getIcon()).setHoverText(application.getUnlocalizedName());
        button.setClickListener(clickData -> this.os.openApplication(application, clickData.isClient));
        this.appDiv.addWidget(button);
    }

    @SideOnly(value=Side.CLIENT)
    public void addTopWidget(Widget widget) {
        this.topWidgets.add(widget);
    }

    @SideOnly(value=Side.CLIENT)
    public void removeTopWidget(Widget widget) {
        this.topWidgets.remove(widget);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean topWidgetsMouseOver(Widget widget, int mouseX, int mouseY) {
        if (widget.isMouseOverElement(mouseX, mouseY)) {
            return true;
        }
        if (widget instanceof WidgetGroup) {
            for (Widget child : ((WidgetGroup)widget).widgets) {
                if (!child.isVisible() || !this.topWidgetsMouseOver(child, mouseX, mouseY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        boolean isBlocked = false;
        for (Widget topWidget : this.topWidgets) {
            if (!this.topWidgetsMouseOver(topWidget, mouseX, mouseY)) continue;
            isBlocked = true;
            break;
        }
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || isBlocked && widget instanceof AbstractApplication) continue;
            widget.drawInForeground(mouseX, mouseY);
        }
    }

    public void showDesktop() {
        this.appDiv.setActive(true);
        this.appDiv.setVisible(true);
    }

    public void hideDesktop() {
        this.appDiv.setActive(false);
        this.appDiv.setVisible(false);
    }

    public void removeAllDialogs() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof TerminalDialogWidget)) continue;
            ((TerminalDialogWidget)widget).close();
        }
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        this.rowCount = (size.width - 81) / 36;
        int r = 12;
        for (int i = this.appDiv.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.appDiv.widgets.get(i);
            int x = this.getSize().width / 2 + 3 * r * (i % this.rowCount - this.rowCount / 2);
            int y = i / this.rowCount * (3 * r) + 40;
            widget.setSelfPosition(new Position(x - r, y - r));
        }
    }
}

