/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.IDraggable;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import net.minecraft.util.math.MathHelper;

public class DraggableScrollableWidgetGroup
extends WidgetGroup {
    protected int scrollXOffset;
    protected int scrollYOffset;
    protected int xBarHeight;
    protected int yBarWidth;
    protected boolean draggable;
    protected IGuiTexture background;
    protected int maxHeight;
    protected int maxWidth;
    protected IGuiTexture xBarB;
    protected IGuiTexture xBarF;
    protected IGuiTexture yBarB;
    protected IGuiTexture yBarF;
    protected boolean focus;
    protected Widget draggedWidget;
    protected boolean useScissor;
    private int lastMouseX;
    private int lastMouseY;
    private boolean draggedPanel;
    private boolean draggedOnXScrollBar;
    private boolean draggedOnYScrollBar;

    public DraggableScrollableWidgetGroup(int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.maxHeight = height;
        this.maxWidth = width;
        this.useScissor = true;
    }

    public DraggableScrollableWidgetGroup setXScrollBarHeight(int xBar) {
        this.xBarHeight = xBar;
        return this;
    }

    public DraggableScrollableWidgetGroup setYScrollBarWidth(int yBar) {
        this.yBarWidth = yBar;
        return this;
    }

    public DraggableScrollableWidgetGroup setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public DraggableScrollableWidgetGroup setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public DraggableScrollableWidgetGroup setXBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.xBarB = background;
        this.xBarF = bar;
        return this;
    }

    public DraggableScrollableWidgetGroup setYBarStyle(IGuiTexture background, IGuiTexture bar) {
        this.yBarB = background;
        this.yBarF = bar;
        return this;
    }

    public void setUseScissor(boolean useScissor) {
        this.useScissor = useScissor;
    }

    public int getScrollYOffset() {
        return this.scrollYOffset;
    }

    public int getScrollXOffset() {
        return this.scrollXOffset;
    }

    @Override
    public void addWidget(Widget widget) {
        this.maxHeight = Math.max(this.maxHeight, widget.getSize().height + widget.getSelfPosition().y);
        this.maxWidth = Math.max(this.maxWidth, widget.getSize().width + widget.getSelfPosition().x);
        Position newPos = widget.addSelfPosition(-this.scrollXOffset, -this.scrollYOffset);
        widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        super.addWidget(widget);
    }

    @Override
    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        this.computeMax();
    }

    @Override
    public void clearAllWidgets() {
        super.clearAllWidgets();
        this.maxHeight = this.getSize().height;
        this.maxWidth = this.getSize().width;
        this.scrollXOffset = 0;
        this.scrollYOffset = 0;
    }

    @Override
    public void setSize(Size size) {
        super.setSize(size);
        this.maxHeight = Math.max(size.height, this.maxHeight);
        this.maxWidth = Math.max(size.width, this.maxWidth);
        for (Widget widget : this.widgets) {
            Position newPos = widget.getSelfPosition();
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
    }

    public void computeMax() {
        int mh = 0;
        int mw = 0;
        for (Widget widget : this.widgets) {
            mh = Math.max(mh, widget.getSize().height + widget.getSelfPosition().y + this.scrollYOffset);
            mw = Math.max(mw, widget.getSize().width + widget.getSelfPosition().x + this.scrollXOffset);
        }
        int offsetY = 0;
        int offsetX = 0;
        if (mh > this.getSize().height) {
            offsetY = this.maxHeight - mh;
            this.maxHeight = mh;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        } else if (mh < this.getSize().height) {
            offsetY = this.maxHeight - this.getSize().height;
            this.maxHeight = this.getSize().height;
            if (this.scrollYOffset - offsetY < 0) {
                offsetY = this.scrollYOffset;
            }
            this.scrollYOffset -= offsetY;
        }
        if (mw > this.getSize().width) {
            offsetX = this.maxWidth - mw;
            this.maxWidth = mw;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        } else if (mw < this.getSize().width) {
            offsetX = this.maxWidth - this.getSize().width;
            this.maxWidth = this.getSize().width;
            if (this.scrollXOffset - offsetX < 0) {
                offsetX = this.scrollXOffset;
            }
            this.scrollXOffset -= offsetX;
        }
        if (offsetX != 0 || offsetY != 0) {
            for (Widget widget : this.widgets) {
                Position newPos = widget.addSelfPosition(offsetX, offsetY);
                widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
                widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
            }
        }
    }

    protected int getMaxHeight() {
        return this.maxHeight + this.xBarHeight;
    }

    protected int getMaxWidth() {
        return this.maxWidth + this.yBarWidth;
    }

    public int getWidgetBottomHeight() {
        int y = 0;
        for (Widget widget : this.widgets) {
            y = Math.max(y, widget.getSize().height + widget.getSelfPosition().y);
        }
        return y;
    }

    protected void setScrollXOffset(int scrollXOffset) {
        if (scrollXOffset == this.scrollXOffset) {
            return;
        }
        int offset = scrollXOffset - this.scrollXOffset;
        this.scrollXOffset = scrollXOffset;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(-offset, 0);
            widget.setVisible(newPos.x < this.getSize().width - this.yBarWidth && newPos.x + widget.getSize().width > 0);
        }
    }

    protected void setScrollYOffset(int scrollYOffset) {
        if (scrollYOffset == this.scrollYOffset) {
            return;
        }
        if (scrollYOffset < 0) {
            scrollYOffset = 0;
        }
        int offset = scrollYOffset - this.scrollYOffset;
        this.scrollYOffset = scrollYOffset;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(0, -offset);
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
    }

    private boolean isOnXScrollPane(int mouseX, int mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x, pos.y + size.height - this.xBarHeight, size.width, this.xBarHeight, mouseX, mouseY);
    }

    private boolean isOnYScrollPane(int mouseX, int mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return DraggableScrollableWidgetGroup.isMouseOver(pos.x + size.width - this.yBarWidth, pos.y, this.yBarWidth, size.height, mouseX, mouseY);
    }

    protected boolean hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.background != null) {
            this.background.draw(x, y, width, height);
        }
        if (this.useScissor) {
            RenderUtil.useScissor(x, y, width - this.yBarWidth, height - this.xBarHeight, () -> {
                if (!this.hookDrawInBackground(mouseX, mouseY, partialTicks, context)) {
                    super.drawInBackground(mouseX, mouseY, partialTicks, context);
                }
            });
        } else if (!this.hookDrawInBackground(mouseX, mouseY, partialTicks, context)) {
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
        }
        if (this.xBarHeight > 0) {
            if (this.xBarB != null) {
                this.xBarB.draw(x, y - this.xBarHeight, width, this.xBarHeight);
            }
            if (this.xBarF != null) {
                int barWidth = (int)((float)width * 1.0f / (float)this.getMaxWidth() * (float)width);
                this.xBarF.draw((float)x + (float)(this.scrollXOffset * width) * 1.0f / (float)this.getMaxWidth(), y + height - this.xBarHeight, barWidth, this.xBarHeight);
            }
        }
        if (this.yBarWidth > 0) {
            if (this.yBarB != null) {
                this.yBarB.draw(x + width - this.yBarWidth, y, this.yBarWidth, height);
            }
            if (this.yBarF != null) {
                int barHeight = (int)((float)height * 1.0f / (float)this.getMaxHeight() * (float)height);
                this.yBarF.draw(x + width - this.yBarWidth, (float)y + (float)(this.scrollYOffset * height) * 1.0f / (float)this.getMaxHeight(), this.yBarWidth, barHeight);
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.xBarHeight > 0 && this.isOnXScrollPane(mouseX, mouseY)) {
            this.draggedOnXScrollBar = true;
            this.focus = true;
            return true;
        }
        if (this.yBarWidth > 0 && this.isOnYScrollPane(mouseX, mouseY)) {
            this.draggedOnYScrollBar = true;
            this.focus = true;
            return true;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.focus = true;
            if (this.checkClickedDragged(mouseX, mouseY, button)) {
                return true;
            }
            if (this.draggable) {
                this.draggedPanel = true;
                return true;
            }
            return false;
        }
        if (this.checkClickedDragged(mouseX, mouseY, button)) {
            return true;
        }
        this.focus = false;
        return false;
    }

    protected boolean checkClickedDragged(int mouseX, int mouseY, int button) {
        this.draggedWidget = null;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible()) continue;
            if (widget.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (!(widget instanceof IDraggable) || !((IDraggable)((Object)widget)).allowDrag(mouseX, mouseY, button)) continue;
            this.draggedWidget = widget;
            ((IDraggable)((Object)widget)).startDrag(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (super.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
                return true;
            }
            int moveDelta = -MathHelper.func_76125_a((int)wheelDelta, (int)-1, (int)1) * ConfigHolder.client.guiConfig.scrollSpeed;
            if (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height) {
                this.setScrollYOffset(MathHelper.func_76125_a((int)(this.scrollYOffset + moveDelta), (int)0, (int)(this.getMaxHeight() - this.getSize().height)));
            }
            return true;
        }
        this.focus = false;
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        int deltaX = mouseX - this.lastMouseX;
        int deltaY = mouseY - this.lastMouseY;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.draggedOnXScrollBar && (this.getMaxWidth() - this.getSize().width > 0 || this.scrollYOffset > this.getMaxWidth() - this.getSize().width)) {
            this.setScrollXOffset(MathHelper.func_76125_a((int)(this.scrollXOffset + deltaX * this.getMaxWidth() / this.getSize().width), (int)0, (int)(this.getMaxWidth() - this.getSize().width)));
            return true;
        }
        if (this.draggedOnYScrollBar && (this.getMaxHeight() - this.getSize().height > 0 || this.scrollYOffset > this.getMaxHeight() - this.getSize().height)) {
            this.setScrollYOffset(MathHelper.func_76125_a((int)(this.scrollYOffset + deltaY * this.getMaxHeight() / this.getSize().height), (int)0, (int)(this.getMaxHeight() - this.getSize().height)));
            return true;
        }
        if (this.draggedWidget != null) {
            if (((IDraggable)((Object)this.draggedWidget)).dragging(mouseX, mouseY, deltaX, deltaY)) {
                this.draggedWidget.addSelfPosition(deltaX, deltaY);
            }
            this.computeMax();
            return true;
        }
        if (this.draggedPanel) {
            this.setScrollXOffset(MathHelper.func_76125_a((int)(this.scrollXOffset - deltaX), (int)0, (int)Math.max(this.getMaxWidth() - this.yBarWidth - this.getSize().width, 0)));
            this.setScrollYOffset(MathHelper.func_76125_a((int)(this.scrollYOffset - deltaY), (int)0, (int)Math.max(this.getMaxHeight() - this.xBarHeight - this.getSize().height, 0)));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.draggedOnXScrollBar) {
            this.draggedOnXScrollBar = false;
        } else if (this.draggedOnYScrollBar) {
            this.draggedOnYScrollBar = false;
        } else if (this.draggedWidget != null) {
            ((IDraggable)((Object)this.draggedWidget)).endDrag(mouseX, mouseY);
            this.draggedWidget = null;
        } else if (this.draggedPanel) {
            this.draggedPanel = false;
        } else {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return true;
    }
}

