/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Color;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.lwjgl.input.Mouse;

public class CircleButtonWidget
extends Widget {
    protected int border;
    protected int hoverTick;
    protected boolean isHover;
    protected String[] hoverText;
    protected IGuiTexture icon;
    protected IGuiTexture hover;
    protected final int iconSize;
    protected Consumer<Widget.ClickData> onPressCallback;
    protected final int[] colors = new int[]{new Color(146, 146, 146).getRGB(), new Color(39, 232, 141).getRGB(), new Color(255, 255, 255).getRGB()};

    public CircleButtonWidget(int x, int y, int r, int border, int iconSize) {
        super(new Position(x - r, y - r), new Size(2 * r, 2 * r));
        this.border = border;
        this.iconSize = iconSize;
    }

    public CircleButtonWidget(int x, int y) {
        this(x, y, 12, 2, 16);
    }

    public CircleButtonWidget setIcon(IGuiTexture icon) {
        this.icon = icon;
        return this;
    }

    public CircleButtonWidget setHoverText(String ... hoverText) {
        this.hoverText = hoverText;
        return this;
    }

    public CircleButtonWidget setColors(int stroke, int strokeAnima, int fill) {
        this.colors[0] = stroke;
        this.colors[1] = strokeAnima;
        this.colors[2] = fill;
        return this;
    }

    public CircleButtonWidget setStroke(int stroke) {
        this.colors[0] = stroke;
        return this;
    }

    public CircleButtonWidget setStrokeAnima(int strokeAnima) {
        this.colors[1] = strokeAnima;
        return this;
    }

    public CircleButtonWidget setFill(int fill) {
        this.colors[2] = fill;
        return this;
    }

    public CircleButtonWidget setClickListener(Consumer<Widget.ClickData> onPressed) {
        this.onPressCallback = onPressed;
        return this;
    }

    public CircleButtonWidget setHoverIcon(IGuiTexture hover) {
        this.hover = hover;
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.isHover) {
            if (this.hoverTick < 8) {
                ++this.hoverTick;
            }
        } else if (this.hoverTick > 0) {
            --this.hoverTick;
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int r = this.getSize().getHeight() / 2;
        int x = this.getPosition().x + r;
        int y = this.getPosition().y + r;
        int segments = 24;
        CircleButtonWidget.drawTorus(x, y, r, r - this.border, this.colors[0], segments, 0, segments);
        this.isHover = this.isMouseOverElement(mouseX, mouseY);
        if (this.isHover || this.hoverTick != 0) {
            CircleButtonWidget.drawTorus(x, y, r, r - this.border, this.colors[1], segments, 0, (int)((float)segments * (((float)this.hoverTick + partialTicks) / 8.0f)));
        }
        CircleButtonWidget.drawCircle(x, y, r - this.border, this.colors[2], segments);
        if (this.isHover && this.hover != null) {
            this.hover.draw((float)x - (float)this.iconSize / 2.0f, (float)y - (float)this.iconSize / 2.0f, this.iconSize, this.iconSize);
        }
        if (this.icon != null) {
            this.icon.draw((float)x - (float)this.iconSize / 2.0f, (float)y - (float)this.iconSize / 2.0f, this.iconSize, this.iconSize);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.hoverText != null && this.hoverText.length > 0 && this.isMouseOverElement(mouseX, mouseY)) {
            this.drawHoveringText(ItemStack.field_190927_a, Arrays.stream(this.hoverText).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).collect(Collectors.toList()), 300, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Widget.ClickData clickData = new Widget.ClickData(Mouse.getEventButton(), this.isShiftDown(), this.isCtrlDown(), false);
            this.writeClientAction(1, clickData::writeToBuf);
            this.playButtonClickSound();
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(new Widget.ClickData(Mouse.getEventButton(), this.isShiftDown(), this.isCtrlDown(), true));
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            Widget.ClickData clickData = Widget.ClickData.readFromBuf(buffer);
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData);
            }
        }
    }
}

