/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.crafttweaker.CTRecipe;
import gregtech.api.recipes.crafttweaker.CTRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.recipes.map.AbstractMapIngredient;
import gregtech.api.recipes.map.Branch;
import gregtech.api.recipes.map.Either;
import gregtech.api.recipes.map.MapFluidIngredient;
import gregtech.api.recipes.map.MapItemStackIngredient;
import gregtech.api.recipes.map.MapItemStackNBTIngredient;
import gregtech.api.recipes.map.MapOreDictIngredient;
import gregtech.api.recipes.map.MapOreDictNBTIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.CTRecipeHelper;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.ValidationResult;
import gregtech.common.ConfigHolder;
import gregtech.integration.GroovyScriptCompat;
import gregtech.integration.VirtualizedRecipeMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.RecipeMap")
@ZenRegister
public class RecipeMap<R extends RecipeBuilder<R>> {
    private static final Map<String, RecipeMap<?>> RECIPE_MAP_REGISTRY = new Object2ReferenceOpenHashMap();
    private static final Comparator<Recipe> RECIPE_DURATION_THEN_EU = Comparator.comparingInt(Recipe::getDuration).thenComparingInt(Recipe::getEUt).thenComparing(Recipe::hashCode);
    public static final IChanceFunction DEFAULT_CHANCE_FUNCTION = (baseChance, boostPerTier, baseTier, machineTier) -> {
        int tierDiff = machineTier - baseTier;
        if (tierDiff <= 0) {
            return baseChance;
        }
        if (baseTier == 0) {
            --tierDiff;
        }
        return baseChance + boostPerTier * tierDiff;
    };
    public IChanceFunction chanceFunction = DEFAULT_CHANCE_FUNCTION;
    public final String unlocalizedName;
    private final R recipeBuilderSample;
    private final int minInputs;
    private final int maxInputs;
    private final int minOutputs;
    private final int maxOutputs;
    private final int minFluidInputs;
    private final int maxFluidInputs;
    private final int minFluidOutputs;
    private final int maxFluidOutputs;
    protected final TByteObjectMap<TextureArea> slotOverlays;
    protected TextureArea specialTexture;
    protected int[] specialTexturePosition;
    protected TextureArea progressBarTexture;
    protected ProgressWidget.MoveType moveType;
    public final boolean isHidden;
    private final VirtualizedRecipeMap virtualizedRecipeMap;
    private final Branch lookup = new Branch();
    private boolean hasOreDictedInputs = false;
    private boolean hasNBTMatcherInputs = false;
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> ingredientRoot = new WeakHashMap();
    private final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> fluidIngredientRoot = new WeakHashMap();
    private Consumer<RecipeBuilder<?>> onRecipeBuildAction;
    protected SoundEvent sound;
    private RecipeMap<?> smallRecipeMap;
    private static boolean foundInvalidRecipe = false;

    public RecipeMap(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, R defaultRecipe, boolean isHidden) {
        this.unlocalizedName = unlocalizedName;
        this.slotOverlays = new TByteObjectHashMap();
        this.progressBarTexture = GuiTextures.PROGRESS_BAR_ARROW;
        this.moveType = ProgressWidget.MoveType.HORIZONTAL;
        this.minInputs = minInputs;
        this.minFluidInputs = minFluidInputs;
        this.minOutputs = minOutputs;
        this.minFluidOutputs = minFluidOutputs;
        this.maxInputs = maxInputs;
        this.maxFluidInputs = maxFluidInputs;
        this.maxOutputs = maxOutputs;
        this.maxFluidOutputs = maxFluidOutputs;
        this.isHidden = isHidden;
        ((RecipeBuilder)defaultRecipe).setRecipeMap(this);
        this.recipeBuilderSample = defaultRecipe;
        RECIPE_MAP_REGISTRY.put(unlocalizedName, this);
        this.virtualizedRecipeMap = GroovyScriptCompat.isLoaded() ? new VirtualizedRecipeMap(this) : null;
    }

    @ZenMethod
    public static List<RecipeMap<?>> getRecipeMaps() {
        return ImmutableList.copyOf(RECIPE_MAP_REGISTRY.values());
    }

    @ZenMethod
    public static RecipeMap<?> getByName(String unlocalizedName) {
        return RECIPE_MAP_REGISTRY.get(unlocalizedName);
    }

    @ZenMethod
    public IChanceFunction getChanceFunction() {
        return this.chanceFunction;
    }

    public static boolean isFoundInvalidRecipe() {
        return foundInvalidRecipe;
    }

    public static void setFoundInvalidRecipe(boolean foundInvalidRecipe) {
        RecipeMap.foundInvalidRecipe |= foundInvalidRecipe;
        OrePrefix currentOrePrefix = OrePrefix.getCurrentProcessingPrefix();
        if (currentOrePrefix != null) {
            Material currentMaterial = OrePrefix.getCurrentMaterial();
            GTLog.logger.error("Error happened during processing ore registration of prefix {} and material {}. Seems like cross-mod compatibility issue. Report to GTCEu github.", (Object)currentOrePrefix, (Object)currentMaterial);
        }
    }

    public RecipeMap<R> setProgressBar(TextureArea progressBar, ProgressWidget.MoveType moveType) {
        this.progressBarTexture = progressBar;
        this.moveType = moveType;
        return this;
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, TextureArea slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, TextureArea slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public RecipeMap<R> setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    @ZenMethod(value="setChanceFunction")
    public RecipeMap<R> setChanceFunction(IChanceFunction function) {
        this.chanceFunction = function;
        return this;
    }

    public RecipeMap<R> onRecipeBuild(Consumer<RecipeBuilder<?>> consumer) {
        this.onRecipeBuildAction = consumer;
        return this;
    }

    public RecipeMap<R> setSmallRecipeMap(RecipeMap<?> recipeMap) {
        this.smallRecipeMap = recipeMap;
        return this;
    }

    public RecipeMap<?> getSmallRecipeMap() {
        return this.smallRecipeMap;
    }

    public void addRecipe(ValidationResult<Recipe> validationResult) {
        validationResult = this.postValidateRecipe(validationResult);
        switch (validationResult.getType()) {
            case SKIP: {
                return;
            }
            case INVALID: {
                RecipeMap.setFoundInvalidRecipe(true);
                return;
            }
        }
        Recipe recipe = validationResult.getResult();
        if (recipe.isGroovyRecipe()) {
            this.virtualizedRecipeMap.addScripted(recipe);
        }
        this.compileRecipe(recipe);
    }

    public void compileRecipe(Recipe recipe) {
        if (recipe == null) {
            return;
        }
        List<List<AbstractMapIngredient>> items = this.fromRecipe(recipe);
        this.recurseIngredientTreeAdd(recipe, items, this.lookup, 0, 0);
    }

    public boolean removeRecipe(Recipe recipe) {
        List<List<AbstractMapIngredient>> items = this.fromRecipe(recipe);
        if (this.recurseIngredientTreeRemove(recipe, items, this.lookup, 0) != null) {
            if (GroovyScriptCompat.isCurrentlyRunning()) {
                this.virtualizedRecipeMap.addBackup(recipe);
            }
            return true;
        }
        return false;
    }

    protected ValidationResult<Recipe> postValidateRecipe(ValidationResult<Recipe> validationResult) {
        EnumValidationResult recipeStatus = validationResult.getType();
        Recipe recipe = validationResult.getResult();
        if (recipe.isGroovyRecipe()) {
            return validationResult;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinInputs(), this.getMaxInputs(), recipe.getInputs().size())) {
            GTLog.logger.error("Invalid amount of recipe inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getInputs().size(), (Object)this.getMinInputs(), (Object)this.getMaxInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe inputs. Actual: %s. Should be between %s and %s inclusive.", recipe.getInputs().size(), this.getMinInputs(), this.getMaxInputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinOutputs(), this.getMaxOutputs(), recipe.getOutputs().size() + recipe.getChancedOutputs().size())) {
            GTLog.logger.error("Invalid amount of recipe outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)(recipe.getOutputs().size() + recipe.getChancedOutputs().size()), (Object)this.getMinOutputs(), (Object)this.getMaxOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe outputs. Actual: %s. Should be between %s and %s inclusive.", recipe.getOutputs().size() + recipe.getChancedOutputs().size(), this.getMinOutputs(), this.getMaxOutputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinFluidInputs(), this.getMaxFluidInputs(), recipe.getFluidInputs().size())) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getFluidInputs().size(), (Object)this.getMinFluidInputs(), (Object)this.getMaxFluidInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Inputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe fluid inputs. Actual: %s. Should be between %s and %s inclusive.", recipe.getFluidInputs().size(), this.getMinFluidInputs(), this.getMaxFluidInputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Inputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinFluidOutputs(), this.getMaxFluidOutputs(), recipe.getFluidOutputs().size())) {
            GTLog.logger.error("Invalid amount of recipe fluid outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getFluidOutputs().size(), (Object)this.getMinFluidOutputs(), (Object)this.getMaxFluidOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Outputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe fluid outputs. Actual: %s. Should be between %s and %s inclusive.", recipe.getFluidOutputs().size(), this.getMinFluidOutputs(), this.getMaxFluidOutputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Outputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        return ValidationResult.newResult(recipeStatus, recipe);
    }

    @Nullable
    public Recipe findRecipe(long voltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs, int outputFluidTankCapacity) {
        return this.findRecipe(voltage, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs), outputFluidTankCapacity);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, int outputFluidTankCapacity) {
        return this.findRecipe(voltage, inputs, fluidInputs, outputFluidTankCapacity, false);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, int outputFluidTankCapacity, boolean exactVoltage) {
        return this.find(inputs.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList()), fluidInputs.stream().filter(Objects::nonNull).collect(Collectors.toList()), recipe -> {
            if (exactVoltage && (long)recipe.getEUt() != voltage) {
                return false;
            }
            return (long)recipe.getEUt() <= voltage && recipe.matches(false, inputs, fluidInputs);
        });
    }

    @Nullable
    public Recipe find(@Nonnull List<ItemStack> items, @Nonnull List<FluidStack> fluids, @Nonnull Predicate<Recipe> canHandle) {
        if (items.size() == Integer.MAX_VALUE || fluids.size() == Integer.MAX_VALUE) {
            return null;
        }
        if (items.size() == 0 && fluids.size() == 0) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList(items.size() + fluids.size());
        if (items.size() > 0) {
            this.buildFromItemStacks((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueItems(items));
        }
        if (fluids.size() > 0) {
            ObjectArrayList stack = new ObjectArrayList(fluids.size());
            for (FluidStack f : fluids) {
                if (f == null || f.amount == 0) continue;
                stack.add(f);
            }
            if (stack.size() > 0) {
                this.buildFromFluidStacks((List<List<AbstractMapIngredient>>)list, (List<FluidStack>)stack);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        return this.recurseIngredientTreeFindRecipe((List<List<AbstractMapIngredient>>)list, this.lookup, canHandle);
    }

    public static ItemStack[] uniqueItems(Collection<ItemStack> inputs) {
        int index = 0;
        ItemStack[] uniqueItems = new ItemStack[inputs.size()];
        block0: for (ItemStack input : inputs) {
            if (input.func_190926_b()) continue;
            if (index > 0) {
                ItemStack unique;
                for (int i = 0; i < uniqueItems.length && (unique = uniqueItems[i]) != null; ++i) {
                    if (input.func_77969_a(unique) && ItemStack.func_77970_a((ItemStack)input, (ItemStack)unique)) continue block0;
                }
            }
            uniqueItems[index++] = input;
        }
        if (index == uniqueItems.length) {
            return uniqueItems;
        }
        ItemStack[] retUniqueItems = new ItemStack[index];
        System.arraycopy(uniqueItems, 0, retUniqueItems, 0, index);
        return retUniqueItems;
    }

    public static List<GTRecipeInput> uniqueIngredientsList(List<GTRecipeInput> input) {
        ObjectArrayList list = new ObjectArrayList(input.size());
        for (GTRecipeInput item : input) {
            boolean isEqual = false;
            for (GTRecipeInput obj : list) {
                if (!item.equalIgnoreAmount(obj)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            if (item instanceof IntCircuitIngredient) {
                list.add(0, item);
                continue;
            }
            list.add(item);
        }
        return list;
    }

    private Recipe recurseIngredientTreeFindRecipe(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchRoot, @Nonnull Predicate<Recipe> canHandle) {
        for (int i = 0; i < ingredients.size(); ++i) {
            Recipe r = this.recurseIngredientTreeFindRecipe(ingredients, branchRoot, canHandle, i, 0, 1L << i);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private Recipe recurseIngredientTreeFindRecipe(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchMap, @Nonnull Predicate<Recipe> canHandle, int index, int count, long skip) {
        if (count == ingredients.size()) {
            return null;
        }
        List<AbstractMapIngredient> wr = ingredients.get(index);
        for (AbstractMapIngredient t : wr) {
            Recipe r;
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = t.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
            Either<Recipe, Branch> result = targetMap.get(t);
            if (result == null || (r = result.map(recipe -> canHandle.test((Recipe)recipe) ? recipe : null, right -> this.diveIngredientTreeFindRecipe(ingredients, (Branch)right, canHandle, index, count, skip))) == null) continue;
            return r;
        }
        return null;
    }

    private Recipe diveIngredientTreeFindRecipe(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch map, Predicate<Recipe> canHandle, int index, int count, long skip) {
        int counter = (index + 1) % ingredients.size();
        while (counter != index) {
            Recipe found;
            if ((skip & 1L << counter) == 0L && (found = this.recurseIngredientTreeFindRecipe(ingredients, map, canHandle, counter, count + 1, skip | 1L << counter)) != null) {
                return found;
            }
            counter = (counter + 1) % ingredients.size();
        }
        return null;
    }

    @Nullable
    public Set<Recipe> findRecipeCollisions(List<ItemStack> items, List<FluidStack> fluids) {
        if (items.size() == Integer.MAX_VALUE || fluids.size() == Integer.MAX_VALUE) {
            return null;
        }
        if (items.size() == 0 && fluids.size() == 0) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList(items.size() + fluids.size());
        if (items.size() > 0) {
            this.buildFromItemStacks((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueItems(items));
        }
        if (fluids.size() > 0) {
            ObjectArrayList stack = new ObjectArrayList(fluids.size());
            for (FluidStack f : fluids) {
                if (f == null || f.amount == 0) continue;
                stack.add(f);
            }
            if (stack.size() > 0) {
                this.buildFromFluidStacks((List<List<AbstractMapIngredient>>)list, (List<FluidStack>)stack);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        HashSet<Recipe> collidingRecipes = new HashSet<Recipe>();
        return this.recurseIngredientTreeFindRecipeCollisions((List<List<AbstractMapIngredient>>)list, this.lookup, collidingRecipes);
    }

    private Set<Recipe> recurseIngredientTreeFindRecipeCollisions(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchRoot, Set<Recipe> collidingRecipes) {
        for (int i = 0; i < ingredients.size(); ++i) {
            this.recurseIngredientTreeFindRecipeCollisions(ingredients, branchRoot, i, 0, 1L << i, collidingRecipes);
        }
        return collidingRecipes;
    }

    private Recipe recurseIngredientTreeFindRecipeCollisions(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchMap, int index, int count, long skip, Set<Recipe> collidingRecipes) {
        if (count == ingredients.size()) {
            return null;
        }
        List<AbstractMapIngredient> wr = ingredients.get(index);
        for (AbstractMapIngredient t : wr) {
            Recipe r;
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = t.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
            Either<Recipe, Branch> result = targetMap.get(t);
            if (result == null || (r = result.map(recipe -> recipe, right -> this.diveIngredientTreeFindRecipeCollisions(ingredients, (Branch)right, index, count, skip, collidingRecipes))) == null) continue;
            collidingRecipes.add(r);
        }
        return null;
    }

    private Recipe diveIngredientTreeFindRecipeCollisions(@Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch map, int index, int count, long skip, Set<Recipe> collidingRecipes) {
        int counter = (index + 1) % ingredients.size();
        while (counter != index) {
            Recipe r;
            if ((skip & 1L << counter) == 0L && (r = this.recurseIngredientTreeFindRecipeCollisions(ingredients, map, counter, count + 1, skip | 1L << counter, collidingRecipes)) != null) {
                return r;
            }
            counter = (counter + 1) % ingredients.size();
        }
        return null;
    }

    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(200, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplateNoOutputs(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block11: {
            int i;
            boolean wasGroup;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks();
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = RecipeMap.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
            int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
            boolean bl = wasGroup = itemHandler.getSlots() + fluidHandler.getTanks() == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidHandler.getTanks() >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemSlotsToLeft && (slotIndex = i2 * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block11;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget(new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            builder.widget(new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base = isFluid ? GuiTextures.FLUID_SLOT : GuiTextures.SLOT;
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    boolean recurseIngredientTreeAdd(@Nonnull Recipe recipe, @Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchMap, int index, int count) {
        if (count >= ingredients.size()) {
            return true;
        }
        if (index >= ingredients.size()) {
            throw new RuntimeException("Index out of bounds for recurseItemTreeAdd, should not happen");
        }
        List<AbstractMapIngredient> current = ingredients.get(index);
        Branch branchRight = new Branch();
        for (AbstractMapIngredient obj : current) {
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = obj.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
            Either r = targetMap.compute(obj, (k, v) -> {
                if (count == ingredients.size() - 1) {
                    if (v != null) {
                        if (v.left().isPresent() && v.left().get() == recipe) {
                            return v;
                        }
                        if (recipe.getIsCTRecipe()) {
                            CraftTweakerAPI.logError((String)String.format("Recipe duplicate or conflict found in RecipeMap %s and was not added. See next lines for details.", this.unlocalizedName));
                            CraftTweakerAPI.logError((String)String.format("Attempted to add Recipe: %s", CTRecipeHelper.getRecipeAddLine(this, recipe)));
                            if (v.left().isPresent()) {
                                CraftTweakerAPI.logError((String)String.format("Which conflicts with: %s", CTRecipeHelper.getRecipeAddLine(this, v.left().get())));
                            } else {
                                CraftTweakerAPI.logError((String)"Could not identify exact duplicate/conflict.");
                            }
                        }
                        if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                            GTLog.logger.warn("Recipe duplicate or conflict found in RecipeMap {} and was not added. See next lines for details", (Object)this.unlocalizedName);
                            GTLog.logger.warn("Attempted to add Recipe: {}", (Object)recipe.toString());
                            if (v.left().isPresent()) {
                                GTLog.logger.warn("Which conflicts with: {}", (Object)v.left().get().toString());
                            } else {
                                GTLog.logger.warn("Could not find exact duplicate/conflict.");
                            }
                        }
                    } else {
                        v = Either.left(recipe);
                    }
                    return v;
                }
                if (v == null) {
                    v = Either.right(branchRight);
                }
                return v;
            });
            if (!r.right().map(m -> !this.recurseIngredientTreeAdd(recipe, ingredients, (Branch)m, (index + 1) % ingredients.size(), count + 1)).orElse(false).booleanValue()) continue;
            current.forEach(i -> {
                Branch branch;
                if (count == ingredients.size() - 1) {
                    targetMap.remove(obj);
                } else if (((Either)targetMap.get(obj)).right().isPresent() && (branch = (Branch)((Either)targetMap.get(obj)).right().get()).isEmptyBranch()) {
                    targetMap.remove(obj);
                }
            });
            return false;
        }
        return true;
    }

    protected void buildFromRecipeFluids(List<List<AbstractMapIngredient>> builder, List<GTRecipeInput> fluidInputs) {
        for (GTRecipeInput fluidInput : fluidInputs) {
            MapFluidIngredient ingredient = new MapFluidIngredient(fluidInput);
            WeakReference<AbstractMapIngredient> cached = this.fluidIngredientRoot.get(ingredient);
            if (cached != null && cached.get() != null) {
                builder.add(Collections.singletonList(cached.get()));
                continue;
            }
            this.fluidIngredientRoot.put(ingredient, new WeakReference<MapFluidIngredient>(ingredient));
            builder.add(Collections.singletonList(ingredient));
        }
    }

    protected void buildFromFluidStacks(List<List<AbstractMapIngredient>> builder, List<FluidStack> ingredients) {
        for (FluidStack t : ingredients) {
            builder.add(Collections.singletonList(new MapFluidIngredient(t)));
        }
    }

    protected List<List<AbstractMapIngredient>> fromRecipe(Recipe r) {
        ObjectArrayList list = new ObjectArrayList(r.getInputs().size() + r.getFluidInputs().size());
        if (r.getInputs().size() > 0) {
            this.buildFromRecipeItems((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueIngredientsList(r.getInputs()));
        }
        if (r.getFluidInputs().size() > 0) {
            this.buildFromRecipeFluids((List<List<AbstractMapIngredient>>)list, r.getFluidInputs());
        }
        return list;
    }

    protected void buildFromRecipeItems(List<List<AbstractMapIngredient>> list, List<GTRecipeInput> ingredients) {
        for (GTRecipeInput r : ingredients) {
            if (r.isOreDict()) {
                MapOreDictIngredient ingredient;
                this.hasOreDictedInputs = true;
                if (r.hasNBTMatchingCondition()) {
                    this.hasNBTMatcherInputs = true;
                    ingredient = new MapOreDictNBTIngredient(r.getOreDict(), r.getNBTMatcher(), r.getNBTMatchingCondition());
                } else {
                    ingredient = new MapOreDictIngredient(r.getOreDict());
                }
                WeakReference<AbstractMapIngredient> cached = ingredientRoot.get(ingredient);
                if (cached != null && cached.get() != null) {
                    list.add(Collections.singletonList(cached.get()));
                    continue;
                }
                ingredientRoot.put(ingredient, new WeakReference<MapOreDictIngredient>(ingredient));
                list.add(Collections.singletonList(ingredient));
                continue;
            }
            ObjectArrayList inner = new ObjectArrayList(1);
            if (r.hasNBTMatchingCondition()) {
                inner.addAll(MapItemStackNBTIngredient.from(r));
                this.hasNBTMatcherInputs = true;
            } else {
                inner.addAll(MapItemStackIngredient.from(r));
            }
            for (int i = 0; i < inner.size(); ++i) {
                AbstractMapIngredient mappedIngredient = (AbstractMapIngredient)inner.get(i);
                WeakReference<AbstractMapIngredient> cached = ingredientRoot.get(mappedIngredient);
                if (cached != null && cached.get() != null) {
                    inner.set(i, cached.get());
                    continue;
                }
                ingredientRoot.put(mappedIngredient, new WeakReference<AbstractMapIngredient>(mappedIngredient));
            }
            list.add((List<AbstractMapIngredient>)inner);
        }
    }

    protected void buildFromItemStacks(List<List<AbstractMapIngredient>> list, ItemStack[] ingredients) {
        for (ItemStack stack : ingredients) {
            int meta = stack.func_77960_j();
            NBTTagCompound nbt = stack.func_77978_p();
            ObjectArrayList ls = new ObjectArrayList(1);
            ls.add(new MapItemStackIngredient(stack, meta, nbt));
            if (this.hasOreDictedInputs) {
                for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                    MapOreDictIngredient ingredient = new MapOreDictIngredient(i);
                    ls.add(ingredient);
                    if (!this.hasNBTMatcherInputs) continue;
                    ingredient = new MapOreDictNBTIngredient(i, nbt);
                    ls.add(ingredient);
                }
            }
            if (this.hasNBTMatcherInputs) {
                ls.add(new MapItemStackNBTIngredient(stack, meta, nbt));
            }
            if (ls.size() <= 0) continue;
            list.add((List<AbstractMapIngredient>)ls);
        }
    }

    protected RecipeMap<R> setSpecialTexture(int x, int y, int width, int height, TextureArea area) {
        this.specialTexturePosition = new int[]{x, y, width, height};
        this.specialTexture = area;
        return this;
    }

    protected ModularUI.Builder addSpecialTexture(ModularUI.Builder builder) {
        builder.image(this.specialTexturePosition[0], this.specialTexturePosition[1], this.specialTexturePosition[2], this.specialTexturePosition[3], this.specialTexture);
        return builder;
    }

    public Collection<Recipe> getRecipeList() {
        ObjectOpenHashSet recipes = new ObjectOpenHashSet();
        return this.lookup.getRecipes(true).filter(arg_0 -> ((ObjectOpenHashSet)recipes).add(arg_0)).sorted(RECIPE_DURATION_THEN_EU).collect(Collectors.toList());
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    @ZenMethod(value="findRecipe")
    @Optional.Method(modid="crafttweaker")
    @Nullable
    public CTRecipe ctFindRecipe(long maxVoltage, IItemStack[] itemInputs, ILiquidStack[] fluidInputs, @Optional(valueLong=0x7FFFFFFFL) int outputFluidTankCapacity) {
        List<ItemStack> mcItemInputs = itemInputs == null ? Collections.emptyList() : Arrays.stream(itemInputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        List<FluidStack> mcFluidInputs = fluidInputs == null ? Collections.emptyList() : Arrays.stream(fluidInputs).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
        Recipe backingRecipe = this.findRecipe(maxVoltage, mcItemInputs, mcFluidInputs, outputFluidTankCapacity, true);
        return backingRecipe == null ? null : new CTRecipe(this, backingRecipe);
    }

    @ZenGetter(value="recipes")
    @Optional.Method(modid="crafttweaker")
    public List<CTRecipe> ccGetRecipeList() {
        return this.getRecipeList().stream().map(recipe -> new CTRecipe(this, (Recipe)recipe)).collect(Collectors.toList());
    }

    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return LocalizationUtils.format("recipemap." + this.unlocalizedName + ".name", new Object[0]);
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public R recipeBuilder() {
        return ((RecipeBuilder)((RecipeBuilder)this.recipeBuilderSample).copy()).onBuild(this.onRecipeBuildAction);
    }

    private Recipe recurseIngredientTreeRemove(@Nonnull Recipe recipeToRemove, @Nonnull List<List<AbstractMapIngredient>> ingredients, @Nonnull Branch branchMap, int depth) {
        for (List<AbstractMapIngredient> current : ingredients) {
            for (AbstractMapIngredient obj : current) {
                Branch branch;
                Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = obj.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
                if (ingredients.size() == 0) {
                    return null;
                }
                Recipe r = this.removeDive(recipeToRemove, ingredients.subList(1, ingredients.size()), targetMap, obj, depth);
                if (r == null) continue;
                if (ingredients.size() == 1) {
                    targetMap.remove(obj);
                } else if (targetMap.get(obj).right().isPresent() && (branch = targetMap.get(obj).right().get()).isEmptyBranch()) {
                    targetMap.remove(obj);
                }
                return r;
            }
        }
        return null;
    }

    private Recipe removeDive(Recipe recipeToRemove, @Nonnull List<List<AbstractMapIngredient>> ingredients, Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap, AbstractMapIngredient obj, int depth) {
        Recipe r;
        Either<Recipe, Branch> result = targetMap.get(obj);
        if (result != null && (r = result.map(recipe -> recipe, right -> this.recurseIngredientTreeRemove(recipeToRemove, ingredients, (Branch)right, depth + 1))) == recipeToRemove) {
            return r;
        }
        return null;
    }

    @ZenMethod(value="recipeBuilder")
    @Optional.Method(modid="crafttweaker")
    public CTRecipeBuilder ctRecipeBuilder() {
        return new CTRecipeBuilder((RecipeBuilder<?>)this.recipeBuilder());
    }

    @ZenGetter(value="minInputs")
    public int getMinInputs() {
        return this.minInputs;
    }

    @ZenGetter(value="maxInputs")
    public int getMaxInputs() {
        return this.maxInputs;
    }

    @ZenGetter(value="minOutputs")
    public int getMinOutputs() {
        return this.minOutputs;
    }

    @ZenGetter(value="maxOutputs")
    public int getMaxOutputs() {
        return this.maxOutputs;
    }

    @ZenGetter(value="minFluidInputs")
    public int getMinFluidInputs() {
        return this.minFluidInputs;
    }

    @ZenGetter(value="maxFluidInputs")
    public int getMaxFluidInputs() {
        return this.maxFluidInputs;
    }

    @ZenGetter(value="minFluidOutputs")
    public int getMinFluidOutputs() {
        return this.minFluidOutputs;
    }

    @ZenGetter(value="maxFluidOutputs")
    public int getMaxFluidOutputs() {
        return this.maxFluidOutputs;
    }

    @ZenMethod
    public String toString() {
        return "RecipeMap{unlocalizedName='" + this.unlocalizedName + '\'' + '}';
    }

    @FunctionalInterface
    @ZenClass(value="mods.gregtech.recipe.IChanceFunction")
    @ZenRegister
    public static interface IChanceFunction {
        public int chanceFor(int var1, int var2, int var3, int var4);
    }
}

