/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.helper.ingredient.OreDictIngredient;
import crafttweaker.CraftTweakerAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.recipeproperties.CleanroomProperty;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.RecipePropertyStorage;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import gregtech.common.ConfigHolder;
import gregtech.integration.GroovyScriptCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RecipeBuilder<R extends RecipeBuilder<R>> {
    protected RecipeMap<R> recipeMap;
    protected final List<GTRecipeInput> inputs;
    protected final List<ItemStack> outputs;
    protected final List<Recipe.ChanceEntry> chancedOutputs;
    protected final List<GTRecipeInput> fluidInputs;
    protected final List<FluidStack> fluidOutputs;
    protected int duration;
    protected int EUt;
    protected boolean hidden = false;
    protected boolean isCTRecipe = false;
    protected int parallel = 0;
    protected Consumer<RecipeBuilder<?>> onBuildAction = null;
    protected EnumValidationResult recipeStatus = EnumValidationResult.VALID;
    protected IRecipePropertyStorage recipePropertyStorage = null;
    protected boolean recipePropertyStorageErrored = false;

    protected RecipeBuilder() {
        this.inputs = NonNullList.func_191196_a();
        this.outputs = NonNullList.func_191196_a();
        this.chancedOutputs = new ArrayList<Recipe.ChanceEntry>();
        this.fluidInputs = new ArrayList<GTRecipeInput>();
        this.fluidOutputs = new ArrayList<FluidStack>();
    }

    public RecipeBuilder(Recipe recipe, RecipeMap<R> recipeMap) {
        this.recipeMap = recipeMap;
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(recipe.getInputs());
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(recipe.getOutputs()));
        this.chancedOutputs = new ArrayList<Recipe.ChanceEntry>(recipe.getChancedOutputs());
        this.fluidInputs = new ArrayList<GTRecipeInput>(recipe.getFluidInputs());
        this.fluidOutputs = GTUtility.copyFluidList(recipe.getFluidOutputs());
        this.duration = recipe.getDuration();
        this.EUt = recipe.getEUt();
        this.hidden = recipe.isHidden();
        this.recipePropertyStorage = recipe.getRecipePropertyStorage().copy();
        if (this.recipePropertyStorage != null) {
            this.recipePropertyStorage.freeze(false);
        }
    }

    protected RecipeBuilder(RecipeBuilder<R> recipeBuilder) {
        this.recipeMap = recipeBuilder.recipeMap;
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(recipeBuilder.getInputs());
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(recipeBuilder.getOutputs()));
        this.chancedOutputs = new ArrayList<Recipe.ChanceEntry>(recipeBuilder.chancedOutputs);
        this.fluidInputs = new ArrayList<GTRecipeInput>(recipeBuilder.getFluidInputs());
        this.fluidOutputs = GTUtility.copyFluidList(recipeBuilder.getFluidOutputs());
        this.duration = recipeBuilder.duration;
        this.EUt = recipeBuilder.EUt;
        this.hidden = recipeBuilder.hidden;
        this.onBuildAction = recipeBuilder.onBuildAction;
        this.recipePropertyStorage = recipeBuilder.recipePropertyStorage;
        if (this.recipePropertyStorage != null) {
            this.recipePropertyStorage = this.recipePropertyStorage.copy();
        }
    }

    public R cleanroom(@Nullable CleanroomType cleanroom) {
        if (!ConfigHolder.machines.enableCleanroom) {
            return (R)this;
        }
        this.applyProperty(CleanroomProperty.getInstance(), (Object)cleanroom);
        return (R)this;
    }

    public boolean applyProperty(@Nonnull String key, @Nullable Object value) {
        if (key.equals("cleanroom")) {
            if (value instanceof CleanroomType) {
                this.cleanroom((CleanroomType)value);
            } else if (value instanceof String) {
                this.cleanroom(CleanroomType.getByName((String)value));
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean applyProperty(@Nonnull RecipeProperty<?> property, @Nullable Object value) {
        if (value == null) {
            if (this.recipePropertyStorage != null) {
                return this.recipePropertyStorage.remove(property);
            }
        } else {
            boolean stored;
            if (this.recipePropertyStorage == null) {
                this.recipePropertyStorage = new RecipePropertyStorage();
            }
            if (!(stored = this.recipePropertyStorage.store(property, value))) {
                this.recipePropertyStorageErrored = true;
            }
            return stored;
        }
        return true;
    }

    public R input(GTRecipeInput input) {
        if (input.getAmount() < 0) {
            GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)input.getAmount());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
        } else {
            this.inputs.add(input);
        }
        return (R)this;
    }

    public R input(String oredict) {
        return this.input(GTRecipeOreInput.getOrCreate(oredict, 1));
    }

    public R input(String oredict, int count) {
        return this.input(GTRecipeOreInput.getOrCreate(oredict, count));
    }

    public R input(OrePrefix orePrefix, Material material) {
        return this.input(GTRecipeOreInput.getOrCreate(orePrefix, material, 1));
    }

    public R input(OrePrefix orePrefix, Material material, int count) {
        return this.input(GTRecipeOreInput.getOrCreate(orePrefix, material, count));
    }

    public R input(Item item) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(item)));
    }

    public R input(Item item, int count) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(item), count));
    }

    public R input(Item item, int count, int meta) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(item, count, meta)));
    }

    public R input(Item item, int count, boolean wild) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(item, count, Short.MAX_VALUE)));
    }

    public R input(Block block) {
        return this.input(block, 1);
    }

    public R input(Block block, int count) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(block, count)));
    }

    public R input(Block block, int count, boolean wild) {
        return this.input(GTRecipeItemInput.getOrCreate(new ItemStack(block, count, Short.MAX_VALUE)));
    }

    public R input(MetaItem.MetaValueItem item, int count) {
        return this.input(GTRecipeItemInput.getOrCreate(item.getStackForm(count)));
    }

    public R input(MetaItem.MetaValueItem item) {
        return this.input(GTRecipeItemInput.getOrCreate(item.getStackForm()));
    }

    public R input(MetaTileEntity mte) {
        return this.input(GTRecipeItemInput.getOrCreate(mte.getStackForm()));
    }

    public R input(MetaTileEntity mte, int amount) {
        return this.input(GTRecipeItemInput.getOrCreate(mte.getStackForm(amount)));
    }

    public R inputNBT(GTRecipeInput input, NBTMatcher matcher, NBTCondition condition) {
        if (input.getAmount() < 0) {
            GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)input.getAmount());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            return (R)this;
        }
        if (matcher == null) {
            GTLog.logger.error("NBTMatcher must not be null");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            return (R)this;
        }
        if (condition == null) {
            GTLog.logger.error("NBTCondition must not be null");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            return (R)this;
        }
        this.inputs.add(input.setNBTMatchingCondition(matcher, condition));
        return (R)this;
    }

    public R inputNBT(String oredict, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeOreInput.getOrCreate(oredict, 1), matcher, condition);
    }

    public R inputNBT(String oredict, int count, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeOreInput.getOrCreate(oredict, count), matcher, condition);
    }

    public R inputNBT(OrePrefix orePrefix, Material material, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeOreInput.getOrCreate(orePrefix, material, 1), matcher, condition);
    }

    public R inputNBT(OrePrefix orePrefix, Material material, int count, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeOreInput.getOrCreate(orePrefix, material, count), matcher, condition);
    }

    public R inputNBT(Item item, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(item)), matcher, condition);
    }

    public R inputNBT(Item item, int count, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(item), count), matcher, condition);
    }

    public R inputNBT(Item item, int count, int meta, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(item, count, meta)), matcher, condition);
    }

    public R inputNBT(Item item, int count, boolean wild, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(item, count, Short.MAX_VALUE)), matcher, condition);
    }

    public R inputNBT(Block block, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(block, 1, matcher, condition);
    }

    public R inputNBT(Block block, int count, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(block, count)), matcher, condition);
    }

    public R inputNBT(Block block, int count, boolean wild, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(new ItemStack(block, count, Short.MAX_VALUE)), matcher, condition);
    }

    public R inputNBT(MetaItem.MetaValueItem item, int count, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(item.getStackForm(count)), matcher, condition);
    }

    public R inputNBT(MetaItem.MetaValueItem item, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(item.getStackForm()), matcher, condition);
    }

    public R inputNBT(MetaTileEntity mte, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(mte.getStackForm()), matcher, condition);
    }

    public R inputNBT(MetaTileEntity mte, int amount, NBTMatcher matcher, NBTCondition condition) {
        return this.inputNBT(GTRecipeItemInput.getOrCreate(mte.getStackForm(amount)), matcher, condition);
    }

    public R inputs(ItemStack ... inputs) {
        for (ItemStack input : inputs) {
            if (input == null || input.func_190926_b()) {
                GTLog.logger.error("Input cannot contain null or empty ItemStacks. Inputs: {}", (Object)input);
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                this.recipeStatus = EnumValidationResult.INVALID;
                continue;
            }
            this.inputs.add(GTRecipeItemInput.getOrCreate(input));
        }
        return (R)this;
    }

    public R inputStacks(Collection<ItemStack> inputs) {
        for (ItemStack input : inputs) {
            if (input == null || input.func_190926_b()) {
                GTLog.logger.error("Input cannot contain null or empty ItemStacks. Inputs: {}", (Object)input);
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                this.recipeStatus = EnumValidationResult.INVALID;
                continue;
            }
            this.inputs.add(GTRecipeItemInput.getOrCreate(input));
        }
        return (R)this;
    }

    public R inputs(GTRecipeInput ... inputs) {
        for (GTRecipeInput input : inputs) {
            if (input.getAmount() < 0) {
                GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)input.getAmount());
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                this.recipeStatus = EnumValidationResult.INVALID;
                continue;
            }
            this.inputs.add(input);
        }
        return (R)this;
    }

    public R inputIngredients(Collection<GTRecipeInput> inputs) {
        for (GTRecipeInput input : inputs) {
            if (input.getAmount() < 0) {
                GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)input.getAmount());
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                this.recipeStatus = EnumValidationResult.INVALID;
                continue;
            }
            this.inputs.add(input);
        }
        return (R)this;
    }

    public R clearInputs() {
        this.inputs.clear();
        return (R)this;
    }

    public R notConsumable(GTRecipeInput gtRecipeIngredient) {
        return this.inputs(GTRecipeInput.getOrCreate(gtRecipeIngredient).setNonConsumable());
    }

    public R notConsumable(ItemStack itemStack) {
        return this.inputs(GTRecipeItemInput.getOrCreate(itemStack, itemStack.func_190916_E()).setNonConsumable());
    }

    public R notConsumable(OrePrefix prefix, Material material, int amount) {
        return this.inputs(GTRecipeOreInput.getOrCreate(prefix, material, amount).setNonConsumable());
    }

    public R notConsumable(OrePrefix prefix, Material material) {
        return this.notConsumable(prefix, material, 1);
    }

    public R notConsumable(MetaItem.MetaValueItem item) {
        return this.inputs(GTRecipeItemInput.getOrCreate(item.getStackForm(), 1).setNonConsumable());
    }

    public R notConsumable(Fluid fluid, int amount) {
        return this.fluidInputs(GTRecipeFluidInput.getOrCreate(fluid, amount).setNonConsumable());
    }

    public R notConsumable(Fluid fluid) {
        return this.fluidInputs(GTRecipeFluidInput.getOrCreate(fluid, 1).setNonConsumable());
    }

    public R notConsumable(FluidStack fluidStack) {
        return this.fluidInputs(GTRecipeFluidInput.getOrCreate(fluidStack, fluidStack.amount).setNonConsumable());
    }

    public R output(OrePrefix orePrefix, Material material) {
        return this.outputs(OreDictUnifier.get(orePrefix, material, 1));
    }

    public R output(OrePrefix orePrefix, Material material, int count) {
        return this.outputs(OreDictUnifier.get(orePrefix, material, count));
    }

    public R output(Item item) {
        return this.output(item, 1);
    }

    public R output(Item item, int count) {
        return this.outputs(new ItemStack(item, count));
    }

    public R output(Item item, int count, int meta) {
        return this.outputs(new ItemStack(item, count, meta));
    }

    public R output(Block item) {
        return this.output(item, 1);
    }

    public R output(Block item, int count) {
        return this.outputs(new ItemStack(item, count));
    }

    public R output(MetaItem.MetaValueItem item, int count) {
        return this.outputs(item.getStackForm(count));
    }

    public R output(MetaItem.MetaValueItem item) {
        return this.output(item, 1);
    }

    public R output(MetaTileEntity mte) {
        return this.output(mte, 1);
    }

    public R output(MetaTileEntity mte, int amount) {
        return this.outputs(mte.getStackForm(amount));
    }

    public R outputs(ItemStack ... outputs) {
        return this.outputs(Arrays.asList(outputs));
    }

    public R outputs(Collection<ItemStack> outputs) {
        outputs = new ArrayList<ItemStack>(outputs);
        outputs.removeIf(stack -> stack == null || stack.func_190926_b());
        this.outputs.addAll(outputs);
        return (R)this;
    }

    public R clearOutputs() {
        this.outputs.clear();
        return (R)this;
    }

    public R fluidInputs(Collection<GTRecipeInput> fluidIngredients) {
        this.fluidInputs.addAll(fluidIngredients);
        return (R)this;
    }

    public R fluidInputs(GTRecipeInput fluidIngredient) {
        this.fluidInputs.add(fluidIngredient);
        return (R)this;
    }

    public R fluidInputs(FluidStack ... fluidStacks) {
        ArrayList<GTRecipeInput> fluidIngredients = new ArrayList<GTRecipeInput>();
        for (FluidStack fluidStack : fluidStacks) {
            if (fluidStack != null && fluidStack.amount > 0) {
                fluidIngredients.add(GTRecipeFluidInput.getOrCreate(fluidStack, fluidStack.amount));
                continue;
            }
            if (fluidStack != null) {
                GTLog.logger.error("Count cannot be less than 0. Actual: {}.", (Object)fluidStack.amount);
                GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
                continue;
            }
            GTLog.logger.error("FluidStack cannot be null.");
        }
        this.fluidInputs.addAll(fluidIngredients);
        return (R)this;
    }

    public R clearFluidInputs() {
        this.fluidInputs.clear();
        return (R)this;
    }

    public R fluidOutputs(FluidStack ... outputs) {
        return this.fluidOutputs(Arrays.asList(outputs));
    }

    public R fluidOutputs(Collection<FluidStack> outputs) {
        outputs = new ArrayList<FluidStack>(outputs);
        outputs.removeIf(Objects::isNull);
        this.fluidOutputs.addAll(outputs);
        return (R)this;
    }

    public R clearFluidOutputs() {
        this.fluidOutputs.clear();
        return (R)this;
    }

    public R chancedOutput(ItemStack stack, int chance, int tierChanceBoost) {
        if (stack == null || stack.func_190926_b()) {
            return (R)this;
        }
        if (0 >= chance || chance > Recipe.getMaxChancedValue()) {
            GTLog.logger.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", (Object)Recipe.getMaxChancedValue(), (Object)chance);
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
            return (R)this;
        }
        this.chancedOutputs.add(new Recipe.ChanceEntry(stack.func_77946_l(), chance, tierChanceBoost));
        return (R)this;
    }

    public R chancedOutput(OrePrefix prefix, Material material, int count, int chance, int tierChanceBoost) {
        return this.chancedOutput(OreDictUnifier.get(prefix, material, count), chance, tierChanceBoost);
    }

    public R chancedOutput(OrePrefix prefix, Material material, int chance, int tierChanceBoost) {
        return this.chancedOutput(prefix, material, 1, chance, tierChanceBoost);
    }

    public R chancedOutput(MetaItem.MetaValueItem item, int count, int chance, int tierChanceBoost) {
        return this.chancedOutput(item.getStackForm(count), chance, tierChanceBoost);
    }

    public R chancedOutput(MetaItem.MetaValueItem item, int chance, int tierChanceBoost) {
        return this.chancedOutput(item, 1, chance, tierChanceBoost);
    }

    public R chancedOutputs(List<Recipe.ChanceEntry> chancedOutputs) {
        chancedOutputs.stream().map(Recipe.ChanceEntry::copy).forEach(this.chancedOutputs::add);
        return (R)this;
    }

    public R clearChancedOutput() {
        this.chancedOutputs.clear();
        return (R)this;
    }

    @Optional.Method(modid="groovyscript")
    public R inputs(IIngredient ingredient) {
        return this.input(RecipeBuilder.ofGroovyIngredient(ingredient));
    }

    @Optional.Method(modid="groovyscript")
    public R inputs(IIngredient ... ingredients) {
        for (IIngredient ingredient : ingredients) {
            this.inputs(ingredient);
        }
        return (R)this;
    }

    @Optional.Method(modid="groovyscript")
    public R inputs(Collection<IIngredient> ingredients) {
        for (IIngredient ingredient : ingredients) {
            this.inputs(ingredient);
        }
        return (R)this;
    }

    @Optional.Method(modid="groovyscript")
    public R notConsumable(IIngredient ingredient) {
        return this.notConsumable(RecipeBuilder.ofGroovyIngredient(ingredient));
    }

    @Optional.Method(modid="groovyscript")
    private static GTRecipeInput ofGroovyIngredient(IIngredient ingredient) {
        if (ingredient instanceof OreDictIngredient) {
            return GTRecipeOreInput.getOrCreate(((OreDictIngredient)ingredient).getOreDict(), ingredient.getAmount());
        }
        IIngredient oIngredient = ingredient;
        if (oIngredient instanceof ItemStack) {
            return GTRecipeItemInput.getOrCreate((ItemStack)oIngredient);
        }
        if (ingredient instanceof FluidStack) {
            return GTRecipeFluidInput.getOrCreate((FluidStack)ingredient, ingredient.getAmount());
        }
        throw new IllegalArgumentException("Could not add groovy ingredient " + ingredient + " to recipe!");
    }

    public void chancedOutputsMultiply(Recipe chancedOutputsFrom, int numberOfOperations) {
        for (Recipe.ChanceEntry entry : chancedOutputsFrom.getChancedOutputs()) {
            int chance = entry.getChance();
            int boost = entry.getBoostPerTier();
            IntStream.range(0, numberOfOperations).forEach(value -> this.chancedOutput(entry.getItemStack(), chance, boost));
        }
    }

    public R append(Recipe recipe, int multiplier, boolean multiplyDuration) {
        for (Map.Entry<RecipeProperty<?>, Object> property : recipe.getPropertyValues()) {
            this.applyProperty(property.getKey().getKey(), property.getValue());
        }
        ArrayList<GTRecipeInput> newRecipeInputs = new ArrayList<GTRecipeInput>();
        ArrayList<GTRecipeInput> newFluidInputs = new ArrayList<GTRecipeInput>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        RecipeBuilder.multiplyInputsAndOutputs(newRecipeInputs, newFluidInputs, outputItems, outputFluids, recipe, multiplier);
        this.inputIngredients(newRecipeInputs);
        this.fluidInputs(newFluidInputs);
        this.outputs(outputItems);
        this.chancedOutputsMultiply(recipe, multiplier);
        this.fluidOutputs(outputFluids);
        this.EUt(multiplyDuration ? recipe.getEUt() : this.EUt + recipe.getEUt() * multiplier);
        this.duration(multiplyDuration ? this.duration + recipe.getDuration() * multiplier : recipe.getDuration());
        this.parallel += multiplier;
        return (R)this;
    }

    protected static void multiplyInputsAndOutputs(List<GTRecipeInput> newRecipeInputs, List<GTRecipeInput> newFluidInputs, List<ItemStack> outputItems, List<FluidStack> outputFluids, Recipe recipe, int numberOfOperations) {
        recipe.getInputs().forEach(ri -> {
            if (ri.isNonConsumable()) {
                newRecipeInputs.add((GTRecipeInput)ri);
            } else {
                newRecipeInputs.add(ri.copyWithAmount(ri.getAmount() * numberOfOperations));
            }
        });
        recipe.getFluidInputs().forEach(fi -> {
            if (fi.isNonConsumable()) {
                newFluidInputs.add((GTRecipeInput)fi);
            } else {
                newFluidInputs.add(fi.copyWithAmount(fi.getAmount() * numberOfOperations));
            }
        });
        recipe.getOutputs().forEach(itemStack -> outputItems.add(RecipeBuilder.copyItemStackWithCount(itemStack, itemStack.func_190916_E() * numberOfOperations)));
        recipe.getFluidOutputs().forEach(fluidStack -> outputFluids.add(RecipeBuilder.copyFluidStackWithAmount(fluidStack, fluidStack.amount * numberOfOperations)));
    }

    public int getParallel() {
        return this.parallel;
    }

    protected static ItemStack copyItemStackWithCount(ItemStack itemStack, int count) {
        ItemStack itemCopy = itemStack.func_77946_l();
        itemCopy.func_190920_e(count);
        return itemCopy;
    }

    protected static FluidStack copyFluidStackWithAmount(FluidStack fluidStack, int count) {
        FluidStack fluidCopy = fluidStack.copy();
        fluidCopy.amount = count;
        return fluidCopy;
    }

    public R duration(int duration) {
        this.duration = duration;
        return (R)this;
    }

    public R EUt(int EUt) {
        this.EUt = EUt;
        return (R)this;
    }

    public R hidden() {
        this.hidden = true;
        return (R)this;
    }

    public R isCTRecipe() {
        this.isCTRecipe = true;
        return (R)this;
    }

    public R setRecipeMap(RecipeMap<R> recipeMap) {
        this.recipeMap = recipeMap;
        return (R)this;
    }

    public R copy() {
        return (R)new RecipeBuilder<R>(this);
    }

    protected EnumValidationResult finalizeAndValidate() {
        return this.recipePropertyStorageErrored ? EnumValidationResult.INVALID : this.validate();
    }

    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage));
    }

    protected EnumValidationResult validate() {
        if (GroovyScriptCompat.isCurrentlyRunning()) {
            GroovyLog.Msg msg = GroovyLog.msg((String)("Error adding GregTech " + this.recipeMap.unlocalizedName + " recipe"), (Object[])new Object[0]).error();
            this.validateGroovy(msg);
            return msg.postIfNotEmpty() ? EnumValidationResult.SKIP : EnumValidationResult.VALID;
        }
        if (this.EUt == 0) {
            GTLog.logger.error("EU/t cannot be equal to 0", (Throwable)new IllegalArgumentException());
            if (this.isCTRecipe) {
                CraftTweakerAPI.logError((String)"EU/t cannot be equal to 0", (Throwable)new IllegalArgumentException());
            }
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.duration <= 0) {
            GTLog.logger.error("Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            if (this.isCTRecipe) {
                CraftTweakerAPI.logError((String)"Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            }
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.recipeStatus == EnumValidationResult.INVALID) {
            GTLog.logger.error("Invalid recipe, read the errors above: {}", (Object)this);
        }
        if (this.recipePropertyStorage != null) {
            this.recipePropertyStorage.freeze(true);
        }
        return this.recipeStatus;
    }

    @Optional.Method(modid="groovyscript")
    protected void validateGroovy(GroovyLog.Msg errorMsg) {
        errorMsg.add(this.EUt == 0, () -> "EU/t must not be to 0");
        errorMsg.add(this.duration <= 0, () -> "Duration must not be less or equal to 0");
        int minInput = this.recipeMap.getMinInputs();
        int maxInput = this.recipeMap.getMaxInputs();
        int minOutput = this.recipeMap.getMinOutputs();
        int maxOutput = this.recipeMap.getMaxOutputs();
        int minFluidInput = this.recipeMap.getMinFluidInputs();
        int maxFluidInput = this.recipeMap.getMaxFluidInputs();
        int minFluidOutput = this.recipeMap.getMinFluidOutputs();
        int maxFluidOutput = this.recipeMap.getMaxFluidOutputs();
        errorMsg.add(this.inputs.size() < minInput || this.inputs.size() > maxInput, () -> RecipeBuilder.getRequiredString(minInput, maxInput, " item input") + ", but found " + this.inputs.size());
        errorMsg.add(this.outputs.size() < minOutput || this.outputs.size() > maxOutput, () -> RecipeBuilder.getRequiredString(minOutput, maxOutput, "item output") + ", but found " + this.outputs.size());
        errorMsg.add(this.fluidInputs.size() < minFluidInput || this.fluidInputs.size() > maxFluidInput, () -> RecipeBuilder.getRequiredString(minFluidInput, maxFluidInput, "fluid input") + ", but found " + this.fluidInputs.size());
        errorMsg.add(this.fluidOutputs.size() < minFluidOutput || this.fluidOutputs.size() > maxFluidOutput, () -> RecipeBuilder.getRequiredString(minFluidOutput, maxFluidOutput, "fluid output") + ", but found " + this.fluidOutputs.size());
    }

    protected static String getRequiredString(int min, int max, String type) {
        if (max <= 0) {
            return "No " + type + "s allowed";
        }
        String out = "Must have ";
        out = min == max ? out + "exactly " + min + " " + type : out + min + " - " + max + " " + type;
        if (max != 1) {
            out = out + "s";
        }
        return out;
    }

    protected R onBuild(Consumer<RecipeBuilder<?>> consumer) {
        this.onBuildAction = consumer;
        return (R)this;
    }

    protected R invalidateOnBuildAction() {
        this.onBuildAction = null;
        return (R)this;
    }

    public void buildAndRegister() {
        if (this.onBuildAction != null) {
            this.onBuildAction.accept(this);
        }
        ValidationResult<Recipe> validationResult = this.build();
        this.recipeMap.addRecipe(validationResult);
    }

    public List<GTRecipeInput> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<Recipe.ChanceEntry> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<ItemStack> getAllItemOutputs() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.getOutputs());
        for (int i = 0; i < this.chancedOutputs.size(); ++i) {
            Recipe.ChanceEntry entry = this.chancedOutputs.get(i);
            stacks.add(entry.getItemStack());
        }
        return stacks;
    }

    public List<GTRecipeInput> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getEUt() {
        return this.EUt;
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public CleanroomType getCleanroom() {
        return this.recipePropertyStorage == null ? null : (CleanroomType)this.recipePropertyStorage.getRecipePropertyValue(CleanroomProperty.getInstance(), null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("recipeMap", this.recipeMap).append("inputs", this.inputs).append("outputs", this.outputs).append("chancedOutputs", this.chancedOutputs).append("fluidInputs", this.fluidInputs).append("fluidOutputs", this.fluidOutputs).append("duration", this.duration).append("EUt", this.EUt).append("hidden", this.hidden).append("cleanroom", (Object)this.getCleanroom()).append("recipeStatus", (Object)this.recipeStatus).toString();
    }
}

