/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.SlotUtil;
import gregtech.client.utils.TooltipHelper;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.input.Mouse;

public class PhantomSlotWidget
extends SlotWidget
implements IGhostIngredientTarget {
    private boolean clearSlotOnRightClick;

    public PhantomSlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        super((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, false, false);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (button == 1 && this.clearSlotOnRightClick && !this.slotReference.func_75211_c().func_190926_b()) {
                this.slotReference.func_75215_d(ItemStack.field_190927_a);
                this.writeClientAction(2, buf -> {});
            } else {
                this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            ItemStack is = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            is.func_190920_e(1);
            this.slotReference.func_75215_d(is);
            this.writeClientAction(1, buffer -> {
                buffer.func_150788_a(this.slotReference.func_75211_c());
                int mouseButton = Mouse.getEventButton();
                boolean shiftDown = TooltipHelper.isShiftDown();
                buffer.func_150787_b(mouseButton);
                buffer.writeBoolean(shiftDown);
            });
            return true;
        }
        return false;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stackHeld = player.field_71071_by.func_70445_o();
        return SlotUtil.slotClickPhantom(this.slotReference, dragType, clickTypeIn, stackHeld);
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    int mouseButton = Mouse.getEventButton();
                    boolean shiftDown = TooltipHelper.isShiftDown();
                    ClickType clickType = shiftDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    SlotUtil.slotClickPhantom(PhantomSlotWidget.this.slotReference, mouseButton, clickType, (ItemStack)ingredient);
                    PhantomSlotWidget.this.writeClientAction(1, buffer -> {
                        buffer.func_150788_a((ItemStack)ingredient);
                        buffer.func_150787_b(mouseButton);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        }});
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack stackHeld;
            try {
                stackHeld = buffer.func_150791_c();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int mouseButton = buffer.func_150792_a();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            SlotUtil.slotClickPhantom(this.slotReference, mouseButton, clickType, stackHeld);
        } else if (id == 2) {
            this.slotReference.func_75215_d(ItemStack.field_190927_a);
        }
    }
}

