/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicLabelWidget
extends Widget {
    protected final Supplier<String> textSupplier;
    private String lastTextValue = "";
    private final int color;

    public DynamicLabelWidget(int xPosition, int yPosition, Supplier<String> text) {
        this(xPosition, yPosition, text, 0x404040);
    }

    public DynamicLabelWidget(int xPosition, int yPosition, Supplier<String> text, int color) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.textSupplier = text;
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSize() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String resultText = this.lastTextValue;
        this.setSize(new Size(fontRenderer.func_78256_a(resultText), fontRenderer.field_78288_b));
        if (this.uiAccess != null) {
            this.uiAccess.notifySizeChange();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        String suppliedText = this.textSupplier.get();
        if (!suppliedText.equals(this.lastTextValue)) {
            this.lastTextValue = suppliedText;
            this.updateSize();
        }
        String[] split = this.textSupplier.get().split("\n");
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position position = this.getPosition();
        for (int i = 0; i < split.length; ++i) {
            fontRenderer.func_78276_b(split[i], position.x, position.y + i * (fontRenderer.field_78288_b + 2), this.color);
        }
    }
}

