/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public final class CoverDefinition {
    private final ResourceLocation coverId;
    private final BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator;
    private final ItemStack dropItemStack;

    public static CoverDefinition getCoverById(ResourceLocation id) {
        return (CoverDefinition)GregTechAPI.COVER_REGISTRY.func_82594_a(id);
    }

    public static CoverDefinition getCoverByNetworkId(int networkId) {
        return GregTechAPI.COVER_REGISTRY.getObjectById(networkId);
    }

    public static int getNetworkIdForCover(CoverDefinition definition) {
        return GregTechAPI.COVER_REGISTRY.getIDForObject(definition);
    }

    public CoverDefinition(ResourceLocation coverId, BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator, ItemStack dropItemStack) {
        this.coverId = coverId;
        this.behaviorCreator = behaviorCreator;
        this.dropItemStack = dropItemStack.func_77946_l();
    }

    public ResourceLocation getCoverId() {
        return this.coverId;
    }

    public ItemStack getDropItemStack() {
        return this.dropItemStack.func_77946_l();
    }

    public CoverBehavior createCoverBehavior(ICoverable metaTileEntity, EnumFacing side) {
        CoverBehavior coverBehavior = this.behaviorCreator.apply(metaTileEntity, side);
        coverBehavior.setCoverDefinition(this);
        return coverBehavior;
    }
}

