/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.model;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import com.jaquadro.minecraft.chameleon.render.helpers.PanelBoxRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class SlaveRenderer {
    private double trimWidth;
    private final ChamRender renderHelper;
    private final PanelBoxRenderer panelRenderer;

    public SlaveRenderer(ChamRender renderer) {
        this.renderHelper = renderer;
        this.panelRenderer = new PanelBoxRenderer(renderer);
    }

    private void start() {
        this.trimWidth = 0.0625;
        this.panelRenderer.setTrimWidth(this.trimWidth);
        this.panelRenderer.setTrimDepth(0.0);
        this.panelRenderer.setTrimColor(ModularBoxRenderer.COLOR_WHITE);
        this.panelRenderer.setPanelColor(ModularBoxRenderer.COLOR_WHITE);
    }

    private void end() {
        this.renderHelper.state.clearRotateTransform();
        this.renderHelper.state.clearUVRotation(1);
    }

    public void renderBasePass(IBlockAccess world, IBlockState state, BlockPos pos, TextureAtlasSprite iconSide, TextureAtlasSprite iconTrim, TextureAtlasSprite iconTopBottom) {
        this.start();
        this.panelRenderer.setTrimIcon(iconTrim);
        this.renderHelper.targetFaceGroup(true);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.panelRenderer.setPanelIcon(dir.func_176740_k() == EnumFacing.Axis.Y ? iconTopBottom : iconSide);
            this.panelRenderer.renderFacePanel(dir, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.panelRenderer.renderFaceTrim(dir, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        this.renderHelper.targetFaceGroup(false);
        this.end();
    }

    public void renderOverlayPass(IBlockAccess world, IBlockState state, BlockPos pos, TextureAtlasSprite sideShadow) {
        this.start();
        this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, 0.0, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, sideShadow);
        this.renderHelper.renderFace(ChamRender.FACE_ZPOS, world, state, pos, sideShadow);
        this.renderHelper.setRenderBounds(0.0, this.trimWidth, this.trimWidth, 1.0, 1.0 - this.trimWidth, 1.0 - this.trimWidth);
        this.renderHelper.renderFace(ChamRender.FACE_XNEG, world, state, pos, sideShadow);
        this.renderHelper.renderFace(ChamRender.FACE_XPOS, world, state, pos, sideShadow);
        this.end();
    }
}

