/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;

public class BlockBrokenMessage
implements IMessage {
    private boolean blockHit;
    private BlockPos blockPos;
    private EnumFacing sideHit;
    private Vec3d hitVec;

    public BlockBrokenMessage() {
        this.blockHit = false;
        this.blockPos = BlockPos.field_177992_a;
        this.sideHit = EnumFacing.UP;
        this.hitVec = new Vec3d(0.0, 0.0, 0.0);
    }

    public BlockBrokenMessage(RayTraceResult result) {
        this.blockHit = result.field_72313_a == RayTraceResult.Type.BLOCK;
        this.blockPos = result.func_178782_a();
        this.sideHit = result.field_178784_b;
        this.hitVec = result.field_72307_f;
    }

    public boolean isBlockHit() {
        return this.blockHit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public EnumFacing getSideHit() {
        return this.sideHit;
    }

    public Vec3d getHitVec() {
        return this.hitVec;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.blockHit);
        buf.writeInt(this.blockPos.func_177958_n());
        buf.writeInt(this.blockPos.func_177956_o());
        buf.writeInt(this.blockPos.func_177952_p());
        buf.writeInt(this.sideHit.func_176745_a());
        buf.writeDouble(this.hitVec.field_72450_a);
        buf.writeDouble(this.hitVec.field_72448_b);
        buf.writeDouble(this.hitVec.field_72449_c);
    }

    public void fromBytes(ByteBuf buf) {
        this.blockHit = buf.readBoolean();
        this.blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.sideHit = EnumFacing.func_82600_a((int)buf.readInt());
        this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static class MessageHandler
    implements IMessageHandler<BlockBrokenMessage, IMessage> {
        public IMessage onMessage(BlockBrokenMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EffortlessBuilding.proxy.getThreadListenerFromContext(ctx).func_152344_a(() -> BuildModes.onBlockBrokenMessage((EntityPlayer)ctx.getServerHandler().field_147369_b, message));
            }
            return null;
        }
    }
}

