/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.helper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;

public class ReachHelper {
    public static int getMaxReach(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return BuildConfig.reach.maxReachCreative;
        }
        if (!BuildConfig.reach.enableReachUpgrades) {
            return BuildConfig.reach.maxReachLevel3;
        }
        int reachUpgrade = ModifierSettingsManager.getModifierSettings(player).getReachUpgrade();
        switch (reachUpgrade) {
            case 0: {
                return BuildConfig.reach.maxReachLevel0;
            }
            case 1: {
                return BuildConfig.reach.maxReachLevel1;
            }
            case 2: {
                return BuildConfig.reach.maxReachLevel2;
            }
            case 3: {
                return BuildConfig.reach.maxReachLevel3;
            }
        }
        return BuildConfig.reach.maxReachLevel0;
    }

    public static int getPlacementReach(EntityPlayer player) {
        return ReachHelper.getMaxReach(player) / 4;
    }

    public static int getMaxBlocksPlacedAtOnce(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return 1000000;
        }
        return MathHelper.func_76143_f((double)Math.pow(ReachHelper.getMaxReach(player), 1.6));
    }

    public static int getMaxBlocksPerAxis(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return 2000;
        }
        return MathHelper.func_76143_f((double)((double)ReachHelper.getMaxReach(player) * 0.3));
    }

    public static boolean canBreakFar(EntityPlayer player) {
        return player.func_184812_l_() || BuildConfig.survivalBalancers.breakFar;
    }
}

