/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;

public class Array {
    public static List<BlockPos> findCoordinates(EntityPlayer player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return coordinates;
        }
        BlockPos pos = startPos;
        Vec3i offset = new Vec3i(a.offset.func_177958_n(), a.offset.func_177956_o(), a.offset.func_177952_p());
        for (int i = 0; i < a.count; ++i) {
            pos = pos.func_177971_a(offset);
            coordinates.add(pos);
        }
        return coordinates;
    }

    public static List<IBlockState> findBlockStates(EntityPlayer player, BlockPos startPos, IBlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<IBlockState> blockStates = new ArrayList<IBlockState>();
        ArraySettings a = ModifierSettingsManager.getModifierSettings(player).getArraySettings();
        if (!Array.isEnabled(a)) {
            return blockStates;
        }
        BlockPos pos = startPos;
        Vec3i offset = new Vec3i(a.offset.func_177958_n(), a.offset.func_177956_o(), a.offset.func_177952_p());
        IItemHandler bagInventory = null;
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemRandomizerBag) {
            bagInventory = ItemRandomizerBag.getBagInventory(itemStack);
        }
        for (int i = 0; i < a.count; ++i) {
            pos = pos.func_177971_a(offset);
            if (bagInventory != null) {
                itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
                blockState = BuildModifiers.getBlockStateFromItem(itemStack, player, startPos, EnumFacing.UP, new Vec3d(0.0, 0.0, 0.0), EnumHand.MAIN_HAND);
            }
            blockStates.add(blockState);
            itemStacks.add(itemStack);
        }
        return blockStates;
    }

    public static boolean isEnabled(ArraySettings a) {
        if (a == null || !a.enabled) {
            return false;
        }
        return a.offset.func_177958_n() != 0 || a.offset.func_177956_o() != 0 || a.offset.func_177952_p() != 0;
    }

    public static class ArraySettings {
        public boolean enabled = false;
        public BlockPos offset = BlockPos.field_177992_a;
        public int count = 5;

        public ArraySettings() {
        }

        public ArraySettings(boolean enabled, BlockPos offset, int count) {
            this.enabled = enabled;
            this.offset = offset;
            this.count = count;
        }

        public int getReach() {
            int x = Math.abs(this.offset.func_177958_n());
            int y = Math.abs(this.offset.func_177956_o());
            int z = Math.abs(this.offset.func_177952_p());
            int largestOffset = Math.max(Math.max(x, y), z);
            return largestOffset * this.count;
        }
    }
}

