/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.capability.ModifierCapabilityManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.network.AddUndoMessage;
import nl.requios.effortlessbuilding.network.ClearUndoMessage;
import nl.requios.effortlessbuilding.network.RequestLookAtMessage;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EffortlessBuilding.BLOCKS);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EffortlessBuilding.ITEMS);
        for (Block block : EffortlessBuilding.BLOCKS) {
            event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("effortlessbuilding", "BuildModifier"), (ICapabilityProvider)new ModifierCapabilityManager.Provider());
            event.addCapability(new ResourceLocation("effortlessbuilding", "BuildMode"), (ICapabilityProvider)new ModeCapabilityManager.Provider());
        }
    }

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("effortlessbuilding")) {
            ConfigManager.sync((String)"effortlessbuilding", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(player).getBuildMode();
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        if (buildMode != BuildModes.BuildModeEnum.NORMAL) {
            event.setCanceled(true);
        } else if (modifierSettings.doQuickReplace()) {
            event.setCanceled(true);
            EffortlessBuilding.packetHandler.sendTo((IMessage)new RequestLookAtMessage(true), (EntityPlayerMP)player);
            EffortlessBuilding.packetHandler.sendTo((IMessage)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()), (EntityPlayerMP)player);
        } else {
            EffortlessBuilding.packetHandler.sendTo((IMessage)new RequestLookAtMessage(false), (EntityPlayerMP)player);
            EffortlessBuilding.packetHandler.sendTo((IMessage)new AddUndoMessage(event.getPos(), event.getBlockSnapshot().getReplacedBlock(), event.getState()), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(event.getPlayer()).getBuildMode();
        if (buildMode != BuildModes.BuildModeEnum.NORMAL && ReachHelper.canBreakFar(event.getPlayer())) {
            event.setCanceled(true);
        } else {
            BuildModes.onBlockBroken(event.getPlayer(), event.getPos(), false);
            EffortlessBuilding.packetHandler.sendTo((IMessage)new AddUndoMessage(event.getPos(), event.getState(), Blocks.field_150350_a.func_176223_P()), (EntityPlayerMP)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!BuildConfig.survivalBalancers.increasedMiningTime) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        float originalBlockHardness = event.getState().func_185887_b(world, pos);
        if (originalBlockHardness < 0.0f) {
            return;
        }
        float totalBlockHardness = 0.0f;
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, pos);
        for (int i = 1; i < coordinates.size(); ++i) {
            BlockPos coordinate = coordinates.get(i);
            IBlockState blockState = world.func_180495_p(coordinate);
            if (!SurvivalHelper.canBreak(world, player, coordinate)) continue;
            totalBlockHardness += blockState.func_185887_b(world, coordinate);
        }
        float percentage = (float)BuildConfig.survivalBalancers.miningTimePercentage / 100.0f;
        totalBlockHardness *= percentage;
        float newSpeed = event.getOriginalSpeed() / (totalBlockHardness += originalBlockHardness) * originalBlockHardness;
        if (Float.isNaN(newSpeed) || newSpeed == 0.0f) {
            newSpeed = 1.0f;
        }
        event.setNewSpeed(newSpeed);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        UndoRedo.clear(player);
        EffortlessBuilding.packetHandler.sendTo((IMessage)new ClearUndoMessage(), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        ModifierSettingsManager.handleNewPlayer(player);
        ModeSettingsManager.handleNewPlayer(player);
        UndoRedo.clear(player);
        EffortlessBuilding.packetHandler.sendTo((IMessage)new ClearUndoMessage(), (EntityPlayerMP)player);
    }
}

