/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.categories.pauto;

import eutros.dynamistics.helper.ItemHelper;
import eutros.dynamistics.helper.JeiHelper;
import eutros.dynamistics.jei.SingletonRecipe;
import eutros.dynamistics.jei.categories.pauto.IWrapperSupplier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;

public class UnpackagingCategory
implements IWrapperSupplier<SingletonRecipe> {
    public static final String UID = "dynamistics:unpackaging";
    private static final int HEIGHT = 126;
    private static final int WIDTH = 146;
    protected static final int GRID_SIZE = 18;
    private final IDrawableStatic background;
    private final IDrawableStatic slot;
    private final IDrawable icon;
    private final IDrawableStatic arrow;
    protected int gridStartY;

    public UnpackagingCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.slot = JeiHelper.getSlotDrawable();
        this.background = guiHelper.createBlankDrawable(146, 126);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(new ResourceLocation("packagedauto", (this.isUnpackaging() ? "un" : "") + "packager")))));
        this.gridStartY = 63;
        this.arrow = guiHelper.createDrawable(new ResourceLocation("dynamistics", "textures/gui/arrows.png"), this.isUnpackaging() ? 0 : 32, 0, 32, 32);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"dynamistics.category.title.pauto.unpackage", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "PackagedAuto";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, (146 - this.arrow.getWidth()) / 2, this.isUnpackaging() ? 28 : 98 - this.arrow.getHeight());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull SingletonRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ItemStack packageStack = recipeWrapper.stack;
        stacks.init(10, this.isUnpackaging(), 65, this.isUnpackaging() ? 8 : 102);
        stacks.set(10, packageStack);
        stacks.setBackground(10, (IDrawable)this.slot);
        NonNullList inputs = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        if (packageStack.func_77942_o()) {
            IRecipeType recipeType;
            NBTTagCompound tag = packageStack.func_77978_p();
            assert (tag != null);
            String typeId = tag.func_74779_i("RecipeType");
            if (!typeId.isEmpty() && (recipeType = RecipeTypeRegistry.getRecipeType((ResourceLocation)new ResourceLocation(typeId))) != null) {
                IRecipeInfo recipeInfo = recipeType.getNewRecipeInfo();
                recipeInfo.readFromNBT(tag);
                IPackagePattern pattern = (IPackagePattern)recipeInfo.getPatterns().get(tag.func_74771_c("Index"));
                List recipeInputs = pattern.getInputs();
                for (int i = 0; i < recipeInputs.size(); ++i) {
                    ItemStack s = (ItemStack)recipeInputs.get(i);
                    inputs.set(i, (Object)s);
                }
            }
        }
        int gridStartX = 46;
        for (int i = 0; i < inputs.size(); ++i) {
            stacks.init(i, !this.isUnpackaging(), gridStartX + 18 * (i % 3), this.gridStartY + 18 * (i / 3));
            stacks.set(i, (ItemStack)inputs.get(i));
            stacks.setBackground(i, (IDrawable)this.slot);
        }
    }

    protected boolean isUnpackaging() {
        return true;
    }

    @Override
    @Nonnull
    public List<SingletonRecipe> makeWrappers(ItemStack stack) {
        return Collections.singletonList(new SingletonRecipe(stack, this.isUnpackaging()));
    }

    @Override
    @Nonnull
    public ItemStack getFallbackStack() {
        return ItemHelper.PAuto.EXAMPLE_PACKAGE;
    }
}

