/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.common.unification;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.brackets.BracketHandlerBlockState;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import stanhebben.zenscript.annotations.Optional;

public class MaterialRegistry {
    public static final List<StoneType> STONE_TYPE_LIST = new ArrayList<StoneType>();

    public static OrePrefix registerOrePrefix(String name, float amount, @Optional String iconType, @Optional long flags) {
        MaterialIconType materialIconType;
        if (OrePrefix.getPrefix((String)name) != null) {
            CraftTweakerAPI.logError((String)("OrePrefix with name " + name + " is already registered."));
            return null;
        }
        if (iconType == null || iconType.isEmpty()) {
            iconType = name;
        }
        if ((materialIconType = (MaterialIconType)MaterialIconType.ICON_TYPES.get(iconType)) == null) {
            materialIconType = new MaterialIconType(iconType);
        }
        return new OrePrefix(name, (long)(3628800.0f * amount), null, materialIconType, flags, null);
    }

    public static void registerStoneType(int id, String name, String orePrefix, Material material, String blockState, IBlockStateMatcher stateMatcher, boolean shouldBeDroppedAsItem) {
        OrePrefix prefix = OrePrefix.getPrefix((String)orePrefix);
        if (prefix == null) {
            prefix = new OrePrefix(orePrefix, -1L, null, MaterialIconType.ore, 1L, OrePrefix.Conditions.hasOreProperty);
        }
        Supplier<IBlockState> stateSupplier = () -> {
            crafttweaker.api.block.IBlockState ctBlockState = MaterialRegistry.getCtBlockState(blockState);
            if (ctBlockState == null) {
                return null;
            }
            return CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)ctBlockState);
        };
        Predicate<IBlockState> spawnPredicate = stateMatcher == null ? state -> {
            crafttweaker.api.block.IBlockState ctBlockState = MaterialRegistry.getCtBlockState(blockState);
            if (ctBlockState == null) {
                return false;
            }
            return state.equals(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)ctBlockState));
        } : state -> stateMatcher.matches(CraftTweakerMC.getBlockState((IBlockState)state));
        StoneType stoneType = new StoneType(id, name, SoundType.field_185851_d, prefix, material, stateSupplier, spawnPredicate, shouldBeDroppedAsItem);
        STONE_TYPE_LIST.add(stoneType);
    }

    private static crafttweaker.api.block.IBlockState getCtBlockState(String string) {
        String[] parts = string.split(":", 3);
        String properties = "";
        if (parts.length > 2) {
            properties = parts[2];
        }
        return BracketHandlerBlockState.getBlockState((String)(parts[0] + ":" + parts[1]), (String)properties);
    }
}

