/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.util;

import com.sofodev.armorplus.common.util.TextUtils;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenUtils {
    public static final int CHUNK_SIZE = 16;

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150355_j || blockAt == Blocks.field_150358_i || blockAt == Blocks.field_150353_l || blockAt == Blocks.field_150356_k || blockAt != Blocks.field_150350_a;
        }
        return y;
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, ChunkPos chunk, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new AssertionError((Object)TextUtils.translatedText("error.world_gen.armorplus.generator_height", maxHeight, minHeight, maxHeight));
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int y = minHeight + rand.nextInt(heightDiff);
            WorldGenUtils.generate(generator, world, rand, chunk, y);
        }
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, ChunkPos chunk, int chancesToSpawn, int posY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            WorldGenUtils.generate(generator, world, rand, chunk, posY);
        }
    }

    private static void generate(WorldGenerator generator, World world, Random rand, ChunkPos chunk, int y) {
        int x = WorldGenUtils.getExactRandPos(chunk.getX(), rand);
        int z = WorldGenUtils.getExactRandPos(chunk.getZ(), rand);
        BlockPos orePos = new BlockPos(x, y, z);
        generator.func_180709_b(world, rand, orePos);
    }

    public static int getExactRandPos(int chunkPos, Random rand) {
        return WorldGenUtils.x16(chunkPos) + rand.nextInt(16);
    }

    public static int x16(int chunkCord) {
        return chunkCord * 16;
    }

    public static void runGenerator(WorldGenerator generator, World world, Random rand, int chancesToSpawn, BlockPos blockPos) {
        IntStream.range(0, chancesToSpawn).forEachOrdered(i -> generator.func_180709_b(world, rand, blockPos));
    }

    public static class ChunkPos {
        private final int chunkX;
        private final int chunkZ;

        public ChunkPos(int chunkX, int chunkZ) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        public int getX() {
            return this.chunkX;
        }

        public int getZ() {
            return this.chunkZ;
        }
    }
}

