/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.base.special;

import com.sofodev.armorplus.api.properties.AbilityCanceller;
import com.sofodev.armorplus.api.properties.AbilityProvider;
import com.sofodev.armorplus.api.properties.iface.IEffectHolder;
import com.sofodev.armorplus.api.properties.iface.IRemovable;
import com.sofodev.armorplus.api.properties.iface.IRepairable;
import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialSword;
import com.sofodev.armorplus.common.registry.items.base.special.effects.Ignite;
import com.sofodev.armorplus.common.registry.items.base.special.effects.Negative;
import com.sofodev.armorplus.common.registry.items.base.special.effects.WeaponEffects;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.PotionUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public enum Swords implements IEffectHolder,
IRemovable,
IRepairable
{
    COAL(ItemSpecialSword.COAL_SWORD, ItemStackUtils.getItemStack((Object)Blocks.field_150402_ci), ModConfig.RegistryConfig.coal),
    LAPIS(ItemSpecialSword.LAPIS_SWORD, ItemStackUtils.getItemStack((Object)Blocks.field_150368_y), ModConfig.RegistryConfig.lapis),
    REDSTONE(ItemSpecialSword.REDSTONE_SWORD, ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX), ModConfig.RegistryConfig.redstone),
    EMERALD(ItemSpecialSword.EMERALD_SWORD, ItemStackUtils.getItemStack((Object)Blocks.field_150475_bE), ModConfig.RegistryConfig.emerald),
    OBSIDIAN(ItemSpecialSword.OBSIDIAN_SWORD, ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), ModConfig.RegistryConfig.obsidian),
    INFUSED_LAVA(ItemSpecialSword.INFUSED_LAVA_SWORD, ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), ModConfig.RegistryConfig.lava),
    GUARDIAN(ItemSpecialSword.GUARDIAN_SWORD, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1), ModConfig.RegistryConfig.guardian),
    SUPER_STAR(ItemSpecialSword.SUPER_STAR_SWORD, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2), ModConfig.RegistryConfig.super_star),
    ENDER_DRAGON(ItemSpecialSword.ENDER_DRAGON_SWORD, ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3), ModConfig.RegistryConfig.ender_dragon);

    private final Item.ToolMaterial material;
    private final ItemStack repairStack;
    private final TextFormatting textFormatting;
    private final List<String> effect;
    private final Negative negative;
    private final Ignite ignite;

    private Swords(Item.ToolMaterial materialIn, ItemStack repairStackIn, ModConfig.RegistryConfig.OriginMaterial material) {
        this.material = materialIn;
        this.repairStack = repairStackIn == null ? ItemStack.field_190927_a : repairStackIn;
        this.textFormatting = TextFormatting.func_96300_b((String)material.weapons.itemNameColor);
        WeaponEffects effects = new WeaponEffects(material);
        this.negative = effects.getNegative();
        this.ignite = effects.getIgnite();
        this.effect = Swords.setToolTip(this.negative.getEffects(), this.negative.getEffectLevels());
    }

    @Override
    public AbilityProvider getApplicableAbilities() {
        return new AbilityProvider(this.negative.getEffects(), this.negative.getEffectLevels(), this.negative.getEffectDurations());
    }

    @Override
    public AbilityCanceller getRemovableAbilities() {
        return new AbilityCanceller();
    }

    public static List<String> setToolTip(String[] effectName, int[] effectLevel) {
        return IntStream.range(0, effectLevel.length).mapToObj(i -> PotionUtils.localizePotion(effectName[i]) + " " + (effectLevel[i] + 1)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.material;
    }

    public List<String> getEffects() {
        return this.effect;
    }

    @Override
    public ItemStack getRepairStack() {
        return this.repairStack;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        if (this.ignite.isEnabled()) {
            target.func_70015_d(this.ignite.getFireSeconds());
        }
        ArmorPlusItemUtils.applyNegativeEffect(target, this.negative);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip) {
        ToolTipUtils.addSpecialInformation(tooltip, this.negative, this.ignite, this.getTextFormatting());
    }
}

